/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ftp;

import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractUser;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.web.entity.Folder;
import org.structr.web.entity.User;

public class StructrFtpUser
implements org.apache.ftpserver.ftplet.User {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrFtpUser.class.getName());
    private final User structrUser;
    private SecurityContext securityContext;

    public StructrFtpUser(SecurityContext securityContext, User structrUser) {
        this.securityContext = securityContext;
        this.structrUser = structrUser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getName() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            String name = (String)this.structrUser.getProperty((PropertyKey)User.name);
            tx.success();
            String string = name;
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getPassword() {
        throw new UnsupportedOperationException("We don't disclose user passwords ever.");
    }

    public List<Authority> getAuthorities() {
        ArrayList<Authority> auths = new ArrayList<Authority>();
        auths.add((Authority)new ConcurrentLoginPermission(10, 10));
        auths.add((Authority)new WritePermission());
        return auths;
    }

    public List<Authority> getAuthorities(Class<? extends Authority> type) {
        return this.getAuthorities();
    }

    public AuthorizationRequest authorize(AuthorizationRequest request) {
        List<Authority> authorities = this.getAuthorities();
        if (authorities == null) {
            return null;
        }
        boolean someoneCouldAuthorize = false;
        for (Authority authority : authorities) {
            if (!authority.canAuthorize(request)) continue;
            logger.info("Authority {} can authorize {}", new Object[]{authority, request});
            someoneCouldAuthorize = true;
            if ((request = authority.authorize(request)) != null) continue;
            logger.info("Authorization of request {} failed", new Object[]{request});
            return null;
        }
        if (someoneCouldAuthorize) {
            logger.info("Request {} successfully authorized", new Object[]{request});
            return request;
        }
        return null;
    }

    public int getMaxIdleTime() {
        return 3000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getEnabled() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            boolean blocked = (Boolean)this.structrUser.getProperty((PropertyKey)User.blocked);
            tx.success();
            boolean bl = !blocked;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHomeDirectory() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            String homeDir = (String)((Folder)this.structrUser.getProperty((PropertyKey)User.homeDirectory)).getProperty((PropertyKey)Folder.name);
            tx.success();
            String string = homeDir;
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AbstractUser getStructrUser() {
        return this.structrUser;
    }
}

