/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.SignalListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.AccessMode;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.console.Console;
import org.structr.console.tabcompletion.TabCompletionResult;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.files.ssh.TerminalEmulator;
import org.structr.files.ssh.TerminalHandler;
import org.structr.files.ssh.XTermTerminalEmulator;
import org.structr.util.Writable;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.User;

public class StructrConsoleCommand
implements Command,
SignalListener,
TerminalHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrConsoleCommand.class.getName());
    private final List<String> commandHistory = new LinkedList<String>();
    private final StringBuilder lastBlockChars = new StringBuilder();
    private final StringBuilder buf = new StringBuilder();
    private Console.ConsoleMode consoleMode = Console.ConsoleMode.JavaScript;
    private String command = null;
    private Console console = null;
    private TerminalEmulator term = null;
    private ExitCallback callback = null;
    private InputStream in = null;
    private OutputStream out = null;
    private User user = null;
    private int inBlock = 0;
    private int inSingleQuotes = 0;
    private int inDoubleQuotes = 0;
    private int inArray = 0;
    private int inBraces = 0;

    public StructrConsoleCommand(SecurityContext securityContext) {
        this(securityContext, Console.ConsoleMode.JavaScript, null);
    }

    public StructrConsoleCommand(SecurityContext securityContext, Console.ConsoleMode consoleMode, String command) {
        this.console = new Console(securityContext, consoleMode, null);
        this.consoleMode = consoleMode;
        this.command = command;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        env.addSignalListener((SignalListener)this);
        String userName = (String)env.getEnv().get("USER");
        if (userName != null) {
            App app = StructrApp.getInstance();
            try (Tx tx = app.tx();){
                this.user = (User)app.nodeQuery(User.class).andName(userName).getFirst();
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        } else {
            logger.warn("Cannot start Structr shell, no username set!");
            return;
        }
        if (this.user == null) {
            logger.warn("Cannot start Structr shell, user not found for name {}!", (Object)userName);
            return;
        }
        String terminalType = (String)env.getEnv().get("TERM");
        if (terminalType != null) {
            if (terminalType.startsWith("xterm") || terminalType.startsWith("vt100") || terminalType.startsWith("vt220")) {
                this.term = new XTermTerminalEmulator(this.in, this.out, this);
            } else {
                logger.warn("Unsupported terminal type {}, aborting.", (Object)terminalType);
            }
            logger.warn("No terminal type provided, aborting.", (Object)terminalType);
        }
        if (this.term != null) {
            this.term.start();
            this.term.print(new Object[]{"Welcome to the "});
            this.term.setBold(true);
            this.term.print(new Object[]{"Structr 2.1"});
            this.term.setBold(false);
            this.term.print(new Object[]{" JavaScript console. Use <Shift>+<Tab> to switch modes."});
            this.term.println();
            this.displayPrompt();
        } else {
            OutputStreamWritable writable = new OutputStreamWritable(this.out);
            if (this.command != null) {
                try {
                    this.console.run(this.command, (Writable)writable);
                }
                catch (FrameworkException fex) {
                    writable.println(fex.getMessage());
                }
            } else {
                writable.println("No command specified, aborting.");
            }
            this.callback.onExit(1);
        }
    }

    public void destroy() {
        if (this.term != null) {
            this.term.stopEmulator();
        }
    }

    public void signal(Signal signal) {
        logger.info("Received signal {}", (Object)signal.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLine(String line) throws IOException {
        block23: {
            try {
                this.term.flush();
                if (!StringUtils.isNotBlank((CharSequence)line)) break block23;
                if (this.insideOfBlockOrStructure()) {
                    this.buf.append(line);
                    this.buf.append("\r\n");
                } else {
                    this.buf.append(line);
                }
                if ("exit".equals(line) || "quit".equals(line)) {
                    this.term.stopEmulator();
                    break block23;
                }
                this.checkForBlockChars(line.trim());
                if (this.insideOfBlockOrStructure()) break block23;
                String command = this.buf.toString();
                this.clearBlockStatus();
                this.commandHistory.add(command);
                try (Tx tx = StructrApp.getInstance((SecurityContext)this.console.getSecurityContext()).tx();){
                    this.console.run(command, (Writable)this.term);
                    tx.success();
                }
                catch (Throwable t) {
                    String message = t.getMessage();
                    if (message != null) {
                        this.term.println(new Object[]{message});
                        break block23;
                    }
                    logger.warn("", t);
                    this.term.println(new Object[]{t.getClass().getSimpleName() + " encountered."});
                }
            }
            catch (Throwable t) {
                logger.warn("", t);
                this.term.println(new Object[]{t.getClass().getSimpleName() + " encountered."});
            }
            finally {
                this.term.flush();
            }
        }
    }

    @Override
    public void handleExit() {
        if (this.callback != null) {
            this.callback.onExit(0);
        }
    }

    public String getPrompt() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\u001b[1m");
        buffer.append(this.console.getPrompt());
        if (this.insideOfBlockOrStructure() && this.lastBlockChars.length() > 0) {
            buffer.append(this.lastBlockChars.charAt(this.lastBlockChars.length() - 1));
        } else {
            buffer.append("/");
        }
        buffer.append(">");
        buffer.append("\u001b[0m");
        buffer.append(" ");
        return buffer.toString();
    }

    public boolean isAllowed(AbstractFile file, Permission permission, boolean explicit) {
        if (file == null) {
            return false;
        }
        SecurityContext securityContext = SecurityContext.getInstance((Principal)this.user, (AccessMode)AccessMode.Backend);
        if (Permission.read.equals(permission) && !explicit) {
            return file.isVisibleToAuthenticatedUsers() || file.isVisibleToPublicUsers() || file.isGranted(permission, securityContext);
        }
        return file.isGranted(permission, securityContext);
    }

    @Override
    public List<String> getCommandHistory() {
        return this.commandHistory;
    }

    @Override
    public void displayPrompt() throws IOException {
        this.term.setBold(true);
        this.term.setTextColor(7);
        this.term.print(new Object[]{this.getPrompt()});
    }

    @Override
    public void handleLogoutRequest() throws IOException {
        this.term.println(new Object[]{"logout"});
        this.term.stopEmulator();
    }

    @Override
    public void handleCtrlC() throws IOException {
        this.clearBlockStatus();
        this.term.print(new Object[]{"^C"});
        this.term.clearLineBuffer();
        this.term.handleNewline();
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void handleShiftTab() throws IOException {
        if (!this.insideOfBlockOrStructure()) {
            switch (this.consoleMode) {
                case REST: {
                    this.consoleMode = Console.ConsoleMode.JavaScript;
                    break;
                }
                case JavaScript: {
                    this.consoleMode = Console.ConsoleMode.StructrScript;
                    break;
                }
                case StructrScript: {
                    this.consoleMode = Console.ConsoleMode.Cypher;
                    break;
                }
                case Cypher: {
                    this.consoleMode = Console.ConsoleMode.AdminShell;
                    break;
                }
                case AdminShell: {
                    this.consoleMode = Console.ConsoleMode.REST;
                }
            }
            this.term.handleString("Console.setMode('" + this.consoleMode.name() + "')");
            this.term.clearTabCount();
            this.term.setBold(true);
            this.term.setTextColor(3);
            this.term.handleNewline();
        }
    }

    @Override
    public void handleTab(int tabCount) throws IOException {
        StringBuilder lineBuffer;
        List tabCompletion;
        if (!this.insideOfBlockOrStructure() && !(tabCompletion = this.console.getTabCompletion((lineBuffer = this.term.getLineBuffer()).toString())).isEmpty()) {
            if (tabCompletion.size() == 1) {
                TabCompletionResult result = (TabCompletionResult)tabCompletion.iterator().next();
                this.term.handleString(result.getCompletion());
                this.term.handleString(result.getSuffix());
                this.term.clearTabCount();
            } else if (tabCount > 1) {
                this.term.println();
                Iterator it = tabCompletion.iterator();
                while (it.hasNext()) {
                    TabCompletionResult result = (TabCompletionResult)it.next();
                    this.term.print(new Object[]{result.getCommand()});
                    if (!it.hasNext()) continue;
                    this.term.print(new Object[]{" "});
                }
                this.term.println();
                this.term.print(new Object[]{this.getPrompt()});
                this.term.print(new Object[]{this.term.getLineBuffer().toString()});
            }
        }
    }

    public void flush() throws IOException {
        if (this.term != null) {
            this.term.flush();
        }
    }

    private boolean insideOfBlockOrStructure() {
        boolean singleQuotes = this.inSingleQuotes % 2 != 0;
        boolean doubleQuotes = this.inDoubleQuotes % 2 != 0;
        return this.inBlock > 0 || doubleQuotes || singleQuotes || this.inArray > 0 || this.inBraces > 0;
    }

    private void checkForBlockChars(String line) {
        try {
            block12: for (char c : line.toCharArray()) {
                switch (c) {
                    case '{': {
                        this.lastBlockChars.append("{");
                        ++this.inBlock;
                        continue block12;
                    }
                    case '}': {
                        this.lastBlockChars.setLength(Math.max(0, this.lastBlockChars.length() - 1));
                        --this.inBlock;
                        continue block12;
                    }
                    case '[': {
                        this.lastBlockChars.append("[");
                        ++this.inArray;
                        continue block12;
                    }
                    case ']': {
                        this.lastBlockChars.setLength(Math.max(0, this.lastBlockChars.length() - 1));
                        --this.inArray;
                        continue block12;
                    }
                    case '(': {
                        this.lastBlockChars.append("(");
                        ++this.inBraces;
                        continue block12;
                    }
                    case ')': {
                        this.lastBlockChars.setLength(Math.max(0, this.lastBlockChars.length() - 1));
                        --this.inBraces;
                        continue block12;
                    }
                    case '\"': {
                        ++this.inDoubleQuotes;
                        if (this.inDoubleQuotes % 2 == 0) {
                            this.lastBlockChars.setLength(Math.max(0, this.lastBlockChars.length() - 1));
                            continue block12;
                        }
                        this.lastBlockChars.append("\"");
                        continue block12;
                    }
                    case '\'': {
                        ++this.inSingleQuotes;
                        if (this.inSingleQuotes % 2 == 0) {
                            this.lastBlockChars.setLength(Math.max(0, this.lastBlockChars.length() - 1));
                            continue block12;
                        }
                        this.lastBlockChars.append("'");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void clearBlockStatus() {
        this.inSingleQuotes = 0;
        this.inDoubleQuotes = 0;
        this.inBraces = 0;
        this.inBlock = 0;
        this.inArray = 0;
        this.buf.setLength(0);
    }

    private static class OutputStreamWritable
    implements Writable {
        private Writer writer = null;

        public OutputStreamWritable(OutputStream out) {
            this.writer = new OutputStreamWriter(out);
        }

        public void print(Object ... text) throws IOException {
            if (text != null) {
                for (Object o : text) {
                    if (o != null) {
                        this.writer.write(o.toString().replaceAll("\n", "\r\n"));
                        continue;
                    }
                    this.writer.write("null");
                }
            }
            this.writer.flush();
        }

        public void println(Object ... text) throws IOException {
            this.print(text);
            this.println();
            this.writer.flush();
        }

        public void println() throws IOException {
            this.writer.write(10);
            this.writer.write(13);
        }

        public void flush() throws IOException {
            this.writer.flush();
        }
    }
}

