/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh;

import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Group;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.StructrSSHFile;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;
import org.structr.web.entity.User;

public class StructrPosixFileAttributes
implements PosixFileAttributes {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrPosixFileAttributes.class.getName());
    final AbstractFile file;

    StructrPosixFileAttributes(StructrSSHFile path) {
        this.file = path.getActualFile();
    }

    @Override
    public UserPrincipal owner() {
        UserPrincipal owner = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            owner = () -> ((Principal)this.file.getOwnerNode()).getName();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return owner;
    }

    @Override
    public GroupPrincipal group() {
        List groups = (List)this.file.getOwnerNode().getProperty((PropertyKey)User.groups);
        return groups != null && groups.size() > 0 ? () -> ((Group)((Group)groups.get(0))).getName() : null;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_READ);
        return permissions;
    }

    @Override
    public FileTime lastModifiedTime() {
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            time = FileTime.fromMillis(this.file.getLastModifiedDate().getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public FileTime lastAccessTime() {
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            time = FileTime.fromMillis(this.file.getLastModifiedDate().getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public FileTime creationTime() {
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            time = FileTime.fromMillis(this.file.getCreatedDate().getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public boolean isRegularFile() {
        boolean isRegularFile = false;
        try (Tx tx = StructrApp.getInstance().tx();){
            isRegularFile = (Boolean)this.file.getProperty((PropertyKey)FileBase.isFile);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return isRegularFile;
    }

    @Override
    public boolean isDirectory() {
        boolean isDirectory = false;
        try (Tx tx = StructrApp.getInstance().tx();){
            isDirectory = (Boolean)this.file.getProperty((PropertyKey)Folder.isFolder);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return isDirectory;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        long size = 0L;
        try (Tx tx = StructrApp.getInstance().tx();){
            size = (Long)this.file.getProperty((PropertyKey)FileBase.size);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return size;
    }

    @Override
    public Object fileKey() {
        String uuid = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            uuid = this.file.getUuid();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return uuid;
    }
}

