/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;

public class StructrSSHFile
implements Path {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrSSHFile.class.getName());
    protected SecurityContext securityContext = null;
    protected FileSystem fileSystem = null;
    protected StructrSSHFile parent = null;
    protected AbstractFile actualFile = null;
    protected String name = null;

    public StructrSSHFile(SecurityContext securityContext) {
        this(null, "/", null);
        this.securityContext = securityContext;
    }

    public StructrSSHFile(StructrSSHFile parent, String name, AbstractFile actualFile) {
        this.actualFile = actualFile;
        this.parent = parent;
        this.name = name;
        if (parent != null) {
            this.fileSystem = parent.getFileSystem();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.name + ")";
    }

    public SecurityContext getSecurityContext() {
        if (this.parent != null) {
            return this.parent.getSecurityContext();
        }
        return this.securityContext;
    }

    public AbstractFile getActualFile() {
        return this.actualFile;
    }

    public void setActualFile(AbstractFile file) {
        this.actualFile = file;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StructrSSHFile findFile(String path) {
        if ("/".equals(path)) {
            return this.getRootFolder();
        }
        App app = StructrApp.getInstance((SecurityContext)this.getRootFolder().getSecurityContext());
        boolean isAbsolute = path.startsWith("/");
        String localPath = isAbsolute ? path.substring(1) : path;
        String[] parts = localPath.split("[/]+");
        String localPart = parts[0];
        if (".".equals(path)) {
            return this;
        }
        if ("..".equals(path)) {
            return this.parent;
        }
        if (isAbsolute && this.parent != null) {
            return this.getRootFolder().findFile(path);
        }
        try (Tx tx = app.tx();){
            for (Folder folder : this.getFolders()) {
                String folderName = folder.getName();
                if (!localPart.equals(folderName)) continue;
                StructrSSHFile matchingFolder = new StructrSSHFile(this, folderName, (AbstractFile)folder);
                if (parts.length > 1) {
                    StructrSSHFile structrSSHFile = matchingFolder.findFile(localPath.substring(folderName.length() + 1));
                    return structrSSHFile;
                }
                StructrSSHFile structrSSHFile = matchingFolder;
                return structrSSHFile;
            }
            for (FileBase file : this.getFiles()) {
                String fileName = file.getName();
                if (!localPart.equals(fileName)) continue;
                if (parts.length > 1) {
                    throw new IllegalStateException("Found file where folder was expected, aborting.");
                }
                StructrSSHFile structrSSHFile = new StructrSSHFile(this, fileName, (AbstractFile)file);
                return structrSSHFile;
            }
            tx.success();
            return new StructrSSHFile(this, path, null);
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return new StructrSSHFile(this, path, null);
    }

    private StructrSSHFile getRootFolder() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    protected List<Folder> getFolders() throws FrameworkException {
        if (this.actualFile != null && this.parent != null) {
            return (List)this.actualFile.getProperty((PropertyKey)Folder.folders);
        }
        return StructrApp.getInstance((SecurityContext)this.getSecurityContext()).nodeQuery(Folder.class).and((PropertyKey)AbstractFile.parent, null).getAsList();
    }

    protected List<FileBase> getFiles() throws FrameworkException {
        if (this.actualFile != null && this.parent != null) {
            return (List)this.actualFile.getProperty((PropertyKey)Folder.files);
        }
        return StructrApp.getInstance((SecurityContext)this.getSecurityContext()).nodeQuery(FileBase.class).and((PropertyKey)AbstractFile.parent, null).getAsList();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public Path getRoot() {
        return this.getFileSystem().getPath("/", new String[0]);
    }

    @Override
    public Path getFileName() {
        return Paths.get(this.name, new String[0]);
    }

    @Override
    public Path getParent() {
        return this.parent;
    }

    @Override
    public int getNameCount() {
        logger.info("Method not implemented yet");
        return 0;
    }

    @Override
    public Path getName(int i) {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public Path subpath(int i, int i1) {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public boolean startsWith(Path path) {
        logger.info("Method not implemented yet");
        return false;
    }

    @Override
    public boolean startsWith(String string) {
        logger.info("Method not implemented yet");
        return false;
    }

    @Override
    public boolean endsWith(Path path) {
        logger.info("Method not implemented yet");
        return false;
    }

    @Override
    public boolean endsWith(String string) {
        logger.info("Method not implemented yet");
        return false;
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path resolve(Path path) {
        return this.findFile(path.toString());
    }

    @Override
    public Path resolve(String string) {
        return this.findFile(string);
    }

    @Override
    public Path resolveSibling(Path path) {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public Path resolveSibling(String string) {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public Path relativize(Path path) {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public URI toUri() {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public Path toAbsolutePath() {
        return this;
    }

    @Override
    public Path toRealPath(LinkOption ... los) throws IOException {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public File toFile() {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public WatchKey register(WatchService ws, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier ... mdfrs) throws IOException {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public WatchKey register(WatchService ws, WatchEvent.Kind<?> ... kinds) throws IOException {
        logger.info("Method not implemented yet");
        return null;
    }

    @Override
    public Iterator<Path> iterator() {
        ArrayList<Path> pathElements = new ArrayList<Path>();
        pathElements.add(this);
        for (Path _parent = this.getParent(); _parent != null; _parent = _parent.getParent()) {
            pathElements.add(_parent);
        }
        Collections.reverse(pathElements);
        return pathElements.iterator();
    }

    @Override
    public int compareTo(Path path) {
        logger.info("Method not implemented yet");
        return 0;
    }
}

