/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.structr.files.ssh.AbstractTerminalEmulator;
import org.structr.files.ssh.TerminalHandler;

public class XTermTerminalEmulator
extends AbstractTerminalEmulator {
    public XTermTerminalEmulator(InputStream in, OutputStream out, TerminalHandler handler) {
        super(in, out, handler);
    }

    @Override
    public void handlePageUp() throws IOException {
    }

    @Override
    public void handlePageDown() throws IOException {
    }

    @Override
    public void handleInsert() throws IOException {
    }

    @Override
    public void handleHome() throws IOException {
        int offset = this.lineLength;
        for (int i = 0; i < offset; ++i) {
            this.handleCursorLeft();
        }
    }

    @Override
    public void handleEnd() throws IOException {
        int offset = this.lineLength - this.cursorPosition;
        for (int i = 0; i < offset; ++i) {
            this.handleCursorRight();
        }
    }

    @Override
    public void handleCursorLeft() throws IOException {
        if (this.cursorPosition > 0 && this.echo) {
            if (this.echo) {
                this.writer.write(27);
                this.writer.write(91);
                this.writer.write(68);
            }
            --this.cursorPosition;
        }
    }

    @Override
    public void handleCursorRight() throws IOException {
        if (this.cursorPosition < this.lineLength) {
            if (this.echo) {
                this.writer.write(27);
                this.writer.write(91);
                this.writer.write(67);
            }
            ++this.cursorPosition;
        }
    }

    @Override
    public void handleBackspace() throws IOException {
        if (this.echo) {
            if (this.cursorPosition > 0) {
                if (this.cursorPosition < this.lineLength) {
                    this.writer.write(8);
                    --this.cursorPosition;
                    this.handleDelete();
                } else {
                    this.writer.write(8);
                    this.writer.write(32);
                    this.writer.write(8);
                    --this.cursorPosition;
                    this.lineBuffer.deleteCharAt(this.cursorPosition);
                }
            }
        } else if (this.cursorPosition > 0) {
            --this.cursorPosition;
            this.lineBuffer.deleteCharAt(this.cursorPosition);
        }
        this.lineLength = this.lineBuffer.length();
    }

    @Override
    public void handleDelete() throws IOException {
        if (this.cursorPosition >= 0 && this.cursorPosition < this.lineLength) {
            if (this.echo) {
                this.writer.write(27);
                this.writer.write(91);
                this.writer.write(49);
                this.writer.write(80);
            }
            this.lineBuffer.deleteCharAt(this.cursorPosition);
            this.lineLength = this.lineBuffer.length();
        }
    }

    @Override
    public void handleNewline() throws IOException {
        String line = this.lineBuffer.toString();
        this.lineBuffer.setLength(0);
        this.cursorPosition = 0;
        this.lineLength = 0;
        this.println();
        this.handleLineInternal(line);
        this.terminalHandler.displayPrompt();
    }

    public void println() throws IOException {
        this.writer.write(10);
        this.writer.write(13);
    }

    @Override
    public void handleTab(int tabCount) throws IOException {
        this.terminalHandler.handleTab(tabCount);
    }

    @Override
    public void handleShiftTab() throws IOException {
        this.terminalHandler.handleShiftTab();
    }

    @Override
    public void setBold(boolean bold) throws IOException {
        this.writer.write(27);
        this.writer.write(91);
        this.writer.write(bold ? 49 : 48);
        this.writer.write(109);
        this.writer.flush();
    }

    @Override
    public void setTextColor(int color) throws IOException {
        this.writer.write(27);
        this.writer.write(91);
        this.writer.write(51);
        this.writer.write(Integer.toString(color));
        this.writer.write(109);
        this.writer.flush();
    }

    @Override
    public void setBackgroundColor(int color) throws IOException {
        this.writer.write(27);
        this.writer.write(91);
        this.writer.write(52);
        this.writer.write(Integer.toString(color));
        this.writer.write(109);
        this.writer.flush();
    }

    @Override
    public void handleString(String text) throws IOException {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            this.handleCharacter(text.codePointAt(i));
        }
    }

    @Override
    public void handleCharacter(int c) throws IOException {
        if (this.cursorPosition < this.lineLength && this.echo) {
            this.writer.write(27);
            this.writer.write(91);
            this.writer.write(49);
            this.writer.write(64);
        }
        if (this.echo) {
            this.writer.write(c);
        }
        this.lineBuffer.insert(this.cursorPosition, new String(new int[]{c}, 0, 1));
        ++this.cursorPosition;
        this.lineLength = this.lineBuffer.length();
    }

    @Override
    public void setCursorColumnAbsolute(int col) throws IOException {
        this.writer.write(27);
        this.writer.write(91);
        this.writer.write(Integer.toString(col));
        this.writer.write(96);
        this.writer.flush();
    }

    @Override
    public void setCursorColumnRelative(int col) throws IOException {
        this.writer.write(27);
        this.writer.write(91);
        this.writer.write(Integer.toString(col));
        this.writer.write(97);
        this.writer.flush();
    }

    @Override
    public void setCursorPosition(int x, int y) throws IOException {
        this.writer.write(27);
        this.writer.write(91);
        this.writer.write(Integer.toString(x));
        this.writer.write(Integer.toString(y));
        this.writer.write(72);
        this.writer.flush();
    }

    @Override
    public void saveCursor() throws IOException {
        this.writer.write(27);
        this.writer.write(91);
        this.writer.write(115);
        this.writer.flush();
    }

    @Override
    public void restoreCursor() throws IOException {
        this.writer.write(27);
        this.writer.write(91);
        this.writer.write(117);
        this.writer.flush();
    }
}

