/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.files.ssh.filesystem.StructrPath;

public class StructrFilesystemProvider
extends FileSystemProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrFilesystemProvider.class.getName());

    @Override
    public synchronized String getScheme() {
        logger.warn("NOT SUPPORTED: getScheme");
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        logger.warn("NOT SUPPORTED: newFileSystem {}, {}", (Object)uri, env);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized FileSystem getFileSystem(URI uri) {
        logger.warn("NOT SUPPORTED: getFileSystem {}", new Object[]{uri});
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized Path getPath(URI uri) {
        logger.warn("NOT SUPPORTED: getPath {}", (Object)uri);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.checkPath(path).newFileChannel(options, attrs);
    }

    @Override
    public synchronized SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.newFileChannel(path, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.checkPath(dir).getDirectoryStream(filter);
    }

    @Override
    public synchronized void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.checkPath(dir).createDirectory(attrs);
    }

    @Override
    public synchronized void delete(Path path) throws IOException {
        this.checkPath(path).delete();
    }

    @Override
    public synchronized void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.checkPath(source).copy(target, options);
    }

    @Override
    public synchronized void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.checkPath(source).move(target, options);
    }

    @Override
    public synchronized boolean isSameFile(Path path, Path path2) throws IOException {
        return this.checkPath(path).isSameFile(path2);
    }

    @Override
    public synchronized boolean isHidden(Path path) throws IOException {
        logger.warn("NOT SUPPORTED: isHidden {}", (Object)path);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized FileStore getFileStore(Path path) throws IOException {
        logger.warn("NOT SUPPORTED: getFileStore {}", (Object)path);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.checkPath(path).checkAccess(modes);
    }

    @Override
    public synchronized <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        try {
            return this.checkPath(path).getFileAttributeView(type, options);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public synchronized <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return this.checkPath(path).getAttributes(type, options);
    }

    @Override
    public synchronized Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.checkPath(path).getAttributes(attributes, options);
    }

    @Override
    public synchronized void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.checkPath(path).setAttribute(attribute, value, options);
    }

    private StructrPath checkPath(Path obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (!(obj instanceof StructrPath)) {
            throw new ProviderMismatchException();
        }
        return (StructrPath)obj;
    }
}

