/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.files.ssh.filesystem.AbstractDirectoryStream;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.StructrRootAttributes;
import org.structr.files.ssh.filesystem.path.components.StructrComponentsPath;
import org.structr.files.ssh.filesystem.path.file.StructrFilesPath;
import org.structr.files.ssh.filesystem.path.page.StructrPagesPath;
import org.structr.files.ssh.filesystem.path.schema.StructrSchemaPath;

public class StructrRootPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrRootPath.class.getName());
    private final StructrRootAttributes rootAttributes = new StructrRootAttributes("/");
    private final Map<String, StructrPath> rootPaths = new LinkedHashMap<String, StructrPath>();

    public StructrRootPath(StructrFilesystem fs) {
        super(fs);
        this.rootPaths.put(".", this);
        this.rootPaths.put("/", this);
        this.rootPaths.put("files", new StructrFilesPath(fs, this));
        this.rootPaths.put("pages", new StructrPagesPath(fs, this));
        this.rootPaths.put("schema", new StructrSchemaPath(fs, this));
        this.rootPaths.put("components", new StructrComponentsPath(fs, this));
    }

    @Override
    public String toString() {
        return "/";
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        return new RootDirectoryStream(filter);
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        throw new FileAlreadyExistsException(this.toString());
    }

    @Override
    public void delete() throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        return this.rootPaths.get(pathComponent);
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) {
        return this.rootAttributes.toMap(attributes);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) {
        return (T)this.rootAttributes;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class RootDirectoryStream
    extends AbstractDirectoryStream {
        public RootDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
            for (StructrPath p : StructrRootPath.this.rootPaths.values()) {
                if (p.equals(StructrRootPath.this)) continue;
                try {
                    if (filter != null && !filter.accept(p)) continue;
                    this.paths.add(p);
                }
                catch (IOException ioex) {
                    logger.warn("Unable to create root directory stream", (Throwable)ioex);
                }
            }
        }
    }
}

