/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.components;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.relationship.DOMChildren;

public class StructrNonexistingComponentPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrNonexistingComponentPath.class.getName());

    public StructrNonexistingComponentPath(StructrFilesystem fs, StructrPath parent, String name) {
        super(fs, parent, name);
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        return null;
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        int pos = this.name.indexOf("-");
        String componentName = null;
        String componentTag = null;
        if (pos == -1) {
            throw new InvalidPathException(this.name, "Component name must contain tag and name, e.g. div-test");
        }
        componentTag = this.name.substring(0, pos);
        componentName = this.name.substring(pos + 1);
        if (componentName.isEmpty() || componentTag.isEmpty()) {
            throw new InvalidPathException(this.name, "Component name must contain tag and name, e.g. div-test");
        }
        App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
        try (Tx tx = app.tx();){
            ShadowDocument doc = (ShadowDocument)StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext()).nodeQuery(ShadowDocument.class).includeDeletedAndHidden().getFirst();
            for (DOMNode child : (List)doc.getProperty((PropertyKey)Page.elements)) {
                if (child.hasIncomingRelationships(DOMChildren.class) || !componentName.equals(child.getName()) || !componentTag.equals(child.getProperty((PropertyKey)DOMElement.tag))) continue;
                throw new FileAlreadyExistsException(this.name);
            }
            StructrPath.HiddenFileEntry entry = new StructrPath.HiddenFileEntry();
            DOMElement element = (DOMElement)doc.createElement(componentTag);
            element.setProperty((PropertyKey)AbstractNode.name, (Object)componentName);
            for (PropertyKey key : element.getPropertyKeys("ui")) {
                entry.add(key.jsonName());
            }
            for (PropertyKey key : element.getPropertyKeys("_html_")) {
                entry.add(key.jsonName());
            }
            StructrPath.HIDDEN_PROPERTY_FILES.put(element.getUuid(), entry);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    @Override
    public void delete() throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        return null;
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) throws IOException {
        throw new NoSuchFileException(this.name);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) throws IOException {
        throw new NoSuchFileException(this.name);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        throw new NoSuchFileException(this.name);
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean dontCache() {
        return true;
    }
}

