/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.dynamic.File;
import org.structr.files.ssh.filesystem.StructrFileAttributes;
import org.structr.files.ssh.filesystem.StructrFileChannel;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.path.file.StructrFilesPath;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;

public class StructrFilePath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrFilePath.class.getName());
    private AbstractFile cachedActualFile = null;

    public StructrFilePath(StructrFilesystem fs, StructrPath parent, String name) {
        super(fs, parent, name);
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        final Folder folder = (Folder)this.getActualFile();
        if (folder != null) {
            return new DirectoryStream(){
                boolean closed = false;

                @Override
                public Iterator iterator() {
                    if (!this.closed) {
                        App app = StructrApp.getInstance((SecurityContext)StructrFilePath.this.fs.getSecurityContext());
                        LinkedList<StructrFilePath> files = new LinkedList<StructrFilePath>();
                        try (Tx tx = app.tx();){
                            for (Folder folder2 : (List)folder.getProperty((PropertyKey)Folder.folders)) {
                                files.add(new StructrFilePath(StructrFilePath.this.fs, StructrFilePath.this, folder2.getName()));
                            }
                            for (FileBase file : (List)folder.getProperty((PropertyKey)Folder.files)) {
                                files.add(new StructrFilePath(StructrFilePath.this.fs, StructrFilePath.this, file.getName()));
                            }
                            tx.success();
                        }
                        catch (FrameworkException fex) {
                            logger.warn("", (Throwable)fex);
                        }
                        return files.iterator();
                    }
                    return Collections.emptyIterator();
                }

                @Override
                public void close() throws IOException {
                    this.closed = true;
                }
            };
        }
        return null;
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        AbstractFile actualFile = this.getActualFile();
        FileChannel channel = null;
        boolean create = options.contains(StandardOpenOption.CREATE);
        boolean createNew = options.contains(StandardOpenOption.CREATE_NEW);
        boolean write = options.contains(StandardOpenOption.WRITE);
        boolean truncate = options.contains(StandardOpenOption.TRUNCATE_EXISTING);
        boolean append = options.contains(StandardOpenOption.APPEND);
        if (write) {
            try (Tx tx = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext()).tx();){
                if (create || createNew) {
                    if (createNew && actualFile != null) {
                        throw new FileAlreadyExistsException(this.toString());
                    }
                    if (actualFile == null) {
                        try {
                            actualFile = this.createNewFile();
                            this.setParentFolder(actualFile);
                        }
                        catch (FrameworkException fex) {
                            logger.warn("", (Throwable)fex);
                        }
                    }
                }
                if (actualFile != null && actualFile instanceof FileBase) {
                    FileBase file = (FileBase)actualFile;
                    channel = new StructrFileChannel(file.getOutputStream(true, !truncate || append));
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to open file channel for writing of {}: {}", new Object[]{AbstractFile.path, fex.getMessage()});
            }
        } else if (actualFile != null && actualFile instanceof FileBase) {
            try (Tx tx = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext()).tx();){
                channel = FileChannel.open(((FileBase)actualFile).getFileOnDisk().toPath(), options, new FileAttribute[0]);
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to open file channel for reading of {}: {}", new Object[]{AbstractFile.path, fex.getMessage()});
            }
        } else {
            throw new FileNotFoundException("File " + AbstractFile.path.toString() + " does not exist.");
        }
        return channel;
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
        try (Tx tx = app.tx();){
            String name = this.getFileName().toString();
            Folder newFolder = (Folder)app.create(Folder.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.name, (Object)name)});
            this.setParentFolder((AbstractFile)newFolder);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to delete file {}: {}", new Object[]{AbstractFile.path, fex.getMessage()});
        }
    }

    @Override
    public void delete() throws IOException {
        App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
        AbstractFile actualFile = this.getActualFile();
        try (Tx tx = app.tx();){
            if (!((List)actualFile.getProperty((PropertyKey)AbstractFile.children)).isEmpty()) {
                throw new DirectoryNotEmptyException(AbstractFile.path.toString());
            }
            app.delete((NodeInterface)actualFile);
            this.cachedActualFile = null;
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to delete file {}: {}", new Object[]{AbstractFile.path, fex.getMessage()});
        }
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        return new StructrFilePath(this.fs, this, pathComponent);
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) throws IOException {
        AbstractFile actualFile = this.getActualFile();
        if (actualFile != null) {
            return new StructrFileAttributes(this.fs.getSecurityContext(), actualFile).toMap(attributes);
        }
        throw new NoSuchFileException(this.toString());
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) throws IOException {
        AbstractFile actualFile = this.getActualFile();
        if (actualFile != null) {
            return (T)new StructrFileAttributes(this.fs.getSecurityContext(), actualFile);
        }
        throw new NoSuchFileException(this.toString());
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        if (target instanceof StructrFilePath) {
            App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
            StructrFilePath other = (StructrFilePath)target;
            AbstractFile otherFile = other.getActualFile();
            AbstractFile thisFile = this.getActualFile();
            String targetName = target.getFileName().toString();
            try (Tx tx = app.tx();){
                Path otherParent = other.getParent();
                if (otherParent instanceof StructrFilesPath) {
                    thisFile.setProperty((PropertyKey)AbstractFile.parent, null);
                    thisFile.setProperty((PropertyKey)AbstractNode.name, (Object)targetName);
                    if (otherFile != null) {
                        app.delete((NodeInterface)otherFile);
                    }
                } else {
                    StructrFilePath parent = (StructrFilePath)other.getParent();
                    Folder newParentFolder = (Folder)parent.getActualFile();
                    thisFile.setProperty((PropertyKey)AbstractFile.parent, (Object)newParentFolder);
                    thisFile.setProperty((PropertyKey)AbstractNode.name, (Object)targetName);
                    if (otherFile != null) {
                        app.delete((NodeInterface)otherFile);
                    }
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbstractFile getActualFile() {
        if (this.cachedActualFile == null) {
            String filePath = this.toString().substring("files".length() + 1);
            App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
            try (Tx tx = app.tx();){
                this.cachedActualFile = (AbstractFile)app.nodeQuery(AbstractFile.class).and((PropertyKey)AbstractFile.path, (Object)filePath).getFirst();
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to load actual file for path {}: {}", new Object[]{this.toString(), fex.getMessage()});
            }
        }
        return this.cachedActualFile;
    }

    public FileBase createNewFile() throws FrameworkException, IOException {
        String name = this.getFileName().toString();
        byte[] data = new byte[]{};
        String contentType = null;
        FileBase file = FileHelper.createFile((SecurityContext)this.fs.getSecurityContext(), (byte[])data, contentType, File.class, (String)name);
        this.cachedActualFile = file;
        return file;
    }

    @Override
    public boolean dontCache() {
        return true;
    }

    private void setParentFolder(AbstractFile file) throws FrameworkException {
        StructrFilePath parentFilePath;
        Folder parentFolder;
        Path parentPath = this.getParent();
        if (parentPath != null && parentPath instanceof StructrFilePath && (parentFolder = (Folder)(parentFilePath = (StructrFilePath)parentPath).getActualFile()) != null) {
            file.setProperty((PropertyKey)AbstractFile.parent, (Object)parentFolder);
        }
    }
}

