/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.file;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.StructrToplevelAttributes;
import org.structr.files.ssh.filesystem.path.file.StructrFilePath;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.Folder;

public class StructrFilesPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrFilesPath.class.getName());

    public StructrFilesPath(StructrFilesystem fs, StructrPath parent) {
        super(fs, parent, "files");
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        return new DirectoryStream(){
            boolean closed = false;

            @Override
            public Iterator iterator() {
                if (!this.closed) {
                    App app = StructrApp.getInstance((SecurityContext)StructrFilesPath.this.fs.getSecurityContext());
                    LinkedList<StructrFilePath> files = new LinkedList<StructrFilePath>();
                    try (Tx tx = app.tx();){
                        for (Folder folder : app.nodeQuery(Folder.class).and((PropertyKey)AbstractFile.hasParent, (Object)false).getAsList()) {
                            files.add(new StructrFilePath(StructrFilesPath.this.fs, StructrFilesPath.this, folder.getName()));
                        }
                        for (FileBase file : app.nodeQuery(FileBase.class).and((PropertyKey)AbstractFile.hasParent, (Object)false).getAsList()) {
                            files.add(new StructrFilePath(StructrFilesPath.this.fs, StructrFilesPath.this, file.getName()));
                        }
                        tx.success();
                    }
                    catch (FrameworkException fex) {
                        logger.warn("", (Throwable)fex);
                    }
                    return files.iterator();
                }
                return Collections.emptyIterator();
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }
        };
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        throw new FileAlreadyExistsException(this.toString());
    }

    @Override
    public void delete() throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        return new StructrFilePath(this.fs, this, pathComponent);
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) {
        return new StructrToplevelAttributes("files").toMap(attributes);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) {
        return (T)new StructrToplevelAttributes("files");
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

