/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.graph;

import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;

public class StructrNodeAttributes
implements PosixFileAttributes,
DosFileAttributes {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrNodeAttributes.class.getName());
    public static final Set<String> SUPPORTED_VIEWS = new LinkedHashSet<String>(Arrays.asList("owner", "dos", "basic", "posix", "permissions"));
    private SecurityContext securityContext = null;
    private GraphObject node = null;

    public StructrNodeAttributes(SecurityContext securityContext, GraphObject node) {
        this.securityContext = securityContext;
        this.node = node;
    }

    @Override
    public UserPrincipal owner() {
        return null;
    }

    @Override
    public GroupPrincipal group() {
        return null;
    }

    @Override
    public FileTime lastModifiedTime() {
        if (this.node == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            time = FileTime.fromMillis(((Date)this.node.getProperty((PropertyKey)GraphObject.lastModifiedDate)).getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public FileTime lastAccessTime() {
        if (this.node == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            time = FileTime.fromMillis(((Date)this.node.getProperty((PropertyKey)GraphObject.lastModifiedDate)).getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public FileTime creationTime() {
        if (this.node == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            time = FileTime.fromMillis(((Date)this.node.getProperty((PropertyKey)GraphObject.createdDate)).getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public boolean isRegularFile() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public Object fileKey() {
        if (this.node == null) {
            return null;
        }
        String uuid = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            uuid = this.node.getUuid();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return uuid;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_READ);
        permissions.add(PosixFilePermission.OWNER_WRITE);
        return permissions;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    public Map<String, Object> toMap(String filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int splitPos = filter.indexOf(":");
        String prefix = filter.substring(0, splitPos >= 0 ? splitPos : filter.length());
        if ("dos".equals(prefix)) {
            map.put("hidden", this.isHidden());
            map.put("archive", this.isArchive());
            map.put("system", this.isSystem());
            map.put("readonly", this.isReadOnly());
        }
        if (!"owner".equals(prefix)) {
            map.put("lastModifiedTime", this.lastModifiedTime());
            map.put("lastAccessTime", this.lastAccessTime());
            map.put("creationTime", this.creationTime());
            map.put("size", this.size());
            map.put("isRegularFile", this.isRegularFile());
            map.put("isDirectory", this.isDirectory());
            map.put("isSymbolicLink", this.isSymbolicLink());
            map.put("isOther", this.isOther());
            map.put("fileKey", this.fileKey());
        }
        if ("posix".equals(prefix)) {
            map.put("permissions", this.permissions());
            map.put("group", this.group());
            map.put("owner", this.owner());
        }
        if ("permissions".equals(prefix)) {
            map.put("permissions", this.permissions());
        }
        if ("owner".equals(prefix)) {
            map.put("owner", this.owner());
        }
        return map;
    }
}

