/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.graph;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.path.graph.StructrPropertyValueAttributes;
import org.structr.files.ssh.filesystem.path.graph.StructrPropertyValueChannel;

public class StructrNodePropertyPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrNodePropertyPath.class.getName());
    private PropertyKey key = null;
    private GraphObject node = null;

    public StructrNodePropertyPath(StructrFilesystem fs, StructrPath parent, GraphObject node, PropertyKey property) {
        super(fs, parent, property.jsonName());
        this.node = node;
        this.key = property;
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        this.parent.enablePropertyFile(this.name);
        if (options.contains(StandardOpenOption.WRITE)) {
            StructrPropertyValueChannel.checkWriteAccess(this.key);
        }
        return new StructrPropertyValueChannel(this.fs.getSecurityContext(), this.node, this.key, true, false);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) throws IOException {
        if (!this.parent.hasPropertyFile(this.name)) {
            throw new NoSuchFileException(this.name);
        }
        return (T)new StructrPropertyValueAttributes(this.fs.getSecurityContext(), this.node, this.key);
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) throws IOException {
        if (!this.parent.hasPropertyFile(this.name)) {
            throw new NoSuchFileException(this.name);
        }
        return new StructrPropertyValueAttributes(this.fs.getSecurityContext(), this.node, this.key).toMap(attributes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        if (!this.parent.hasPropertyFile(this.name)) {
            throw new NoSuchFileException(this.name);
        }
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void delete() throws IOException {
        if (this.key.isSystemInternal() || this.key.isReadOnly() || this.key.isWriteOnce()) {
            return;
        }
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext()).tx();){
            this.node.setProperty(this.key, null);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to set property {} to null: {}", new Object[]{this.key.jsonName(), fex.getMessage()});
        }
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

