/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.page;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Group;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.web.entity.User;
import org.structr.web.entity.dom.DOMNode;

public class StructrDOMAttributes
implements PosixFileAttributes,
DosFileAttributes,
PosixFileAttributeView {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrDOMAttributes.class.getName());
    public static final Set<String> SUPPORTED_VIEWS = new LinkedHashSet<String>(Arrays.asList("unix"));
    private SecurityContext securityContext = null;
    private DOMNode domNode = null;

    public StructrDOMAttributes(SecurityContext securityContext, DOMNode domNode) {
        this.securityContext = securityContext;
        this.domNode = domNode;
    }

    @Override
    public UserPrincipal owner() {
        if (this.domNode == null) {
            return null;
        }
        UserPrincipal owner = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Principal fileOwner = this.domNode.getOwnerNode();
            owner = fileOwner == null ? () -> ((Principal)this.securityContext.getUser(false)).getName() : () -> ((Principal)fileOwner).getName();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return owner;
    }

    @Override
    public GroupPrincipal group() {
        if (this.domNode == null) {
            return null;
        }
        LinkedList groups = new LinkedList();
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Principal fileOwner = this.domNode.getOwnerNode();
            if (fileOwner != null) {
                groups.addAll((Collection)fileOwner.getProperty((PropertyKey)User.groups));
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return groups.size() > 0 ? () -> ((Group)((Group)groups.get(0))).getName() : null;
    }

    @Override
    public FileTime lastModifiedTime() {
        if (this.domNode == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            time = FileTime.fromMillis(this.domNode.getLastModifiedDate().getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public FileTime lastAccessTime() {
        if (this.domNode == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            time = FileTime.fromMillis(this.domNode.getLastModifiedDate().getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public FileTime creationTime() {
        if (this.domNode == null) {
            return null;
        }
        FileTime time = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            time = FileTime.fromMillis(this.domNode.getCreatedDate().getTime());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return time;
    }

    @Override
    public boolean isRegularFile() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public Object fileKey() {
        if (this.domNode == null) {
            return null;
        }
        String uuid = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            uuid = this.domNode.getUuid();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return uuid;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_READ);
        permissions.add(PosixFilePermission.OWNER_WRITE);
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        if (this.domNode != null) {
            try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
                if (this.domNode.isVisibleToPublicUsers()) {
                    permissions.add(PosixFilePermission.OTHERS_READ);
                    permissions.add(PosixFilePermission.OTHERS_WRITE);
                    permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                }
                if (this.domNode.isVisibleToAuthenticatedUsers()) {
                    permissions.add(PosixFilePermission.GROUP_READ);
                    permissions.add(PosixFilePermission.GROUP_WRITE);
                    permissions.add(PosixFilePermission.GROUP_EXECUTE);
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.error("", (Throwable)fex);
            }
        }
        return permissions;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    public Map<String, Object> toMap(String filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String prefix = filter.substring(0, filter.indexOf(":"));
        if ("dos".equals(prefix)) {
            map.put("hidden", this.isHidden());
            map.put("archive", this.isArchive());
            map.put("system", this.isSystem());
            map.put("readonly", this.isReadOnly());
        }
        if (!"owner".equals(prefix)) {
            map.put("lastModifiedTime", this.lastModifiedTime());
            map.put("lastAccessTime", this.lastAccessTime());
            map.put("creationTime", this.creationTime());
            map.put("size", this.size());
            map.put("isRegularFile", this.isRegularFile());
            map.put("isDirectory", this.isDirectory());
            map.put("isSymbolicLink", this.isSymbolicLink());
            map.put("isOther", this.isOther());
            map.put("fileKey", this.fileKey());
        }
        if ("posix".equals(prefix)) {
            map.put("permissions", this.permissions());
            map.put("group", this.group());
            map.put("owner", this.owner());
        }
        if ("permissions".equals(prefix)) {
            map.put("permissions", this.permissions());
        }
        if ("owner".equals(prefix)) {
            map.put("owner", this.owner());
        }
        return map;
    }

    @Override
    public String name() {
        if (this.domNode == null) {
            return null;
        }
        String name = null;
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            name = this.domNode.getName();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("", (Throwable)fex);
        }
        return name;
    }

    @Override
    public PosixFileAttributes readAttributes() throws IOException {
        return this;
    }

    @Override
    public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
        if (this.domNode == null) {
            return;
        }
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            this.domNode.setProperty((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)perms.contains((Object)PosixFilePermission.GROUP_READ));
            this.domNode.setProperty((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)perms.contains((Object)PosixFilePermission.OTHERS_READ));
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.error("Unable to set mapped file permissions for " + this.domNode, (Throwable)fex);
        }
    }

    @Override
    public void setGroup(GroupPrincipal group) throws IOException {
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.owner();
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
    }
}

