/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.page;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.fulltext.Indexable;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.path.components.StructrNonexistingComponentPath;
import org.structr.files.ssh.filesystem.path.graph.StructrNodePropertyPath;
import org.structr.files.ssh.filesystem.path.page.StructrDOMAttributes;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.Template;
import org.structr.web.entity.dom.relationship.DOMChildren;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StructrDOMNodePath
extends StructrPath {
    private static final Set<String> blacklist = new LinkedHashSet<String>(Arrays.asList("type", "pageId", "parent", "children", "childrenIds", "syncedNodes", "mostUsedTags", "isDOMNode", "isPage", "createdDate", "createdBy", "lastModifiedDate", "linkingElements", "deleted", "hidden", "isContent", "version"));
    private static final Logger logger = LoggerFactory.getLogger((String)StructrDOMNodePath.class.getName());
    private Page ownerDocument = null;
    private DOMNode parentNode = null;
    private DOMNode domNode = null;
    private String uuid = null;

    public StructrDOMNodePath(StructrFilesystem fs, StructrPath parent, Page ownerDocument, DOMNode parentNode, DOMNode node, String name) {
        super(fs, parent, name);
        this.ownerDocument = ownerDocument;
        this.parentNode = parentNode;
        this.domNode = node;
        if (node != null) {
            this.uuid = node.getUuid();
        }
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        final Tx tx = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext()).tx();
        return new DirectoryStream(){
            boolean closed = false;

            @Override
            public Iterator iterator() {
                if (!this.closed) {
                    StructrPath.HiddenFileEntry hiddenFiles = StructrPath.HIDDEN_PROPERTY_FILES.get(StructrDOMNodePath.this.domNode.getUuid());
                    LinkedList<StructrPath> nodes = new LinkedList<StructrPath>();
                    int pos = 0;
                    try {
                        for (DOMNode child : StructrDOMNodePath.this.domNode.treeGetChildren()) {
                            int domPosition = StructrDOMNodePath.this.getDomPosition(child, pos);
                            child.setProperty((PropertyKey)DOMNode.domSortPosition, (Object)domPosition);
                            nodes.add(new StructrDOMNodePath(StructrDOMNodePath.this.fs, StructrDOMNodePath.this, StructrDOMNodePath.this.ownerDocument, StructrDOMNodePath.this.domNode, child, StructrDOMNodePath.this.getName(null, child, pos)));
                            ++pos;
                        }
                        LinkedHashSet exportedKeys = new LinkedHashSet();
                        Iterables.addAll(exportedKeys, (Iterable)StructrDOMNodePath.this.domNode.getPropertyKeys("ui"));
                        Iterables.addAll(exportedKeys, (Iterable)StructrDOMNodePath.this.domNode.getPropertyKeys("_html_"));
                        StructrDOMNodePath.this.hidePropertyKeys(hiddenFiles);
                        for (PropertyKey key : exportedKeys) {
                            StructrPath path;
                            Object value = StructrDOMNodePath.this.domNode.getProperty(key);
                            Object defaultValue = key.defaultValue();
                            if (key instanceof BooleanProperty) {
                                defaultValue = Boolean.FALSE;
                            }
                            if (value == null || value.equals(defaultValue) || (path = StructrDOMNodePath.this.resolveStructrPath(key.jsonName())) == null) continue;
                            if (hiddenFiles != null) {
                                hiddenFiles.remove(key.jsonName());
                            }
                            nodes.add(path);
                        }
                    }
                    catch (FrameworkException fex) {
                        logger.warn("", (Throwable)fex);
                    }
                    return nodes.iterator();
                }
                return Collections.emptyIterator();
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
                try {
                    tx.success();
                    tx.close();
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                }
            }
        };
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
        ElementName en = new ElementName(this.name);
        if (!en.hasTagName() || !en.hasPosition()) {
            throw new InvalidPathException(this.name, "New element needs tag and position, e.g. 001-div");
        }
        try (Tx tx = app.tx();){
            if (this.ownerDocument != null) {
                int index = 0;
                if (this.parentNode != null) {
                    for (DOMNode child : this.parentNode.treeGetChildren()) {
                        int childPosition = this.getDomPosition(child, index++);
                        if (childPosition != en.getPosition()) continue;
                        throw new InvalidPathException(this.name, "A child with position " + childPosition + " already exists.");
                    }
                }
                DOMNode newChild = this.createNode((Document)this.ownerDocument, en.getTagName());
                int newPosition = en.getPosition();
                if (this.parentNode != null) {
                    this.insertDOMNodeAt(newChild, newPosition);
                }
                if (newChild instanceof DOMNode) {
                    this.domNode = newChild;
                    StructrPath.HiddenFileEntry entry = new StructrPath.HiddenFileEntry();
                    for (PropertyKey key : this.domNode.getPropertyKeys("ui")) {
                        entry.add(key.jsonName());
                    }
                    for (PropertyKey key : this.domNode.getPropertyKeys("_html_")) {
                        entry.add(key.jsonName());
                    }
                    this.hidePropertyKeys(entry);
                    StructrPath.HIDDEN_PROPERTY_FILES.put(this.domNode.getUuid(), entry);
                }
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    @Override
    public void delete() throws IOException {
        App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
        try (Tx tx = app.tx();){
            if (this.domNode.treeGetChildren().isEmpty()) {
                if (this.parentNode != null) {
                    this.parentNode.removeChild((Node)this.domNode);
                }
            } else {
                throw new DirectoryNotEmptyException(this.name);
            }
            app.delete((NodeInterface)this.domNode);
            this.domNode = null;
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        if (blacklist.contains(pathComponent)) {
            return null;
        }
        if (this.domNode != null) {
            PropertyKey key;
            if ("name".equals(pathComponent)) {
                if (this.domNode instanceof Page) {
                    return null;
                }
                if (this.domNode.getOwnerDocument() instanceof ShadowDocument) {
                    return null;
                }
            }
            if (pathComponent != null && pathComponent.startsWith("data-") && (key = StructrApp.getConfiguration().getPropertyKeyForJSONName(this.domNode.getClass(), pathComponent)) != null) {
                return new StructrNodePropertyPath(this.fs, this, (GraphObject)this.domNode, key);
            }
            key = StructrApp.getConfiguration().getPropertyKeyForJSONName(this.domNode.getClass(), pathComponent, false);
            if (key != null) {
                return new StructrNodePropertyPath(this.fs, this, (GraphObject)this.domNode, key);
            }
            ElementName en = new ElementName(pathComponent);
            int pos = en.getPosition();
            if (pos >= 0) {
                int childPosition = 0;
                DOMNode node = null;
                for (DOMNode child : this.domNode.treeGetChildren()) {
                    int domSortPosition = this.getDomPosition(child, childPosition);
                    if (pos == domSortPosition) {
                        node = child;
                        break;
                    }
                    ++childPosition;
                }
                return new StructrDOMNodePath(this.fs, this, this.ownerDocument, this.domNode, node, pathComponent);
            }
        }
        return new StructrDOMNodePath(this.fs, this, this.ownerDocument, this.domNode, null, pathComponent);
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) throws IOException {
        if (this.domNode != null) {
            return new StructrDOMAttributes(this.fs.getSecurityContext(), this.domNode).toMap(attributes);
        }
        throw new NoSuchFileException(this.toString());
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) throws IOException {
        if (this.domNode != null) {
            return (T)new StructrDOMAttributes(this.fs.getSecurityContext(), this.domNode);
        }
        throw new NoSuchFileException(this.toString());
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        if (target instanceof StructrDOMNodePath) {
            App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
            StructrDOMNodePath targetPath = (StructrDOMNodePath)target;
            try (Tx tx = app.tx();){
                if (targetPath.parentNode != null && targetPath.parentNode.getUuid().equals(this.parentNode.getUuid())) {
                    String targetName = target.getFileName().toString();
                    ElementName targetElementName = new ElementName(targetName);
                    ElementName sourceElementName = new ElementName(this.name);
                    if (targetElementName.getTagName().equals(sourceElementName.getTagName())) {
                        int newPosition = targetElementName.getPosition();
                        this.parentNode.removeChild((Node)this.domNode);
                        this.insertDOMNodeAt(this.domNode, newPosition);
                    } else {
                        throw new InvalidPathException(targetName, "Cannot change element type.");
                    }
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to move {} to {}: {}", new Object[]{this, target, fex.getMessage()});
            }
        } else if (target instanceof StructrNonexistingComponentPath & this.domNode != null) {
            if (!(this.domNode.getOwnerDocument() instanceof ShadowDocument)) {
                throw new AccessDeniedException("Cannot move DOM node to shared components");
            }
            String targetName = target.getFileName().toString();
            int pos = targetName.indexOf("-");
            String componentName = null;
            String componentTag = null;
            if (pos == -1) {
                throw new InvalidPathException(targetName, "Component name must contain tag and name, e.g. div-test");
            }
            componentTag = targetName.substring(0, pos);
            componentName = targetName.substring(pos + 1);
            if (componentName.isEmpty() || componentTag.isEmpty()) {
                throw new InvalidPathException(targetName, "Component name must contain tag and name, e.g. div-test");
            }
            App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
            try (Tx tx = app.tx();){
                ShadowDocument doc = (ShadowDocument)StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext()).nodeQuery(ShadowDocument.class).includeDeletedAndHidden().getFirst();
                for (DOMNode child : (List)doc.getProperty((PropertyKey)Page.elements)) {
                    if (child.hasIncomingRelationships(DOMChildren.class) || !componentName.equals(child.getName()) || !componentTag.equals(child.getProperty((PropertyKey)DOMElement.tag))) continue;
                    throw new FileAlreadyExistsException(targetName);
                }
                this.domNode.setProperty((PropertyKey)DOMElement.name, (Object)componentName);
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void enablePropertyFile(String name) {
        StructrPath.HiddenFileEntry entry;
        if (this.uuid != null && (entry = StructrPath.HIDDEN_PROPERTY_FILES.get(this.uuid)) != null) {
            if (name.startsWith("data-")) {
                entry.addDynamicWithValue(name);
            }
            entry.remove(name);
            if (entry.isEmpty()) {
                StructrPath.HIDDEN_PROPERTY_FILES.remove(this.uuid);
            }
        }
    }

    @Override
    public boolean hasPropertyFile(String name) {
        StructrPath.HiddenFileEntry entry;
        boolean result = true;
        if (this.uuid != null && (entry = StructrPath.HIDDEN_PROPERTY_FILES.get(this.uuid)) != null) {
            if (entry.has(name)) {
                result = false;
            } else if (name.startsWith("data-")) {
                result = entry.hasDynamicWithValue(name);
            }
        }
        return result;
    }

    private void insertDOMNodeAt(DOMNode newChild, int newPosition) throws FrameworkException {
        DOMNode refChild = null;
        int position = 0;
        for (DOMNode child : this.parentNode.treeGetChildren()) {
            int domPosition = this.getDomPosition(child, position++);
            if (domPosition > newPosition && refChild == null) {
                refChild = child;
            }
            if (child.getProperty((PropertyKey)DOMNode.domSortPosition) != null) continue;
            child.setProperty((PropertyKey)DOMNode.domSortPosition, (Object)domPosition);
        }
        if (refChild != null) {
            this.parentNode.insertBefore((Node)newChild, refChild);
        } else {
            this.parentNode.appendChild((Node)newChild);
        }
        newChild.setProperty((PropertyKey)DOMNode.domSortPosition, (Object)newPosition);
    }

    private DOMNode createNode(Document doc, String tagName) {
        switch (tagName) {
            case "content": {
                return (DOMNode)doc.createTextNode("#text");
            }
            case "comment": {
                return (DOMNode)doc.createComment("#comment");
            }
            case "template": {
                Template newNode = null;
                try {
                    newNode = (Template)StructrApp.getInstance().create(Template.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)Template.parent, (Object)((Page)doc)), new NodeAttribute((PropertyKey)Template.ownerDocument, (Object)((Page)doc)), new NodeAttribute((PropertyKey)Template.content, (Object)"#template")});
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to create new template node", (Throwable)fex);
                }
                return newNode;
            }
        }
        return (DOMNode)doc.createElement(tagName);
    }

    private void hidePropertyKeys(StructrPath.HiddenFileEntry hiddenKeys) {
        if (hiddenKeys != null) {
            hiddenKeys.add(DOMNode.visibleToAuthenticatedUsers.jsonName());
            hiddenKeys.add(DOMNode.visibleToPublicUsers.jsonName());
            hiddenKeys.add(DOMNode.sharedComponent.jsonName());
            hiddenKeys.add(DOMNode.renderDetails.jsonName());
            hiddenKeys.add(Indexable.contentType.jsonName());
        }
    }

    public static class ElementName {
        private int position = -1;
        private String src = null;
        private String tag = null;

        public ElementName(String src) {
            this.src = src;
            this.parsePositionAndName(src);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.src);
            buf.append(" = ElementName(");
            buf.append(this.tag);
            buf.append(", ");
            buf.append(this.position);
            buf.append(")");
            return buf.toString();
        }

        public int getPosition() {
            return this.position;
        }

        public boolean hasPosition() {
            return this.position >= 0;
        }

        public String getTagName() {
            return this.tag;
        }

        public boolean hasTagName() {
            return this.tag != null;
        }

        private void parsePositionAndName(String src) {
            int pos = src.indexOf("-");
            if (pos >= 0) {
                String positionSrc = src.substring(0, pos);
                String nameSrc = src.substring(pos + 1);
                this.position = this.getPosition(positionSrc);
                if (this.position >= 0) {
                    this.tag = nameSrc;
                } else {
                    logger.warn("Unable to extract position from {}: invalid source name", (Object)src);
                }
            } else {
                this.tag = src;
            }
        }

        private int getPosition(String src) {
            try {
                return Integer.valueOf(src);
            }
            catch (Throwable throwable) {
                return -1;
            }
        }
    }
}

