/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.page;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.path.page.StructrDOMAttributes;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;

public class StructrNonexistingPagePath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrNonexistingPagePath.class.getName());
    private Page newPage = null;

    public StructrNonexistingPagePath(StructrFilesystem fs, StructrPath parent, String name) {
        super(fs, parent, name);
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        return null;
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
        try (Tx tx = app.tx();){
            StructrPath.HiddenFileEntry entry = new StructrPath.HiddenFileEntry();
            this.newPage = (Page)app.create(Page.class, this.name);
            for (PropertyKey key : this.newPage.getPropertyKeys("ui")) {
                entry.add(key.jsonName());
            }
            StructrPath.HIDDEN_PROPERTY_FILES.put(this.newPage.getUuid(), entry);
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    @Override
    public void delete() throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        return null;
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) throws IOException {
        if (this.newPage == null) {
            throw new NoSuchFileException(this.name);
        }
        return new StructrDOMAttributes(this.fs.getSecurityContext(), (DOMNode)this.newPage).toMap(attributes);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) throws IOException {
        if (this.newPage == null) {
            throw new NoSuchFileException(this.name);
        }
        return (T)new StructrDOMAttributes(this.fs.getSecurityContext(), (DOMNode)this.newPage);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean dontCache() {
        return true;
    }
}

