/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.page;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.StructrToplevelAttributes;
import org.structr.files.ssh.filesystem.path.page.StructrDOMNodePath;
import org.structr.files.ssh.filesystem.path.page.StructrNonexistingPagePath;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;

public class StructrPagesPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrPagesPath.class.getName());

    public StructrPagesPath(StructrFilesystem fs, StructrPath parent) {
        super(fs, parent, "pages");
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        return new DirectoryStream(){
            boolean closed = false;

            @Override
            public Iterator iterator() {
                if (!this.closed) {
                    App app = StructrApp.getInstance((SecurityContext)StructrPagesPath.this.fs.getSecurityContext());
                    LinkedList<StructrDOMNodePath> nodes = new LinkedList<StructrDOMNodePath>();
                    try (Tx tx = app.tx();){
                        for (Page page : app.nodeQuery(Page.class).getAsList()) {
                            nodes.add(new StructrDOMNodePath(StructrPagesPath.this.fs, StructrPagesPath.this, page, null, (DOMNode)page, page.getName()));
                        }
                        tx.success();
                    }
                    catch (FrameworkException fex) {
                        logger.warn("", (Throwable)fex);
                    }
                    return nodes.iterator();
                }
                return Collections.emptyIterator();
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }
        };
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        throw new FileAlreadyExistsException(this.toString());
    }

    @Override
    public void delete() throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) throws FrameworkException {
        Page page = (Page)StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext()).nodeQuery(Page.class).andName(pathComponent).getFirst();
        if (page != null) {
            return new StructrDOMNodePath(this.fs, this, page, null, (DOMNode)page, page.getName());
        }
        return new StructrNonexistingPagePath(this.fs, this, pathComponent);
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) {
        return new StructrToplevelAttributes("pages").toMap(attributes);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) {
        return (T)new StructrToplevelAttributes("pages");
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

