/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.schema;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaMethod;
import org.structr.core.entity.SchemaNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.path.graph.StructrPropertyValueAttributes;
import org.structr.files.ssh.filesystem.path.graph.StructrPropertyValueChannel;

public class StructrSchemaMethodPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrSchemaMethodPath.class.getName());
    private AbstractSchemaNode schemaNode = null;

    public StructrSchemaMethodPath(StructrFilesystem fs, StructrPath parent, AbstractSchemaNode schemaNode, String name) {
        super(fs, parent, name);
        this.schemaNode = schemaNode;
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        SchemaMethod method = this.getSchemaMethodNode();
        boolean read = options.contains(StandardOpenOption.READ);
        boolean create = options.contains(StandardOpenOption.CREATE);
        boolean createNew = options.contains(StandardOpenOption.CREATE_NEW);
        boolean write = options.contains(StandardOpenOption.WRITE);
        boolean truncate = options.contains(StandardOpenOption.TRUNCATE_EXISTING);
        boolean append = options.contains(StandardOpenOption.APPEND);
        if (create || createNew) {
            if (createNew && method != null) {
                throw new FileAlreadyExistsException(this.toString());
            }
            App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
            try (Tx tx = app.tx();){
                method = (SchemaMethod)app.create(SchemaMethod.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)SchemaMethod.schemaNode, (Object)this.schemaNode), new NodeAttribute((PropertyKey)SchemaMethod.virtualFileName, (Object)this.name), new NodeAttribute((PropertyKey)AbstractNode.name, (Object)this.normalizeFileNameForJavaIdentifier(this.name)), new NodeAttribute((PropertyKey)SchemaMethod.source, (Object)"")});
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
        return new StructrPropertyValueChannel(this.fs.getSecurityContext(), (GraphObject)method, (PropertyKey)SchemaMethod.source, truncate, append);
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public void delete() throws IOException {
        SchemaMethod schemaMethod = this.getSchemaMethodNode();
        if (schemaMethod != null) {
            App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
            try (Tx tx = app.tx();){
                app.delete((NodeInterface)schemaMethod);
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        } else {
            throw new NoSuchFileException(this.name);
        }
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        return null;
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) throws IOException {
        SchemaMethod method = this.getSchemaMethodNode();
        if (method != null) {
            return new StructrPropertyValueAttributes(this.fs.getSecurityContext(), (GraphObject)this.getSchemaMethodNode(), (PropertyKey)SchemaMethod.source).toMap(attributes);
        }
        throw new NoSuchFileException(this.name);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) throws IOException {
        SchemaMethod method = this.getSchemaMethodNode();
        if (method != null) {
            return (T)new StructrPropertyValueAttributes(this.fs.getSecurityContext(), (GraphObject)this.getSchemaMethodNode(), (PropertyKey)SchemaMethod.source);
        }
        throw new NoSuchFileException(this.name);
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        if (target instanceof StructrSchemaMethodPath) {
            App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
            StructrSchemaMethodPath other = (StructrSchemaMethodPath)target;
            AbstractSchemaNode otherNode = other.getSchemaNode();
            SchemaMethod method = this.getSchemaMethodNode();
            String targetName = target.getFileName().toString();
            try (Tx tx = app.tx();){
                if (otherNode.getUuid().equals(this.schemaNode.getUuid())) {
                    method.setProperty((PropertyKey)SchemaMethod.name, (Object)this.normalizeFileNameForJavaIdentifier(targetName));
                    method.setProperty((PropertyKey)SchemaMethod.virtualFileName, (Object)targetName);
                }
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
        }
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbstractSchemaNode getSchemaNode() {
        return this.schemaNode;
    }

    public SchemaMethod getSchemaMethodNode() {
        App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
        SchemaMethod method = null;
        try (Tx tx = app.tx();){
            for (SchemaMethod schemaMethod : (List)this.schemaNode.getProperty((PropertyKey)SchemaNode.schemaMethods)) {
                String fileName = (String)schemaMethod.getProperty((PropertyKey)SchemaMethod.virtualFileName);
                String methodName = (String)schemaMethod.getProperty((PropertyKey)AbstractNode.name);
                if (fileName != null && fileName.equals(this.name)) {
                    method = schemaMethod;
                    break;
                }
                if (methodName == null || !methodName.equals(this.name)) continue;
                method = schemaMethod;
                break;
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return method;
    }
}

