/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.schema;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.graph.Tx;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.StructrToplevelAttributes;
import org.structr.files.ssh.filesystem.path.schema.StructrSchemaNodePath;

public class StructrSchemaPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrSchemaPath.class.getName());

    public StructrSchemaPath(StructrFilesystem fs, StructrPath parent) {
        super(fs, parent, "schema");
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        return new DirectoryStream(){
            boolean closed = false;

            @Override
            public Iterator iterator() {
                if (!this.closed) {
                    App app = StructrApp.getInstance((SecurityContext)StructrSchemaPath.this.fs.getSecurityContext());
                    LinkedList<StructrSchemaNodePath> nodes = new LinkedList<StructrSchemaNodePath>();
                    try (Tx tx = app.tx();){
                        for (SchemaNode schemaNode : app.nodeQuery(SchemaNode.class).getAsList()) {
                            nodes.add(new StructrSchemaNodePath(StructrSchemaPath.this.fs, StructrSchemaPath.this, schemaNode.getName()));
                        }
                        for (SchemaRelationshipNode rel : app.nodeQuery(SchemaRelationshipNode.class).getAsList()) {
                            nodes.add(new StructrSchemaNodePath(StructrSchemaPath.this.fs, StructrSchemaPath.this, rel.getName()));
                        }
                        tx.success();
                    }
                    catch (FrameworkException fex) {
                        logger.warn("", (Throwable)fex);
                    }
                    return nodes.iterator();
                }
                return Collections.emptyIterator();
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }
        };
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        throw new FileAlreadyExistsException(this.toString());
    }

    @Override
    public void delete() throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        return new StructrSchemaNodePath(this.fs, this, pathComponent);
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) {
        return new StructrToplevelAttributes("schema").toMap(attributes);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) {
        return (T)new StructrToplevelAttributes("schema");
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

