/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.schema;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.path.graph.StructrNodeAttributes;

public class StructrSchemaPropertyPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrSchemaPropertyPath.class.getName());
    private AbstractSchemaNode schemaNode = null;
    private SchemaProperty schemaProperty = null;

    public StructrSchemaPropertyPath(StructrFilesystem fs, StructrPath parent, AbstractSchemaNode schemaNode, SchemaProperty schemaProperty) {
        super(fs, parent, schemaProperty.getName());
        this.schemaNode = schemaNode;
        this.schemaProperty = schemaProperty;
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        if (this.schemaProperty != null) {
            return new DirectoryStream(){
                boolean closed = false;

                @Override
                public Iterator iterator() {
                    App app = StructrApp.getInstance((SecurityContext)StructrSchemaPropertyPath.this.fs.getSecurityContext());
                    LinkedList nodes = new LinkedList();
                    try (Tx tx = app.tx();){
                        tx.success();
                    }
                    catch (FrameworkException fex) {
                        logger.warn("", (Throwable)fex);
                    }
                    return nodes.iterator();
                }

                @Override
                public void close() throws IOException {
                    this.closed = true;
                }
            };
        }
        return null;
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        throw new FileAlreadyExistsException(this.toString());
    }

    @Override
    public void delete() throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        return null;
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) throws IOException {
        return new StructrNodeAttributes(this.fs.getSecurityContext(), (GraphObject)this.schemaProperty).toMap(attributes);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) throws IOException {
        return (T)new StructrNodeAttributes(this.fs.getSecurityContext(), (GraphObject)this.schemaProperty);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AbstractSchemaNode getSchemaNode() {
        if (this.schemaNode == null) {
            App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
            try (Tx tx = app.tx();){
                this.schemaNode = (AbstractSchemaNode)app.nodeQuery(AbstractSchemaNode.class).and((PropertyKey)AbstractNode.name, (Object)this.name).getFirst();
                tx.success();
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to load actual file for path {}: {}", new Object[]{this.toString(), fex.getMessage()});
            }
        }
        return this.schemaNode;
    }
}

