/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.filesystem.path.schema;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaView;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.filesystem.StructrFilesystem;
import org.structr.files.ssh.filesystem.StructrPath;
import org.structr.files.ssh.filesystem.StructrToplevelAttributes;
import org.structr.files.ssh.filesystem.path.schema.StructrSchemaViewPath;

public class StructrSchemaViewsPath
extends StructrPath {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrSchemaViewsPath.class.getName());
    private AbstractSchemaNode schemaNode = null;

    public StructrSchemaViewsPath(StructrFilesystem fs, StructrPath parent, AbstractSchemaNode schemaNode) {
        super(fs, parent, "views");
        this.schemaNode = schemaNode;
    }

    @Override
    public DirectoryStream<Path> getDirectoryStream(DirectoryStream.Filter<? super Path> filter) {
        if (this.schemaNode != null) {
            return new DirectoryStream(){
                boolean closed = false;

                @Override
                public Iterator iterator() {
                    App app = StructrApp.getInstance((SecurityContext)StructrSchemaViewsPath.this.fs.getSecurityContext());
                    LinkedList<StructrSchemaViewPath> nodes = new LinkedList<StructrSchemaViewPath>();
                    try (Tx tx = app.tx();){
                        for (SchemaView schemaView : (List)StructrSchemaViewsPath.this.schemaNode.getProperty((PropertyKey)SchemaNode.schemaViews)) {
                            nodes.add(new StructrSchemaViewPath(StructrSchemaViewsPath.this.fs, StructrSchemaViewsPath.this, StructrSchemaViewsPath.this.schemaNode, schemaView));
                        }
                        tx.success();
                    }
                    catch (FrameworkException fex) {
                        logger.warn("", (Throwable)fex);
                    }
                    return nodes.iterator();
                }

                @Override
                public void close() throws IOException {
                    this.closed = true;
                }
            };
        }
        return null;
    }

    @Override
    public FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        throw new FileAlreadyExistsException(this.toString());
    }

    @Override
    public void delete() throws IOException {
        throw new AccessDeniedException(this.toString());
    }

    @Override
    public StructrPath resolveStructrPath(String pathComponent) {
        App app = StructrApp.getInstance((SecurityContext)this.fs.getSecurityContext());
        StructrSchemaViewPath path = null;
        try (Tx tx = app.tx();){
            for (SchemaView schemaView : (List)this.schemaNode.getProperty((PropertyKey)SchemaNode.schemaViews)) {
                if (!pathComponent.equals(schemaView.getName())) continue;
                path = new StructrSchemaViewPath(this.fs, this, this.schemaNode, schemaView);
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return path;
    }

    @Override
    public Map<String, Object> getAttributes(String attributes, LinkOption ... options) throws IOException {
        return new StructrToplevelAttributes("views").toMap(attributes);
    }

    @Override
    public <T extends BasicFileAttributes> T getAttributes(Class<T> type, LinkOption ... options) throws IOException {
        return (T)new StructrToplevelAttributes("views");
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) throws IOException {
        return (V)((FileAttributeView)this.getAttributes((Class)null, options));
    }

    @Override
    public void copy(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSameFile(Path path2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

