/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.shell;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.StructrShellCommand;
import org.structr.files.ssh.shell.NonInteractiveShellCommand;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.Folder;

public class LsCommand
extends NonInteractiveShellCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)LsCommand.class.getName());

    @Override
    public void execute(StructrShellCommand parent) throws IOException {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            Folder currentFolder = parent.getCurrentFolder();
            if (currentFolder != null) {
                this.listFolder(parent, (List)currentFolder.getProperty((PropertyKey)AbstractFile.children));
            } else {
                this.listFolder(parent, app.nodeQuery(AbstractFile.class).and((PropertyKey)AbstractFile.parent, null).getAsList());
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    private void listFolder(StructrShellCommand parent, List<AbstractFile> folder) throws FrameworkException, IOException {
        for (AbstractFile child : folder) {
            if (!parent.isAllowed(child, Permission.read, false)) continue;
            if (child instanceof Folder) {
                this.term.setBold(true);
                this.term.setTextColor(4);
                this.term.print(new Object[]{child.getName() + "  "});
                this.term.setTextColor(7);
                this.term.setBold(false);
                continue;
            }
            this.term.print(new Object[]{child.getName() + "  "});
        }
        if (!folder.isEmpty()) {
            this.term.println();
        }
    }
}

