/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.ssh.shell;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.ssh.StructrShellCommand;
import org.structr.files.ssh.shell.CdCommand;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.Folder;

public class MkdirCommand
extends CdCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)MkdirCommand.class.getName());
    private String target = null;

    @Override
    public void execute(StructrShellCommand parent) throws IOException {
        App app = StructrApp.getInstance();
        Folder currentFolder = parent.getCurrentFolder();
        try (Tx tx = app.tx();){
            if (this.target != null) {
                switch (this.target) {
                    case "..": 
                    case ".": 
                    case "/": 
                    case "~": {
                        this.term.println(new Object[]{"Folder " + this.target + " already exists"});
                        break;
                    }
                    default: {
                        this.createFolder(parent, currentFolder, this.target);
                        break;
                    }
                }
            } else {
                this.term.println(new Object[]{"mkdir needs parameter"});
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
    }

    @Override
    public void setCommand(String command) throws IOException {
        if (command.contains(" ") && command.length() > 3) {
            this.target = command.substring(command.indexOf(" ") + 1);
            if (this.target.startsWith("\"")) {
                if (this.target.endsWith("\"")) {
                    this.target = this.target.substring(1, this.target.length() - 2);
                } else {
                    this.term.print(new Object[]{"Unmatched quotes"});
                }
            }
            if (this.target != null && this.target.endsWith("/") && this.target.length() > 1) {
                this.target = this.target.substring(0, this.target.length() - 1);
            }
        }
    }

    private void createFolder(StructrShellCommand parent, Folder currentFolder, String target) throws FrameworkException, IOException {
        App app = StructrApp.getInstance();
        if (target.contains("/")) {
            int lastSlashIndex = target.lastIndexOf("/");
            String targetFolderPath = target.substring(0, lastSlashIndex);
            String targetFolderName = target.substring(lastSlashIndex + 1);
            Folder parentFolder = parent.findRelativeFolder(currentFolder, targetFolderPath);
            if (parentFolder != null) {
                this.checkAndCreateFolder(app, parent, parentFolder, targetFolderName);
            } else {
                this.term.println(new Object[]{"Folder " + targetFolderPath + " does not exist"});
            }
        } else {
            this.checkAndCreateFolder(app, parent, currentFolder, target);
        }
    }

    private void checkAndCreateFolder(App app, StructrShellCommand parent, Folder parentFolder, String name) throws FrameworkException, IOException {
        Folder checkFolder = (Folder)app.nodeQuery(Folder.class).and((PropertyKey)AbstractFile.parent, (Object)parentFolder).and((PropertyKey)Folder.name, (Object)name).getFirst();
        if (checkFolder != null) {
            this.term.println(new Object[]{"Folder " + this.target + " already exists"});
        } else {
            if (parentFolder != null && parent.isAllowed((AbstractFile)parentFolder, Permission.write, true)) {
                app.create(Folder.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractFile.parent, (Object)parentFolder), new NodeAttribute((PropertyKey)Folder.owner, (Object)this.user), new NodeAttribute((PropertyKey)Folder.name, (Object)name)});
                return;
            }
            this.term.println(new Object[]{"Permission denied"});
        }
    }
}

