/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur;

import java.util.Arrays;
import org.renjin.gcc.runtime.DoublePtr;

public class Sort {
    public static void rPsort2(DoublePtr x, int lo, int hi, int k) {
        boolean nalast = true;
        int L = lo;
        int R2 = hi;
        while (L < R2) {
            double v = x.get(k);
            int i = L;
            int j = R2;
            while (i <= j) {
                while (Sort.rcmp(x.get(i), v, nalast) < 0) {
                    ++i;
                }
                while (Sort.rcmp(v, x.get(j), nalast) < 0) {
                    --j;
                }
                if (i > j) continue;
                double w = x.get(i);
                x.set(i++, x.get(j));
                x.set(j--, w);
            }
            if (j < k) {
                L = i;
            }
            if (k >= i) continue;
            R2 = j;
        }
    }

    public static void Rf_rPsort(DoublePtr x, int n, int k) {
        Sort.rPsort2(x, 0, n - 1, k);
    }

    public static void R_rsort(DoublePtr x, int n) {
        Arrays.sort(x.array, x.offset, x.offset + n);
    }

    private static int rcmp(double x, double y, boolean nalast) {
        boolean nax = Double.isNaN(x);
        boolean nay = Double.isNaN(y);
        if (nax && nay) {
            return 0;
        }
        if (nax) {
            return nalast ? 1 : -1;
        }
        if (nay) {
            return nalast ? -1 : 1;
        }
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        return 0;
    }
}

