/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public final class DateTimeType
extends DTIType {
    public final boolean withTimeZone;
    private String nameString;
    public static final long epochSeconds = HsqlDateTime.getDateSeconds("1-01-01");
    public static final TimestampData epochTimestamp = new TimestampData(epochSeconds);

    public DateTimeType(int n, int n2, int n3) {
        super(n, n2, 0L, n3);
        this.withTimeZone = n2 == 94 || n2 == 95;
        this.nameString = this.getNameStringPrivate();
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 91: {
                return 10;
            }
            case 92: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 94: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
            case 93: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 95: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 91: {
                return Date.class;
            }
            case 92: 
            case 94: {
                return Time.class;
            }
            case 93: 
            case 95: {
                return Timestamp.class;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 91: {
                return "java.sql.Date";
            }
            case 92: 
            case 94: {
                return "java.sql.Time";
            }
            case 93: 
            case 95: {
                return "java.sql.Timestamp";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 9;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 94: {
                return "TIME WITH TIME ZONE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 95: {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getDefinition() {
        String string;
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: 
            case 94: {
                if (this.scale == 0) {
                    return this.getNameString();
                }
                string = "TIME";
                break;
            }
            case 93: 
            case 95: {
                if (this.scale == 6) {
                    return this.getNameString();
                }
                string = "TIMESTAMP";
                break;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType");
            }
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(string);
        stringBuffer.append('(');
        stringBuffer.append(this.scale);
        stringBuffer.append(')');
        if (this.withTimeZone) {
            stringBuffer.append(" WITH TIME ZONE");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    @Override
    public boolean isDateTimeTypeWithZone() {
        return this.withTimeZone;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.typeCode != 91;
    }

    @Override
    public Type getAggregateType(Type type) {
        int n;
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            return this.scale >= type.scale ? this : type;
        }
        if (type.typeCode == 0) {
            return this;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        if (!type.isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType dateTimeType = (DateTimeType)type;
        if (dateTimeType.startIntervalType > this.endIntervalType || this.startIntervalType > dateTimeType.endIntervalType) {
            throw Error.error(5562);
        }
        int n2 = this.typeCode;
        int n3 = this.scale > dateTimeType.scale ? this.scale : dateTimeType.scale;
        boolean bl = this.withTimeZone || dateTimeType.withTimeZone;
        int n4 = n = dateTimeType.startIntervalType > this.startIntervalType ? this.startIntervalType : dateTimeType.startIntervalType;
        n2 = n == 104 ? (bl ? 94 : 92) : (bl ? 95 : 93);
        return DateTimeType.getDateTimeType(n2, n3);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n) {
        switch (n) {
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int n2;
                if (this.typeCode == type.typeCode) {
                    return this;
                }
                if (type.typeCode == 0) {
                    return this;
                }
                if (!type.isDateTimeType()) {
                    throw Error.error(5562);
                }
                DateTimeType dateTimeType = (DateTimeType)type;
                if (dateTimeType.startIntervalType > this.endIntervalType || this.startIntervalType > dateTimeType.endIntervalType) {
                    throw Error.error(5562);
                }
                int n3 = this.typeCode;
                int n4 = this.scale > dateTimeType.scale ? this.scale : dateTimeType.scale;
                boolean bl = this.withTimeZone || dateTimeType.withTimeZone;
                int n5 = n2 = dateTimeType.startIntervalType > this.startIntervalType ? this.startIntervalType : dateTimeType.startIntervalType;
                n3 = n2 == 104 ? (bl ? 94 : 92) : (bl ? 95 : 93);
                return DateTimeType.getDateTimeType(n3, n4);
            }
            case 32: 
            case 33: {
                if (type.isIntervalType()) {
                    if (this.typeCode != 91 && type.scale > this.scale) {
                        return DateTimeType.getDateTimeType(this.typeCode, type.scale);
                    }
                    return this;
                }
                if (type.isDateTimeType()) {
                    if (n != 33 || type.typeComparisonGroup != this.typeComparisonGroup) break;
                    if (this.typeCode == 91) {
                        return Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                    }
                    return Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                }
                if (!type.isNumberType()) break;
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l = ((TimeData)object).getSeconds() - ((TimeData)object2).getSeconds();
                if (l == 0L) {
                    l = ((TimeData)object).getNanos() - ((TimeData)object2).getNanos();
                }
                return l == 0L ? 0 : (l > 0L ? 1 : -1);
            }
            case 91: 
            case 93: 
            case 95: {
                long l = ((TimestampData)object).getSeconds() - ((TimestampData)object2).getSeconds();
                if (l == 0L) {
                    l = ((TimestampData)object).getNanos() - ((TimestampData)object2).getNanos();
                }
                return l == 0L ? 0 : (l > 0L ? 1 : -1);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (this.scale == 9) {
            return object;
        }
        switch (this.typeCode) {
            case 91: {
                return object;
            }
            case 92: 
            case 94: {
                TimeData timeData = (TimeData)object;
                int n = timeData.getNanos();
                int n2 = this.scaleNanos(n);
                if (n2 == n) {
                    return timeData;
                }
                return new TimeData(timeData.getSeconds(), n2, timeData.getZone());
            }
            case 93: 
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                int n = timestampData.getNanos();
                int n3 = this.scaleNanos(n);
                if (n3 == n) {
                    return timestampData;
                }
                return new TimestampData(timestampData.getSeconds(), n3, timestampData.getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    int scaleNanos(int n) {
        int n2 = nanoScaleFactors[this.scale];
        return n / n2 * n2;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return object;
        }
        switch (type.typeCode) {
            case 40: {
                object = object.toString();
            }
            case 1: 
            case 12: 
            case 100: {
                switch (this.typeCode) {
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return sessionInterface.getScanner().convertToDatetimeInterval(sessionInterface, (String)object, this);
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case 91: {
                switch (type.typeCode) {
                    case 91: {
                        return object;
                    }
                    case 95: {
                        long l = ((TimestampData)object).getSeconds() + (long)((TimestampData)object).getZone();
                        long l2 = HsqlDateTime.getNormalisedDate(l * 1000L);
                        return new TimestampData(l2 / 1000L);
                    }
                    case 93: {
                        long l = HsqlDateTime.getNormalisedDate(((TimestampData)object).getSeconds() * 1000L);
                        return new TimestampData(l / 1000L);
                    }
                }
                throw Error.error(5561);
            }
            case 94: {
                switch (type.typeCode) {
                    case 94: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        return new TimeData(timeData.getSeconds() - sessionInterface.getZoneSeconds(), this.scaleNanos(timeData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = HsqlDateTime.convertToNormalisedTime(timestampData.getSeconds() * 1000L) / 1000L;
                        return new TimeData((int)l, this.scaleNanos(timestampData.getNanos()), timestampData.getZone());
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = timestampData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        l = HsqlDateTime.convertToNormalisedTime(l * 1000L) / 1000L;
                        return new TimeData((int)l, this.scaleNanos(timestampData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 92: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        return new TimeData(timeData.getSeconds() + timeData.getZone(), this.scaleNanos(timeData.getNanos()), 0);
                    }
                    case 92: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = timestampData.getSeconds() + (long)timestampData.getZone();
                        l = HsqlDateTime.convertToNormalisedTime(l * 1000L) / 1000L;
                        return new TimeData((int)l, this.scaleNanos(timestampData.getNanos()), 0);
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = HsqlDateTime.convertToNormalisedTime(timestampData.getSeconds() * 1000L) / 1000L;
                        return new TimeData((int)l, this.scaleNanos(timestampData.getNanos()));
                    }
                }
                throw Error.error(5561);
            }
            case 95: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        long l = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds();
                        return new TimestampData(l, this.scaleNanos(timeData.getNanos()), timeData.getZone());
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        long l = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        return new TimestampData(l, this.scaleNanos(timeData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 95: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 93: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = timestampData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        return new TimestampData(l, this.scaleNanos(timestampData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 91: {
                        TimestampData timestampData = (TimestampData)object;
                        return new TimestampData(timestampData.getSeconds(), 0, sessionInterface.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 93: {
                switch (type.typeCode) {
                    case 94: {
                        TimeData timeData = (TimeData)object;
                        long l = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds() - (long)sessionInterface.getZoneSeconds();
                        return new TimestampData(l, this.scaleNanos(timeData.getNanos()), sessionInterface.getZoneSeconds());
                    }
                    case 92: {
                        TimeData timeData = (TimeData)object;
                        long l = sessionInterface.getCurrentDate().getSeconds() + (long)timeData.getSeconds();
                        return new TimestampData(l, this.scaleNanos(timeData.getNanos()));
                    }
                    case 95: {
                        TimestampData timestampData = (TimestampData)object;
                        long l = timestampData.getSeconds() + (long)timestampData.getZone();
                        return new TimestampData(l, this.scaleNanos(timestampData.getNanos()));
                    }
                    case 93: {
                        return this.convertToTypeLimits(sessionInterface, object);
                    }
                    case 91: {
                        return object;
                    }
                }
                throw Error.error(5561);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        DateTimeType dateTimeType = object instanceof TimeData ? Type.SQL_TIME : Type.SQL_TIMESTAMP;
        return this.convertToType(sessionInterface, object, dateTimeType);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l;
                if (object instanceof Date || !(object instanceof java.util.Date)) break;
                int n = 0;
                int n2 = 0;
                if (this.typeCode == 92) {
                    l = HsqlDateTime.convertMillisFromCalendar(sessionInterface.getCalendar(), ((java.util.Date)object).getTime());
                } else {
                    l = ((java.util.Date)object).getTime();
                    n2 = sessionInterface.getZoneSeconds();
                }
                l = HsqlDateTime.getNormalisedTime(l);
                if (object instanceof Timestamp) {
                    n = ((Timestamp)object).getNanos();
                    n = DateTimeType.normaliseFraction(n, this.scale);
                }
                return new TimeData((int)l / 1000, n, n2);
            }
            case 91: {
                if (object instanceof Time || !(object instanceof java.util.Date)) break;
                long l = HsqlDateTime.convertMillisFromCalendar(sessionInterface.getCalendar(), ((java.util.Date)object).getTime());
                l = HsqlDateTime.getNormalisedDate(l);
                return new TimestampData(l / 1000L);
            }
            case 93: 
            case 95: {
                long l;
                if (object instanceof Time || !(object instanceof java.util.Date)) break;
                int n = 0;
                int n3 = 0;
                if (this.typeCode == 93) {
                    l = HsqlDateTime.convertMillisFromCalendar(sessionInterface.getCalendar(), ((java.util.Date)object).getTime());
                } else {
                    l = ((java.util.Date)object).getTime();
                    n3 = HsqlDateTime.getZoneMillis(sessionInterface.getCalendar(), l) / 1000;
                }
                if (object instanceof Timestamp) {
                    n = ((Timestamp)object).getNanos();
                    n = DateTimeType.normaliseFraction(n, this.scale);
                }
                return new TimestampData(l / 1000L, n, n3);
            }
        }
        throw Error.error(5561);
    }

    public Object convertSQLToJavaGMT(SessionInterface sessionInterface, Object object) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long l = ((TimeData)object).getSeconds() * 1000;
                return new Time(l += (long)(((TimeData)object).getNanos() / 1000000));
            }
            case 91: {
                long l = ((TimestampData)object).getSeconds() * 1000L;
                return new Date(l);
            }
            case 93: 
            case 95: {
                long l = ((TimestampData)object).getSeconds() * 1000L;
                Timestamp timestamp = new Timestamp(l);
                timestamp.setNanos(((TimestampData)object).getNanos());
                return timestamp;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: {
                Calendar calendar = sessionInterface.getCalendar();
                long l = HsqlDateTime.convertMillisToCalendar(calendar, ((TimeData)object).getSeconds() * 1000);
                l = HsqlDateTime.getNormalisedTime(calendar, l);
                Time time = new Time(l);
                return time;
            }
            case 94: {
                int n = ((TimeData)object).getSeconds();
                return new Time(n * 1000);
            }
            case 91: {
                Calendar calendar = sessionInterface.getCalendar();
                long l = HsqlDateTime.convertMillisToCalendar(calendar, ((TimestampData)object).getSeconds() * 1000L);
                Date date = new Date(l);
                return date;
            }
            case 93: {
                Calendar calendar = sessionInterface.getCalendar();
                long l = HsqlDateTime.convertMillisToCalendar(calendar, ((TimestampData)object).getSeconds() * 1000L);
                Timestamp timestamp = new Timestamp(l);
                timestamp.setNanos(((TimestampData)object).getNanos());
                return timestamp;
            }
            case 95: {
                long l = ((TimestampData)object).getSeconds();
                Timestamp timestamp = new Timestamp(l * 1000L);
                timestamp.setNanos(((TimestampData)object).getNanos());
                return timestamp;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static int normaliseTime(int n) {
        while (n < 0) {
            n += 86400;
        }
        if (n > 86400) {
            n %= 86400;
        }
        return n;
    }

    @Override
    public String convertToString(Object object) {
        boolean bl = false;
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return HsqlDateTime.getDateString(((TimestampData)object).getSeconds());
            }
            case 92: 
            case 94: {
                TimeData timeData = (TimeData)object;
                int n = DateTimeType.normaliseTime(timeData.getSeconds() + timeData.getZone());
                String string = this.intervalSecondToString(n, timeData.getNanos(), false);
                if (!this.withTimeZone) {
                    return string;
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                string = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimeData)object).getZone(), 0, true);
                stringBuffer.append(string);
                return stringBuffer.toString();
            }
            case 93: 
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                StringBuffer stringBuffer = new StringBuffer();
                HsqlDateTime.getTimestampString(stringBuffer, timestampData.getSeconds() + (long)timestampData.getZone(), timestampData.getNanos(), this.scale);
                if (!this.withTimeZone) {
                    return stringBuffer.toString();
                }
                String string = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimestampData)object).getZone(), 0, true);
                stringBuffer.append(string);
                return stringBuffer.toString();
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        switch (this.typeCode) {
            case 91: {
                stringBuffer.append("DATE");
                break;
            }
            case 92: 
            case 94: {
                stringBuffer.append("TIME");
                break;
            }
            case 93: 
            case 95: {
                stringBuffer.append("TIMESTAMP");
            }
        }
        stringBuffer.append(StringConverter.toQuotedString(this.convertToString(object), '\'', false));
        return stringBuffer.toString();
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type.typeCode == 0) {
            return true;
        }
        if (type.isCharacterType()) {
            return true;
        }
        if (!type.isDateTimeType()) {
            return false;
        }
        if (type.typeCode == 91) {
            return this.typeCode != 92;
        }
        if (type.typeCode == 92) {
            return this.typeCode != 91;
        }
        return true;
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        if (this.typeCode == type.typeCode) {
            return this.scale >= type.scale ? 0 : -1;
        }
        return -1;
    }

    @Override
    public Object add(Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        if (type.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((NumberType)type).floor(object2);
            }
            object2 = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)object, (int)((IntervalSecondData)object2).units, ((IntervalSecondData)object2).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof IntervalMonthData) {
                    return DateTimeType.addMonths((TimestampData)object, (int)((IntervalMonthData)object2).units);
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)object, (int)((IntervalSecondData)object2).units, ((IntervalSecondData)object2).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object subtract(Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        if (type.isNumberType()) {
            if (this.typeCode == 91) {
                object2 = ((NumberType)type).floor(object2);
            }
            object2 = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, object2);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (object2 instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)object, -((int)((IntervalSecondData)object2).units), -((IntervalSecondData)object2).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (object2 instanceof IntervalMonthData) {
                    return DateTimeType.addMonths((TimestampData)object, -((int)((IntervalMonthData)object2).units));
                }
                if (!(object2 instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)object, -((int)((IntervalSecondData)object2).units), -((IntervalSecondData)object2).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object truncate(Object object, int n) {
        if (object == null) {
            return null;
        }
        long l = this.getMillis(object);
        l = HsqlDateTime.getTruncatedPart(l, n);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                return new TimeData((int)(l / 1000L), 0, ((TimeData)object).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(l / 1000L, 0, ((TimestampData)object).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object round(Object object, int n) {
        if (object == null) {
            return null;
        }
        long l = this.getMillis(object);
        l = HsqlDateTime.getRoundedPart(l, n);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                return new TimeData((int)(l / 1000L), 0, ((TimeData)object).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(l / 1000L, 0, ((TimestampData)object).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Type) {
            return super.equals(object) && ((DateTimeType)object).withTimeZone == this.withTimeZone;
        }
        return false;
    }

    @Override
    public int getPart(Session session, Object object, int n) {
        int n2;
        int n3 = 0;
        int n4 = 1;
        switch (n) {
            case 101: {
                n2 = 1;
                break;
            }
            case 102: {
                n3 = 1;
                n2 = 2;
                break;
            }
            case 103: 
            case 260: {
                n2 = 5;
                break;
            }
            case 104: {
                n2 = 11;
                break;
            }
            case 105: {
                n2 = 12;
                break;
            }
            case 106: {
                n2 = 13;
                break;
            }
            case 259: {
                n2 = 7;
                break;
            }
            case 262: {
                n2 = 3;
                break;
            }
            case 266: {
                if (this.typeCode != 92 && this.typeCode != 94) {
                    try {
                        DateTimeType dateTimeType = this.withTimeZone ? Type.SQL_TIME_WITH_TIME_ZONE : Type.SQL_TIME;
                        object = dateTimeType.castToType(session, object, this);
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
                return ((TimeData)object).getSeconds();
            }
            case 257: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).getZone() / 3600;
                }
                return ((TimeData)object).getZone() / 3600;
            }
            case 258: {
                if (this.typeCode == 95) {
                    return ((TimestampData)object).getZone() / 60 % 60;
                }
                return ((TimeData)object).getZone() / 60 % 60;
            }
            case 263: {
                n3 = 1;
                n4 = 3;
                n2 = 2;
                break;
            }
            case 261: {
                n2 = 6;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType - " + n);
            }
        }
        long l = this.getMillis(object);
        return HsqlDateTime.getDateTimePart(l, n2) / n4 + n3;
    }

    long getMillis(Object object) {
        long l = this.typeCode == 92 || this.typeCode == 94 ? (long)((((TimeData)object).getSeconds() + ((TimeData)object).getZone()) * 1000) : (((TimestampData)object).getSeconds() + (long)((TimestampData)object).getZone()) * 1000L;
        return l;
    }

    @Override
    public BigDecimal getSecondPart(Object object) {
        long l = this.getPart(null, object, 106);
        int n = 0;
        if (this.typeCode == 93) {
            n = ((TimestampData)object).getNanos();
        } else if (this.typeCode == 92) {
            n = ((TimeData)object).getNanos();
        }
        return this.getSecondPart(l, n);
    }

    public String getPartString(Session session, Object object, int n) {
        String string = "";
        switch (n) {
            case 264: {
                string = "EEEE";
                break;
            }
            case 265: {
                string = "MMMM";
            }
        }
        SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
        try {
            simpleDateFormat.applyPattern(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        java.util.Date date = (java.util.Date)this.convertSQLToJavaGMT(session, object);
        return simpleDateFormat.format(date);
    }

    public Object getValue(long l, int n, int n2) {
        switch (this.typeCode) {
            case 91: {
                l = HsqlDateTime.getNormalisedDate((l + (long)n2) * 1000L) / 1000L;
                return new TimestampData(l);
            }
            case 94: {
                l = HsqlDateTime.getNormalisedDate(l * 1000L) / 1000L;
                return new TimeData((int)l, n, n2);
            }
            case 92: {
                l = HsqlDateTime.getNormalisedTime((l + (long)n2) * 1000L) / 1000L;
                return new TimeData((int)l, n);
            }
            case 95: {
                return new TimestampData(l, n, n2);
            }
            case 93: {
                return new TimestampData(l + (long)n2, n);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public DateTimeType getDateTimeTypeWithoutZone() {
        if (this.withTimeZone) {
            DateTimeType dateTimeType;
            switch (this.typeCode) {
                case 94: {
                    dateTimeType = new DateTimeType(92, 92, this.scale);
                    break;
                }
                case 95: {
                    dateTimeType = new DateTimeType(93, 93, this.scale);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "DateTimeType");
                }
            }
            dateTimeType.nameString = this.nameString;
            return dateTimeType;
        }
        return this;
    }

    public static DateTimeType getDateTimeType(int n, int n2) {
        if (n2 > 9) {
            throw Error.error(5592);
        }
        switch (n) {
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                if (n2 == 0) {
                    return SQL_TIME;
                }
                return new DateTimeType(92, n, n2);
            }
            case 94: {
                if (n2 == 0) {
                    return SQL_TIME_WITH_TIME_ZONE;
                }
                return new DateTimeType(92, n, n2);
            }
            case 93: {
                if (n2 == 6) {
                    return SQL_TIMESTAMP;
                }
                return new DateTimeType(93, n, n2);
            }
            case 95: {
                if (n2 == 6) {
                    return SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                return new DateTimeType(95, n, n2);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object changeZone(Object object, Type type, int n, int n2) {
        if (object == null) {
            return null;
        }
        if (type.typeCode == 95 || type.typeCode == 94) {
            n2 = 0;
        }
        if (n > 50400 || -n > 50400) {
            throw Error.error(3409);
        }
        switch (this.typeCode) {
            case 94: {
                TimeData timeData = (TimeData)object;
                if (n2 == 0 && timeData.zone == n) break;
                return new TimeData(timeData.getSeconds() - n2, timeData.getNanos(), n);
            }
            case 95: {
                TimestampData timestampData = (TimestampData)object;
                if (n2 == 0 && timestampData.zone == n) break;
                return new TimestampData(timestampData.getSeconds() - (long)n2, timestampData.getNanos(), n);
            }
        }
        return object;
    }

    public boolean canAdd(IntervalType intervalType) {
        return intervalType.startPartIndex >= this.startPartIndex && intervalType.endPartIndex <= this.endPartIndex;
    }

    public int getSqlDateTimeSub() {
        switch (this.typeCode) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
        }
        return 0;
    }

    public static Boolean overlaps(Session session, Object[] objectArray, Type[] typeArray, Object[] objectArray2, Type[] typeArray2) {
        Object[] objectArray3;
        if (objectArray == null || objectArray2 == null) {
            return null;
        }
        if (objectArray[0] == null || objectArray2[0] == null) {
            return null;
        }
        if (objectArray[1] == null) {
            objectArray[1] = objectArray[0];
        }
        if (objectArray2[1] == null) {
            objectArray2[1] = objectArray2[0];
        }
        Type type = typeArray[0].getCombinedType(session, typeArray2[0], 41);
        objectArray[0] = type.castToType(session, objectArray[0], typeArray[0]);
        objectArray2[0] = type.castToType(session, objectArray2[0], typeArray2[0]);
        objectArray[1] = typeArray[1].isIntervalType() ? type.add(objectArray[0], objectArray[1], typeArray[1]) : type.castToType(session, objectArray[1], typeArray[1]);
        objectArray2[1] = typeArray2[1].isIntervalType() ? type.add(objectArray2[0], objectArray2[1], typeArray2[1]) : type.castToType(session, objectArray2[1], typeArray2[1]);
        if (type.compare(session, objectArray[0], objectArray[1]) > 0) {
            objectArray3 = objectArray[0];
            objectArray[0] = objectArray[1];
            objectArray[1] = objectArray3;
        }
        if (type.compare(session, objectArray2[0], objectArray2[1]) > 0) {
            objectArray3 = objectArray2[0];
            objectArray2[0] = objectArray2[1];
            objectArray2[1] = objectArray3;
        }
        if (type.compare(session, objectArray[0], objectArray2[0]) > 0) {
            objectArray3 = objectArray;
            objectArray = objectArray2;
            objectArray2 = objectArray3;
        }
        if (type.compare(session, objectArray[1], objectArray2[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int subtractMonths(TimestampData timestampData, TimestampData timestampData2, boolean bl) {
        Calendar calendar = HsqlDateTime.tempCalGMT;
        synchronized (calendar) {
            boolean bl2 = false;
            if (timestampData2.getSeconds() > timestampData.getSeconds()) {
                bl2 = true;
                TimestampData timestampData3 = timestampData;
                timestampData = timestampData2;
                timestampData2 = timestampData3;
            }
            HsqlDateTime.setTimeInMillis(HsqlDateTime.tempCalGMT, timestampData.getSeconds() * 1000L);
            int n = HsqlDateTime.tempCalGMT.get(2);
            int n2 = HsqlDateTime.tempCalGMT.get(1);
            HsqlDateTime.setTimeInMillis(HsqlDateTime.tempCalGMT, timestampData2.getSeconds() * 1000L);
            n -= HsqlDateTime.tempCalGMT.get(2);
            n2 -= HsqlDateTime.tempCalGMT.get(1);
            if (bl) {
                n = n2 * 12;
            } else {
                if (n < 0) {
                    n += 12;
                    --n2;
                }
                n += n2 * 12;
            }
            if (bl2) {
                n = -n;
            }
            return n;
        }
    }

    public static TimeData addSeconds(TimeData timeData, int n, int n2) {
        n += (n2 += timeData.getNanos()) / 1000000000;
        if ((n2 %= 1000000000) < 0) {
            n2 += 1000000000;
            --n;
        }
        n += timeData.getSeconds();
        TimeData timeData2 = new TimeData(n %= 86400, n2, timeData.getZone());
        return timeData2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimestampData addMonths(TimestampData timestampData, int n) {
        int n2 = timestampData.getNanos();
        Calendar calendar = HsqlDateTime.tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(HsqlDateTime.tempCalGMT, timestampData.getSeconds() * 1000L);
            HsqlDateTime.tempCalGMT.add(2, n);
            TimestampData timestampData2 = new TimestampData(HsqlDateTime.tempCalGMT.getTimeInMillis() / 1000L, n2, timestampData.getZone());
            return timestampData2;
        }
    }

    public static TimestampData addSeconds(TimestampData timestampData, int n, int n2) {
        n += (n2 += timestampData.getNanos()) / 1000000000;
        if ((n2 %= 1000000000) < 0) {
            n2 += 1000000000;
            --n;
        }
        long l = timestampData.getSeconds() + (long)n;
        TimestampData timestampData2 = new TimestampData(l, n2, timestampData.getZone());
        return timestampData2;
    }
}

