/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextProtectedAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextProtectionKeyAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextProtectionKeyDigestAlgorithmAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.xml.XmlIdAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.text.TextBibliographySourceElement;
import org.odftoolkit.odfdom.dom.element.text.TextIndexBodyElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public class TextBibliographyElement
extends OdfStylableElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "bibliography");

    public TextBibliographyElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME, OdfStyleFamily.Section, OdfName.newName(OdfDocumentNamespace.TEXT, "style-name"));
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTextNameAttribute() {
        TextNameAttribute attr = (TextNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextNameAttribute(String textNameValue) {
        TextNameAttribute attr = new TextNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textNameValue);
    }

    public Boolean getTextProtectedAttribute() {
        TextProtectedAttribute attr = (TextProtectedAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "protected");
        if (attr != null) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setTextProtectedAttribute(Boolean textProtectedValue) {
        TextProtectedAttribute attr = new TextProtectedAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textProtectedValue);
    }

    public String getTextProtectionKeyAttribute() {
        TextProtectionKeyAttribute attr = (TextProtectionKeyAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "protection-key");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextProtectionKeyAttribute(String textProtectionKeyValue) {
        TextProtectionKeyAttribute attr = new TextProtectionKeyAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textProtectionKeyValue);
    }

    public String getTextProtectionKeyDigestAlgorithmAttribute() {
        TextProtectionKeyDigestAlgorithmAttribute attr = (TextProtectionKeyDigestAlgorithmAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "protection-key-digest-algorithm");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    public void setTextProtectionKeyDigestAlgorithmAttribute(String textProtectionKeyDigestAlgorithmValue) {
        TextProtectionKeyDigestAlgorithmAttribute attr = new TextProtectionKeyDigestAlgorithmAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textProtectionKeyDigestAlgorithmValue);
    }

    public String getTextStyleNameAttribute() {
        TextStyleNameAttribute attr = (TextStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextStyleNameAttribute(String textStyleNameValue) {
        TextStyleNameAttribute attr = new TextStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textStyleNameValue);
    }

    public String getXmlIdAttribute() {
        XmlIdAttribute attr = (XmlIdAttribute)this.getOdfAttribute(OdfDocumentNamespace.XML, "id");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setXmlIdAttribute(String xmlIdValue) {
        XmlIdAttribute attr = new XmlIdAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(xmlIdValue);
    }

    public TextBibliographySourceElement newTextBibliographySourceElement() {
        TextBibliographySourceElement textBibliographySource = ((OdfFileDom)this.ownerDocument).newOdfElement(TextBibliographySourceElement.class);
        this.appendChild((Node)((Object)textBibliographySource));
        return textBibliographySource;
    }

    public TextIndexBodyElement newTextIndexBodyElement() {
        TextIndexBodyElement textIndexBody = ((OdfFileDom)this.ownerDocument).newOdfElement(TextIndexBodyElement.class);
        this.appendChild((Node)((Object)textIndexBody));
        return textIndexBody;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

