/*
 * Decompiled with CFR 0.152.
 */
package org.structr.media;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.media.VideoFile;
import org.structr.util.AbstractProcess;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.FileBase;

public class ConverterProcess
extends AbstractProcess<VideoFile> {
    private static final Logger logger = LoggerFactory.getLogger((String)ConverterProcess.class.getName());
    private VideoFile newFile = null;
    private VideoFile inputFile = null;
    private String outputFileName = null;
    private String scriptName = null;
    private String fileExtension = null;

    public ConverterProcess(SecurityContext securityContext, VideoFile videoFile, String string, String string2) {
        super(securityContext);
        this.inputFile = videoFile;
        this.outputFileName = string;
        this.scriptName = string2;
        this.fileExtension = ".tmp-" + System.currentTimeMillis();
    }

    public void preprocess() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            this.newFile = (VideoFile)FileHelper.createFile((SecurityContext)this.securityContext, (byte[])new byte[0], null, VideoFile.class, (String)this.outputFileName);
            this.outputFileName = this.newFile.getFileOnDisk().getAbsolutePath();
            tx.success();
        }
        catch (IOException | FrameworkException throwable) {
            logger.warn("", throwable);
        }
    }

    public StringBuilder getCommandLine() {
        String string = (String)Settings.getOrCreateStringSetting((String[])new String[]{"VideoFile", this.scriptName}).getValue();
        if (StringUtils.isNotBlank((String)string)) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(" ");
            stringBuilder.append(this.inputFile.getDiskFilePath(this.securityContext));
            stringBuilder.append(" ");
            stringBuilder.append(this.outputFileName);
            stringBuilder.append(this.fileExtension);
            return stringBuilder;
        }
        logger.warn("No VideoFile.{} registered in structr.conf.", (Object)this.scriptName);
        return null;
    }

    public VideoFile processExited(int n) {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        if (n == 0) {
            try (Tx tx = app.tx();){
                File file = new File(this.outputFileName + this.fileExtension);
                File file2 = new File(this.outputFileName);
                if (file.exists()) {
                    Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    FileHelper.updateMetadata((FileBase)this.newFile);
                    this.newFile.setProperty((PropertyKey)VideoFile.originalVideo, (Object)this.inputFile);
                }
                tx.success();
            }
            catch (IOException | FrameworkException throwable) {
                logger.warn("", throwable);
            }
        } else {
            try (Tx tx = app.tx();){
                app.delete((NodeInterface)this.newFile);
                tx.success();
            }
            catch (FrameworkException frameworkException) {
                logger.warn("", (Throwable)frameworkException);
            }
        }
        return this.newFile;
    }
}

