/*
 * Decompiled with CFR 0.152.
 */
package org.structr.media;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.JsonInput;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.Tx;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.DoubleProperty;
import org.structr.core.property.EndNode;
import org.structr.core.property.EndNodes;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.media.AVConv;
import org.structr.media.VideoFileHasConvertedVideoFile;
import org.structr.media.VideoFileHasPosterImage;
import org.structr.rest.RestMethodResult;
import org.structr.schema.SchemaService;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.Image;

public class VideoFile
extends org.structr.dynamic.File {
    private static final Logger logger = LoggerFactory.getLogger((String)VideoFile.class.getName());
    public static final Property<List<VideoFile>> convertedVideos;
    public static final Property<VideoFile> originalVideo;
    public static final Property<Image> posterImage;
    public static final Property<Boolean> isVideo;
    public static final Property<String> videoCodecName;
    public static final Property<String> videoCodec;
    public static final Property<String> pixelFormat;
    public static final Property<String> audioCodecName;
    public static final Property<String> audioCodec;
    public static final Property<Integer> audioChannels;
    public static final Property<Double> sampleRate;
    public static final Property<Double> duration;
    public static final Property<Integer> width;
    public static final Property<Integer> height;
    public static final View uiView;
    public static final View publicView;

    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        this.updateVideoInfo();
        return super.onCreation(securityContext, errorBuffer);
    }

    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        this.updateVideoInfo();
        return super.onModification(securityContext, errorBuffer, modificationQueue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDiskFilePath(SecurityContext securityContext) {
        try (Tx tx = StructrApp.getInstance((SecurityContext)securityContext).tx();){
            String string2 = this.getRelativeFilePath();
            tx.success();
            if (string2 == null) return null;
            String string = new File(FileHelper.getFilePath((String[])new String[]{string2})).getAbsolutePath();
            return string;
        }
        catch (FrameworkException frameworkException) {
            logger.warn("", (Throwable)frameworkException);
        }
        return null;
    }

    @Export
    public void convert(String string, String string2) throws FrameworkException {
        AVConv.newInstance(this.securityContext, this, string2).doConversion(string);
    }

    @Export
    public void grab(String string, String string2, long l) throws FrameworkException {
        AVConv.newInstance(this.securityContext, this, string2).grabFrame(string, string2, l);
    }

    @Export
    public RestMethodResult getMetadata() throws FrameworkException {
        Map<String, String> map = AVConv.newInstance(this.securityContext, this).getMetadata();
        RestMethodResult restMethodResult = new RestMethodResult(200);
        GraphObjectMap graphObjectMap = new GraphObjectMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            graphObjectMap.setProperty((PropertyKey)new StringProperty(entry.getKey()), (Object)entry.getValue());
        }
        restMethodResult.addContent((GraphObject)graphObjectMap);
        return restMethodResult;
    }

    @Export
    public void setMetadata(String string, String string2) throws FrameworkException {
        AVConv.newInstance(this.securityContext, this).setMetadata(string, string2);
    }

    @Export
    public void setMetadata(JsonInput jsonInput) throws FrameworkException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : jsonInput.entrySet()) {
            linkedHashMap.put((String)entry.getKey(), entry.getValue().toString());
        }
        AVConv.newInstance(this.securityContext, this).setMetadata(linkedHashMap);
    }

    @Export
    public void updateVideoInfo() {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();){
            Map<String, Object> map = AVConv.newInstance(this.securityContext, this).getVideoInfo();
            if (map != null && map.containsKey("streams")) {
                List list = (List)map.get("streams");
                for (Map map2 : list) {
                    String string = (String)map2.get("codec_type");
                    if (string == null) continue;
                    if ("video".equals(string)) {
                        this.setIfNotNull(videoCodecName, map2.get("codec_long_name"));
                        this.setIfNotNull(videoCodec, map2.get("codec_name"));
                        this.setIfNotNull(pixelFormat, map2.get("pix_fmt"));
                        this.setIfNotNull(width, this.toInt(map2.get("width")));
                        this.setIfNotNull(height, this.toInt(map2.get("height")));
                        this.setIfNotNull(duration, this.toDouble(map2.get("duration")));
                        continue;
                    }
                    if (!"audio".equals(string)) continue;
                    this.setIfNotNull(audioCodecName, map2.get("codec_long_name"));
                    this.setIfNotNull(audioCodec, map2.get("codec_name"));
                    this.setIfNotNull(sampleRate, this.toInt(map2.get("sampleRate")));
                }
            }
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            logger.warn("", (Throwable)frameworkException);
        }
    }

    private void setIfNotNull(Property property, Object object) throws FrameworkException {
        if (object != null) {
            this.setProperty((PropertyKey)property, object);
        }
    }

    private Integer toInt(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    private Double toDouble(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"VideoFile", (String)VideoFile.class.getName());
        convertedVideos = new EndNodes("convertedVideos", VideoFileHasConvertedVideoFile.class);
        originalVideo = new StartNode("originalVideo", VideoFileHasConvertedVideoFile.class);
        posterImage = new EndNode("posterImage", VideoFileHasPosterImage.class);
        isVideo = new ConstantBooleanProperty("isVideo", true);
        videoCodecName = new StringProperty("videoCodecName").cmis();
        videoCodec = new StringProperty("videoCodec").cmis();
        pixelFormat = new StringProperty("pixelFormat").cmis();
        audioCodecName = new StringProperty("audioCodecName").cmis();
        audioCodec = new StringProperty("audioCodec").cmis();
        audioChannels = new IntProperty("audioChannels").cmis();
        sampleRate = new DoubleProperty("sampleRate").cmis().indexed();
        duration = new DoubleProperty("duration").cmis().indexed();
        width = new IntProperty("width").cmis().indexed();
        height = new IntProperty("height").cmis().indexed();
        uiView = new View(VideoFile.class, "ui", new Property[]{type, name, contentType, size, relativeFilePath, owner, parent, path, isVideo, videoCodecName, videoCodec, pixelFormat, audioCodecName, audioCodec, audioChannels, sampleRate, duration, width, height, originalVideo, convertedVideos, posterImage});
        publicView = new View(VideoFile.class, "public", new Property[]{type, name, owner, parent, path, isVideo, videoCodecName, videoCodec, pixelFormat, audioCodecName, audioCodec, audioChannels, sampleRate, duration, width, height, convertedVideos, posterImage});
    }
}

