/*
 * Decompiled with CFR 0.152.
 */
package org.structr.ldap;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.schema.loader.SchemaEntityFactory;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.service.Command;
import org.structr.api.service.SingletonService;
import org.structr.api.service.StructrServices;
import org.structr.ldap.StructrPartition;

public class LDAPServerService
implements SingletonService {
    public static final String LDAP_PARTITION_ROOT_TYPE_PREFIX = "ldap.partition.";
    public static final String LDAP_PARTITION_ROOT_TYPE_SUFFIX = ".rootType";
    private static final Logger logger = LoggerFactory.getLogger((String)LDAPServerService.class.getName());
    private DirectoryService ds = null;
    private LdapServer server = null;

    public boolean isRunning() {
        return this.server.isStarted();
    }

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices structrServices) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        logger.info("Initializing directory service");
        try {
            this.ds = new DefaultDirectoryService();
            DefaultSchemaManager defaultSchemaManager = new DefaultSchemaManager();
            SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)defaultSchemaManager);
            StructrPartition structrPartition = new StructrPartition((SchemaManager)defaultSchemaManager, "schema", new Dn(new String[]{"ou=system"}));
            schemaPartition.setWrappedPartition((Partition)structrPartition);
            this.ds.setInstanceLayout(new InstanceLayout(new File("/tmp/ldap-test")));
            this.ds.setSchemaPartition(schemaPartition);
            this.ds.setSchemaManager((SchemaManager)defaultSchemaManager);
            this.ds.setSystemPartition((Partition)new StructrPartition((SchemaManager)defaultSchemaManager, "system", new Dn(new String[]{"ou=system"})));
            this.ds.startup();
            logger.info("Importing schema..");
            this.initSchema((SchemaManager)defaultSchemaManager, this.ds.getAdminSession(), structrPartition);
            this.server = new LdapServer();
            int n = 10389;
            this.server.setTransports(new Transport[]{new TcpTransport(n)});
            this.server.setDirectoryService(this.ds);
            this.server.start();
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
        }
    }

    public void shutdown() {
        this.server.stop();
    }

    public void initialized() {
        try {
            DirectoryService directoryService = this.server.getDirectoryService();
            SchemaManager schemaManager = directoryService.getSchemaManager();
            Dn dn = new Dn(schemaManager, new String[]{"dc=org"});
            StructrPartition structrPartition = new StructrPartition(schemaManager, "structr", dn);
            structrPartition.initialize();
            directoryService.addPartition((Partition)structrPartition);
            try {
                directoryService.getAdminSession().lookup(dn, new String[0]);
            }
            catch (LdapException ldapException) {
                Entry entry = directoryService.newEntry(dn);
                entry.add("objectClass", new String[]{"top", "domain", "extensibleObject"});
                entry.add("dc", new String[]{"structr"});
                directoryService.getAdminSession().add(entry);
            }
            try {
                System.out.println("######: " + directoryService.getAdminSession().lookup(dn, new String[0]));
                System.out.flush();
            }
            catch (LdapException ldapException) {
                logger.warn("", (Throwable)ldapException);
            }
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
        }
    }

    public String getName() {
        return "LDAP Server";
    }

    public boolean isVital() {
        return false;
    }

    public String getModuleName() {
        return "ldap-server";
    }

    private void initSchema(SchemaManager schemaManager, CoreSession coreSession, StructrPartition structrPartition) throws Exception {
        String string;
        URL uRL = SchemaEntityFactory.class.getProtectionDomain().getCodeSource().getLocation();
        JarFile jarFile = new JarFile(new File(uRL.toURI()));
        LinkedList<String> linkedList = new LinkedList<String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry object = enumeration.nextElement();
            string = object.getName();
            if (!string.startsWith("schema/") || !string.endsWith(".ldif")) continue;
            linkedList.add(string);
        }
        Collections.sort(linkedList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                Integer n;
                Integer n2 = StringUtils.countMatches((String)string, (String)"/");
                if (n2.equals(n = Integer.valueOf(StringUtils.countMatches((String)string2, (String)"/")))) {
                    Integer n3;
                    Integer n4 = string.length();
                    if (n4.equals(n3 = Integer.valueOf(string2.length()))) {
                        return string.compareTo(string2);
                    }
                    return n4.compareTo(n3);
                }
                return n2.compareTo(n);
            }
        });
        for (String string2 : linkedList) {
            string = new LdifReader(jarFile.getInputStream(jarFile.getEntry(string2)));
            Throwable throwable = null;
            try {
                Iterator throwable2 = string.iterator();
                while (throwable2.hasNext()) {
                    LdifEntry ldifEntry = (LdifEntry)throwable2.next();
                    DefaultEntry defaultEntry = new DefaultEntry(schemaManager, ldifEntry.getEntry());
                    Dn dn = defaultEntry.getDn();
                    if (structrPartition.hasEntry(new HasEntryOperationContext(coreSession, dn))) continue;
                    logger.info("Importing {}...", (Object)string2);
                    structrPartition.add(new AddOperationContext(coreSession, (Entry)defaultEntry));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (string == null) continue;
                if (throwable != null) {
                    try {
                        string.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                string.close();
            }
        }
    }
}

