/*
 * Decompiled with CFR 0.152.
 */
package org.structr.ldap.entity;

import java.util.LinkedList;
import java.util.List;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.property.EndNodes;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.ldap.api.LDAPAttribute;
import org.structr.ldap.api.LDAPValue;
import org.structr.ldap.entity.LDAPNodeImpl;
import org.structr.ldap.entity.LDAPValueImpl;
import org.structr.ldap.relationship.LDAPAttributes;
import org.structr.ldap.relationship.LDAPValues;

public class LDAPAttributeImpl
extends AbstractNode
implements LDAPAttribute {
    public static final Property<List<LDAPValueImpl>> values = new EndNodes("values", LDAPValues.class);
    public static final Property<LDAPNodeImpl> parent = new StartNode("parent", LDAPAttributes.class);
    public static final Property<String> oid = new StringProperty("oid").indexed();
    public static final View publicView = new View(LDAPAttributeImpl.class, "public", new Property[]{name, oid, values});
    public static final View uiView = new View(LDAPAttributeImpl.class, "ui", new Property[]{name, oid, values});

    @Override
    public String getUserProvidedId() {
        return (String)this.getProperty((PropertyKey)AbstractNode.name);
    }

    @Override
    public String getOid() {
        String string = (String)this.getProperty((PropertyKey)oid);
        if (string == null) {
            return (String)this.getProperty((PropertyKey)AbstractNode.name);
        }
        return string;
    }

    @Override
    public List<LDAPValue> getValues() {
        LinkedList<LDAPValue> linkedList = new LinkedList<LDAPValue>();
        for (LDAPValueImpl lDAPValueImpl : (List)this.getProperty((PropertyKey)values)) {
            linkedList.add(lDAPValueImpl);
        }
        return linkedList;
    }

    @Override
    public LDAPValue addValue(String string) throws FrameworkException {
        return (LDAPValue)StructrApp.getInstance((SecurityContext)this.securityContext).create(LDAPValueImpl.class, new NodeAttribute[]{new NodeAttribute(LDAPValueImpl.parent, (Object)this), new NodeAttribute(LDAPValueImpl.value, (Object)string), new NodeAttribute((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)true), new NodeAttribute((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)true)});
    }
}

