/*
 * Decompiled with CFR 0.152.
 */
package org.structr.ldap.entity;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Value;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.EndNodes;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.ldap.api.LDAPAttribute;
import org.structr.ldap.api.LDAPNode;
import org.structr.ldap.entity.LDAPAttributeImpl;
import org.structr.ldap.relationship.LDAPAttributes;
import org.structr.ldap.relationship.LDAPChildren;

public class LDAPNodeImpl
extends AbstractNode
implements LDAPNode {
    public static final Property<List<LDAPAttributeImpl>> attributes = new EndNodes("attributes", LDAPAttributes.class);
    public static final Property<List<LDAPNodeImpl>> children = new EndNodes("children", LDAPChildren.class);
    public static final Property<LDAPNodeImpl> parent = new StartNode("parent", LDAPChildren.class);
    public static final Property<Boolean> isRoot = new BooleanProperty("isRoot").indexed();
    public static final Property<String> rdn = new StringProperty("rdn").indexed();
    public static final View publicView = new View(LDAPNodeImpl.class, "public", new Property[]{name, rdn, attributes, children});
    public static final View uiView = new View(LDAPNodeImpl.class, "ui", new Property[]{name, rdn, attributes, children});

    @Override
    public LDAPNode getChild(String string) throws FrameworkException {
        List list = (List)this.getProperty((PropertyKey)children);
        for (LDAPNode lDAPNode : list) {
            String string2 = lDAPNode.getRdn();
            if (!string.equals(string2)) continue;
            return lDAPNode;
        }
        return null;
    }

    @Override
    public LDAPNode createChild(String string, String string2, String string3, Set<String> set) throws FrameworkException {
        return (LDAPNode)StructrApp.getInstance((SecurityContext)this.securityContext).create(LDAPNodeImpl.class, new NodeAttribute[]{new NodeAttribute(parent, (Object)this), new NodeAttribute((PropertyKey)name, (Object)string2), new NodeAttribute(rdn, (Object)string), new NodeAttribute((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)true), new NodeAttribute((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)true)});
    }

    @Override
    public String getUserProvidedName() {
        return (String)this.getProperty((PropertyKey)AbstractNode.name);
    }

    @Override
    public String getRdn() {
        return (String)this.getProperty((PropertyKey)rdn);
    }

    @Override
    public LDAPNode getParent() {
        return (LDAPNode)this.getProperty((PropertyKey)parent);
    }

    @Override
    public List<LDAPNode> getChildren() {
        LinkedList<LDAPNode> linkedList = new LinkedList<LDAPNode>();
        for (LDAPNode lDAPNode : (List)this.getProperty((PropertyKey)children)) {
            linkedList.add(lDAPNode);
        }
        return linkedList;
    }

    @Override
    public LDAPAttribute createAttribute(String string, String string2, Iterable<Value<?>> iterable) throws FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        LDAPAttribute lDAPAttribute = (LDAPAttribute)app.create(LDAPAttributeImpl.class, new NodeAttribute[]{new NodeAttribute(LDAPAttributeImpl.parent, (Object)this), new NodeAttribute((PropertyKey)AbstractNode.name, (Object)string2), new NodeAttribute(LDAPAttributeImpl.oid, (Object)string), new NodeAttribute((PropertyKey)AbstractNode.visibleToPublicUsers, (Object)true), new NodeAttribute((PropertyKey)AbstractNode.visibleToAuthenticatedUsers, (Object)true)});
        for (Value<?> value : iterable) {
            lDAPAttribute.addValue(value.getString());
        }
        return lDAPAttribute;
    }

    @Override
    public List<LDAPAttribute> getAttributes() {
        LinkedList<LDAPAttribute> linkedList = new LinkedList<LDAPAttribute>();
        for (LDAPAttribute lDAPAttribute : (List)this.getProperty((PropertyKey)attributes)) {
            linkedList.add(lDAPAttribute);
        }
        return linkedList;
    }

    @Override
    public void delete() throws FrameworkException {
        StructrApp.getInstance((SecurityContext)this.securityContext).delete((NodeInterface)this);
    }
}

