/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.name.Dn;

public class ModifyRequestDecorator
extends SingleReplyRequestDecorator<ModifyRequest>
implements ModifyRequest {
    private int modifyRequestLength;
    private int changesLength;
    private List<Integer> changeLength;
    private List<Integer> modificationLength;
    private List<Integer> valuesLength;
    private Attribute currentAttribute;
    private ModificationOperation currentOperation;

    public ModifyRequestDecorator(LdapApiService codec, ModifyRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = ModificationOperation.getOperation((int)currentOperation);
    }

    public void addAttributeTypeAndValues(String type) {
        this.currentAttribute = new DefaultAttribute(type);
        DefaultModification modification = new DefaultModification(this.currentOperation, this.currentAttribute);
        ((ModifyRequest)this.getDecorated()).addModification((Modification)modification);
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getUpId();
    }

    public void addAttributeValue(byte[] value) throws LdapException {
        this.currentAttribute.add((byte[][])new byte[][]{value});
    }

    public void addAttributeValue(String value) throws LdapException {
        this.currentAttribute.add(new String[]{value});
    }

    public Dn getName() {
        return ((ModifyRequest)this.getDecorated()).getName();
    }

    public ModifyRequest setName(Dn name) {
        ((ModifyRequest)this.getDecorated()).setName(name);
        return this;
    }

    public Collection<Modification> getModifications() {
        return ((ModifyRequest)this.getDecorated()).getModifications();
    }

    public ModifyRequest addModification(Modification mod) {
        ((ModifyRequest)this.getDecorated()).addModification(mod);
        return this;
    }

    public ModifyRequest removeModification(Modification mod) {
        ((ModifyRequest)this.getDecorated()).removeModification(mod);
        return this;
    }

    public ModifyRequest remove(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest remove(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest remove(Attribute attr) {
        ((ModifyRequest)this.getDecorated()).remove(attr);
        return this;
    }

    public ModifyRequest remove(String attributeName) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName);
        return this;
    }

    public ModifyRequest addModification(Attribute attr, ModificationOperation modOp) {
        ((ModifyRequest)this.getDecorated()).addModification(attr, modOp);
        return this;
    }

    public ModifyRequest add(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).add(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest add(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).add(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest add(Attribute attr) {
        ((ModifyRequest)this.getDecorated()).add(attr);
        return this;
    }

    public ModifyRequest replace(String attributeName) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName);
        return this;
    }

    public ModifyRequest replace(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest replace(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName, attributeValue);
        return this;
    }

    public ModifyRequest replace(Attribute attr) {
        ((ModifyRequest)this.getDecorated()).replace(attr);
        return this;
    }

    public ModifyRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public ModifyRequest addControl(Control control) {
        return (ModifyRequest)super.addControl(control);
    }

    public ModifyRequest addAllControls(Control[] controls) {
        return (ModifyRequest)super.addAllControls(controls);
    }

    public ModifyRequest removeControl(Control control) {
        return (ModifyRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        this.modifyRequestLength = 1 + TLV.getNbBytes((int)Dn.getNbBytes((Dn)this.getName())) + Dn.getNbBytes((Dn)this.getName());
        this.changesLength = 0;
        Collection<Modification> modifications = this.getModifications();
        if (modifications != null && modifications.size() != 0) {
            this.changeLength = new LinkedList<Integer>();
            this.modificationLength = new LinkedList<Integer>();
            this.valuesLength = new LinkedList<Integer>();
            for (Modification modification : modifications) {
                int localModificationSequenceLength = 3;
                int localValuesLength = 0;
                int typeLength = modification.getAttribute().getUpId().length();
                int localModificationLength = 1 + TLV.getNbBytes((int)typeLength) + typeLength;
                if (modification.getAttribute().size() != 0) {
                    for (Value value : modification.getAttribute()) {
                        localValuesLength += 1 + TLV.getNbBytes((int)value.getBytes().length) + value.getBytes().length;
                    }
                }
                this.changesLength += 1 + TLV.getNbBytes((int)(localModificationSequenceLength += 1 + TLV.getNbBytes((int)(localModificationLength += 1 + TLV.getNbBytes((int)localValuesLength) + localValuesLength)) + localModificationLength)) + localModificationSequenceLength;
                this.valuesLength.add(localValuesLength);
                this.modificationLength.add(localModificationLength);
                this.changeLength.add(localModificationSequenceLength);
            }
            this.modifyRequestLength += 1 + TLV.getNbBytes((int)this.changesLength) + this.changesLength;
        }
        return 1 + TLV.getNbBytes((int)this.modifyRequestLength) + this.modifyRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)102);
            buffer.put(TLV.getBytes((int)this.modifyRequestLength));
            BerValue.encode((ByteBuffer)buffer, (byte[])Dn.getBytes((Dn)this.getName()));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.changesLength));
            Collection<Modification> modifications = this.getModifications();
            if (modifications != null && modifications.size() != 0) {
                int modificationNumber = 0;
                for (Modification modification : modifications) {
                    buffer.put(UniversalTag.SEQUENCE.getValue());
                    int localModificationSequenceLength = this.changeLength.get(modificationNumber);
                    buffer.put(TLV.getBytes((int)localModificationSequenceLength));
                    buffer.put(UniversalTag.ENUMERATED.getValue());
                    buffer.put((byte)1);
                    buffer.put((byte)modification.getOperation().getValue());
                    buffer.put(UniversalTag.SEQUENCE.getValue());
                    int localModificationLength = this.modificationLength.get(modificationNumber);
                    buffer.put(TLV.getBytes((int)localModificationLength));
                    BerValue.encode((ByteBuffer)buffer, (String)modification.getAttribute().getUpId());
                    buffer.put(UniversalTag.SET.getValue());
                    int localValuesLength = this.valuesLength.get(modificationNumber);
                    buffer.put(TLV.getBytes((int)localValuesLength));
                    if (modification.getAttribute().size() != 0) {
                        for (Value value : modification.getAttribute()) {
                            if (value.isHumanReadable()) {
                                BerValue.encode((ByteBuffer)buffer, (String)value.getString());
                                continue;
                            }
                            BerValue.encode((ByteBuffer)buffer, (byte[])value.getBytes());
                        }
                    }
                    ++modificationNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }
}

