/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.common;

import com.opencsv.CSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.JsonInput;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.TransactionCommand;

public class CsvHelper {
    public static Iterable<JsonInput> cleanAndParseCSV(SecurityContext securityContext, Reader input, Class type, char fieldSeparator, char quoteCharacter) throws FrameworkException, IOException {
        return CsvHelper.cleanAndParseCSV(securityContext, input, type, fieldSeparator, quoteCharacter, null);
    }

    public static Iterable<JsonInput> cleanAndParseCSV(final SecurityContext securityContext, Reader input, final Class type, char fieldSeparator, char quoteCharacter, final Map<String, String> propertyMapping) throws FrameworkException, IOException {
        final BufferedReader reader = new BufferedReader(input);
        String headerLine = reader.readLine();
        final CSVParser parser = new CSVParser(fieldSeparator, quoteCharacter);
        final String[] propertyNames = parser.parseLine(headerLine);
        return new Iterable<JsonInput>(){

            @Override
            public Iterator<JsonInput> iterator() {
                return new Iterator<JsonInput>(){
                    String line = null;

                    @Override
                    public boolean hasNext() {
                        if (this.line != null) {
                            return true;
                        }
                        try {
                            this.line = reader.readLine();
                            return StringUtils.isNotBlank((CharSequence)this.line);
                        }
                        catch (IOException ioex) {
                            GraphObject.logger.warn("", (Throwable)ioex);
                            return false;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public JsonInput next() {
                        try {
                            if (StringUtils.isNotBlank((CharSequence)this.line)) {
                                JsonInput jsonInput = new JsonInput();
                                String[] columns = parser.parseLine(this.line);
                                int len = columns.length;
                                for (int i = 0; i < len; ++i) {
                                    String key;
                                    String targetKey = key = propertyNames[i];
                                    if (propertyMapping != null && propertyMapping.containsKey(key)) {
                                        targetKey = (String)propertyMapping.get(key);
                                    }
                                    if (StructrApp.getConfiguration().getPropertyKeyForJSONName(type, targetKey).isCollection()) {
                                        jsonInput.add(key, (Object)CsvHelper.extractArrayContentsFromArray(columns[i], key));
                                        continue;
                                    }
                                    jsonInput.add(key, (Object)columns[i]);
                                }
                                JsonInput jsonInput2 = jsonInput;
                                return jsonInput2;
                            }
                        }
                        catch (IOException ioex) {
                            GraphObject.logger.warn("Exception in CSV line: {}", (Object)this.line);
                            GraphObject.logger.warn("", (Throwable)ioex);
                            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                            data.put("type", "CSV_IMPORT_ERROR");
                            data.put("title", "CSV Import Error");
                            data.put("text", "Error occured with dataset: " + this.line);
                            data.put("username", securityContext.getUser(false).getName());
                            TransactionCommand.simpleBroadcast((String)"GENERIC_MESSAGE", data);
                        }
                        finally {
                            this.line = null;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal not supported.");
                    }
                };
            }
        };
    }

    private static ArrayList<String> extractArrayContentsFromArray(String value, String propertyName) throws IOException {
        CSVParser arrayParser = new CSVParser(',', '\"');
        ArrayList<String> extractedStrings = new ArrayList<String>();
        extractedStrings.addAll(Arrays.asList(arrayParser.parseLine(CsvHelper.stripArrayBracketsFromString(value, propertyName))));
        return extractedStrings;
    }

    private static String stripArrayBracketsFromString(String value, String propertyName) {
        if (value.length() > 0) {
            if (value.charAt(0) != '[' || value.charAt(value.length() - 1) != ']') {
                GraphObject.logger.warn("Missing opening/closing brackets for array {}: {} ", (Object)propertyName, (Object)value);
                return value;
            }
            return value.substring(1, value.length() - 1);
        }
        return "";
    }
}

