/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;

public class HttpHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpHelper.class.getName());
    private static String proxyUrl;
    private static String proxyUsername;
    private static String proxyPassword;
    private static String cookie;
    private static CloseableHttpClient client;
    private static RequestConfig reqConfig;

    private static void configure(HttpRequestBase req, String username, String password, String proxyUrlParameter, String proxyUsernameParameter, String proxyPasswordParameter, String cookieParameter, Map<String, String> headers, boolean followRedirects) {
        proxyUrl = StringUtils.isBlank((CharSequence)proxyUrlParameter) ? (String)Settings.HttpProxyUrl.getValue() : proxyUrlParameter;
        proxyUsername = StringUtils.isBlank((CharSequence)proxyUsernameParameter) ? (String)Settings.HttpProxyUser.getValue() : proxyUsernameParameter;
        proxyPassword = StringUtils.isBlank((CharSequence)proxyPasswordParameter) ? (String)Settings.HttpProxyPassword.getValue() : proxyPasswordParameter;
        if (!StringUtils.isBlank((CharSequence)cookieParameter)) {
            cookie = cookieParameter;
        }
        HttpHost proxy = null;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username, password})) {
            credsProvider.setCredentials(new AuthScope(new HttpHost(req.getURI().getHost())), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        if (StringUtils.isNotBlank((CharSequence)proxyUrl)) {
            proxy = HttpHost.create((String)proxyUrl);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proxyUsername, proxyPassword})) {
                credsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
            }
        }
        client = HttpClients.custom().setDefaultConnectionConfig(ConnectionConfig.DEFAULT).setUserAgent("curl/7.35.0").setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        reqConfig = RequestConfig.custom().setProxy(proxy).setRedirectsEnabled(followRedirects).setCookieSpec("default").build();
        req.setConfig(reqConfig);
        if (StringUtils.isNotBlank((CharSequence)cookie)) {
            req.addHeader("Cookie", cookie);
            req.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        }
        req.addHeader("Connection", "close");
        for (Map.Entry<String, String> header : headers.entrySet()) {
            req.addHeader(header.getKey(), header.getValue());
        }
    }

    public static String get(String address) throws FrameworkException {
        return HttpHelper.get(address, null, null, null, null, Collections.EMPTY_MAP);
    }

    public static String get(String address, Map<String, String> headers) throws FrameworkException {
        return HttpHelper.get(address, null, null, headers);
    }

    public static String get(String address, String username, String password, Map<String, String> headers) throws FrameworkException {
        return HttpHelper.get(address, username, password, null, null, null, null, headers);
    }

    public static String get(String address, String proxyUrl, String proxyUsername, String proxyPassword, String cookie, Map<String, String> headers) throws FrameworkException {
        return HttpHelper.get(address, null, null, proxyUrl, proxyUsername, proxyPassword, cookie, headers);
    }

    public static String get(String address, String username, String password, String proxyUrl, String proxyUsername, String proxyPassword, String cookie, Map<String, String> headers) throws FrameworkException {
        String content = "";
        try {
            URI url = URI.create(address);
            HttpGet req = new HttpGet(url);
            HttpHelper.configure((HttpRequestBase)req, username, password, proxyUrl, proxyUsername, proxyPassword, cookie, headers, true);
            CloseableHttpResponse resp = client.execute((HttpUriRequest)req);
            content = IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)HttpHelper.charset((HttpResponse)resp));
            if (content.charAt(0) == '\ufeff') {
                content = content.substring(1);
            }
        }
        catch (Throwable t) {
            throw new FrameworkException(422, "Unable to fetch content from address " + address + ": " + t.getMessage());
        }
        return content;
    }

    public static Map<String, String> head(String address) {
        return HttpHelper.head(address, null, null, null, null, Collections.EMPTY_MAP);
    }

    public static Map<String, String> head(String address, String username, String password, Map<String, String> headers) {
        return HttpHelper.head(address, username, password, null, null, null, null, headers);
    }

    public static Map<String, String> head(String address, String proxyUrl, String proxyUsername, String proxyPassword, String cookie, Map<String, String> headers) {
        return HttpHelper.head(address, null, null, proxyUrl, proxyUsername, proxyPassword, cookie, headers);
    }

    public static Map<String, String> head(String address, String username, String password, String proxyUrl, String proxyUsername, String proxyPassword, String cookie, Map<String, String> headers) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        try {
            URI url = URI.create(address);
            HttpHead req = new HttpHead(url);
            HttpHelper.configure((HttpRequestBase)req, username, password, proxyUrl, proxyUsername, proxyPassword, cookie, headers, false);
            CloseableHttpResponse response = client.execute((HttpUriRequest)req);
            responseHeaders.put("status", Integer.toString(response.getStatusLine().getStatusCode()));
            for (Header header : response.getAllHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
        }
        catch (Throwable t) {
            logger.error("Unable to get headers from address {}, {}", new Object[]{address, t.getMessage()});
        }
        return responseHeaders;
    }

    public static Map<String, String> post(String address, String requestBody) {
        return HttpHelper.post(address, requestBody, null, null, null, null, Collections.EMPTY_MAP);
    }

    public static Map<String, String> post(String address, String requestBody, String username, String password, Map<String, String> headers) {
        return HttpHelper.post(address, requestBody, username, password, null, null, null, null, headers);
    }

    public static Map<String, String> post(String address, String requestBody, String proxyUrl, String proxyUsername, String proxyPassword, String cookie, Map<String, String> headers) {
        return HttpHelper.post(address, requestBody, null, null, proxyUrl, proxyUsername, proxyPassword, cookie, headers);
    }

    public static Map<String, String> post(String address, String requestBody, String username, String password, String proxyUrl, String proxyUsername, String proxyPassword, String cookie, Map<String, String> headers) {
        HashMap<String, String> responseData = new HashMap<String, String>();
        try {
            URI url = URI.create(address);
            HttpPost req = new HttpPost(url);
            HttpHelper.configure((HttpRequestBase)req, username, password, proxyUrl, proxyUsername, proxyPassword, cookie, headers, true);
            req.setEntity((HttpEntity)new StringEntity(requestBody));
            CloseableHttpResponse response = client.execute((HttpUriRequest)req);
            String content = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)HttpHelper.charset((HttpResponse)response));
            if (content.charAt(0) == '\ufeff') {
                content = content.substring(1);
            }
            responseData.put("body", content);
            responseData.put("status", Integer.toString(response.getStatusLine().getStatusCode()));
            for (Header header : response.getAllHeaders()) {
                responseData.put(header.getName(), header.getValue());
            }
        }
        catch (Throwable t) {
            logger.error("Unable to fetch content from address {}, {}", new Object[]{address, t.getMessage()});
        }
        return responseData;
    }

    public static InputStream getAsStream(String address) {
        return HttpHelper.getAsStream(address, null, null, null, null, null, null, Collections.EMPTY_MAP);
    }

    public static InputStream getAsStream(String address, String username, String password, String proxyUrl, String proxyUsername, String proxyPassword, String cookie, Map<String, String> headers) {
        try {
            URI url = URI.create(address);
            HttpGet req = new HttpGet(url);
            HttpHelper.configure((HttpRequestBase)req, username, password, proxyUrl, proxyUsername, proxyPassword, cookie, headers, true);
            CloseableHttpResponse resp = client.execute((HttpUriRequest)req);
            return resp.getEntity().getContent();
        }
        catch (Throwable t) {
            logger.error("Unable to get content stream from address {}, {}", new Object[]{address, t.getMessage()});
            return null;
        }
    }

    public static String charset(HttpResponse response) {
        ContentType contentType = ContentType.get((HttpEntity)response.getEntity());
        String charset = "UTF-8";
        if (contentType != null && contentType.getCharset() != null) {
            charset = contentType.getCharset().toString();
        }
        return charset;
    }

    public static void streamURLToFile(String address, File fileOnDisk) throws FrameworkException {
        HttpHelper.streamURLToFile(address, null, null, null, null, Collections.EMPTY_MAP, fileOnDisk);
    }

    public static void streamURLToFile(String address, Map<String, String> headers, File fileOnDisk) throws FrameworkException {
        HttpHelper.streamURLToFile(address, null, null, headers, fileOnDisk);
    }

    public static void streamURLToFile(String address, String username, String password, Map<String, String> headers, File fileOnDisk) throws FrameworkException {
        HttpHelper.streamURLToFile(address, username, password, null, null, null, null, headers, fileOnDisk);
    }

    public static void streamURLToFile(String address, String proxyUrl, String proxyUsername, String proxyPassword, String cookie, Map<String, String> headers, File fileOnDisk) throws FrameworkException {
        HttpHelper.streamURLToFile(address, null, null, proxyUrl, proxyUsername, proxyPassword, cookie, headers, fileOnDisk);
    }

    public static void streamURLToFile(String address, String username, String password, String proxyUrl, String proxyUsername, String proxyPassword, String cookie, Map<String, String> headers, File fileOnDisk) throws FrameworkException {
        block28: {
            try {
                URI url = URI.create(address);
                HttpGet req = new HttpGet(url);
                logger.info("Downloading from {}", (Object)address);
                HttpHelper.configure((HttpRequestBase)req, username, password, proxyUrl, proxyUsername, proxyPassword, cookie, headers, true);
                req.addHeader("User-Agent", "curl/7.35.0");
                CloseableHttpResponse resp = client.execute((HttpUriRequest)req);
                int statusCode = resp.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    try (InputStream is = resp.getEntity().getContent();
                         FileOutputStream os = new FileOutputStream(fileOnDisk);){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        break block28;
                    }
                }
                String content = IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)HttpHelper.charset((HttpResponse)resp));
                if (content.charAt(0) == '\ufeff') {
                    content = content.substring(1);
                }
                System.out.println("Response body: " + content);
                logger.warn("Unable to create file from URI {}: status code was {}", new Object[]{address, statusCode});
            }
            catch (Throwable t) {
                throw new FrameworkException(422, "Unable to fetch file content from address " + address + ": " + t.getMessage());
            }
        }
    }
}

