/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.common;

import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLHandler
implements Iterator<Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(XMLHandler.class);
    public static final String ACTION = "action";
    public static final String CONTENT = "content";
    public static final String ISROOT = "isRoot";
    public static final String MULTIPLICITY = "multiplicity";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String ROOT_ELEMENT = "root";
    public static final String SKIP_ELEMENTS = "ignore";
    public static final String TARGET_TYPE = "targetType";
    public static final String TYPE_MAPPING = "types";
    public static final String TYPE = "type";
    private final Map<String, Object> configuration = new LinkedHashMap<String, Object>();
    private Map<String, Object> nextElement = null;
    private XMLInputFactory factory = null;
    private XMLEventReader reader = null;
    private Element current = null;

    public XMLHandler(Map<String, Object> configuration, Reader input) throws XMLStreamException {
        this.configuration.putAll(configuration);
        this.factory = XMLInputFactory.newInstance();
        this.factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.reader = this.factory.createXMLEventReader(input);
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(StartElement element) {
        String tagName = element.getName().toString();
        this.current = new Element(this.current, tagName);
        Map typeHandler = (Map)this.configuration.get(this.current.getPath());
        if (typeHandler != null) {
            Map properties = (Map)typeHandler.get(PROPERTIES);
            Object isRoot = typeHandler.get(ISROOT);
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            this.current.isRoot = Boolean.TRUE.equals(isRoot);
            Iterator<Attribute> it = element.getAttributes();
            while (it.hasNext()) {
                Attribute attr = it.next();
                if (!(attr instanceof Attribute)) continue;
                Attribute attribute = attr;
                String name = attribute.getName().toString();
                String value = attribute.getValue();
                if (properties != null && properties.containsKey(name)) {
                    String mappedName = (String)properties.get(name);
                    data.put(mappedName, value);
                    continue;
                }
                data.put(name, value);
            }
            this.current.setData(data);
        }
    }

    public void endElement(EndElement element) {
        if (this.current != null) {
            if (this.configuration.containsKey(this.current.getPath()) && this.current.isRoot) {
                this.handleObject(this.current);
            }
            this.current = this.current.parent;
        }
    }

    public void characters(Characters text) {
        if (this.current != null && !text.isIgnorableWhiteSpace() && !text.isWhiteSpace()) {
            this.current.setText(text.getData());
        }
    }

    private void handleObject(Element element) {
        this.nextElement = new LinkedHashMap<String, Object>();
        this.convertAndTransform(element, this.nextElement);
    }

    private void convertAndTransform(Element element, Map<String, Object> entityData) {
        Map config = (Map)this.configuration.get(element.getPath());
        if (config != null) {
            String action = (String)config.get(ACTION);
            if (action != null) {
                switch (action) {
                    case "createNode": {
                        this.handleCreateNode(element, entityData, config);
                        return;
                    }
                    case "setProperty": {
                        this.handleSetProperty(element, entityData, config);
                        return;
                    }
                    case "ignore": {
                        return;
                    }
                }
            } else {
                System.out.println("No action for tag " + element.tagName + ", ignoring");
            }
        }
        for (Element child : element.children) {
            this.convertAndTransform(child, entityData);
        }
    }

    private void handleCreateNode(Element element, Map<String, Object> entityData, Map<String, Object> config) {
        String type = (String)config.get(TYPE);
        if (type != null) {
            if (element.isRoot) {
                entityData.put(TYPE, type);
                entityData.putAll(element.data);
                for (Element child : element.children) {
                    this.convertAndTransform(child, entityData);
                }
            } else {
                String propertyName = (String)config.get(PROPERTY_NAME);
                if (propertyName != null) {
                    LinkedHashMap<String, Object> childData = new LinkedHashMap<String, Object>();
                    if ("1".equals(config.get(MULTIPLICITY))) {
                        entityData.put(propertyName, childData);
                        childData.put(TYPE, type);
                        childData.putAll(element.data);
                        for (Element child : element.children) {
                            this.convertAndTransform(child, childData);
                        }
                    } else {
                        LinkedList<LinkedHashMap<String, Object>> elements = (LinkedList<LinkedHashMap<String, Object>>)entityData.get(propertyName);
                        if (elements == null) {
                            elements = new LinkedList<LinkedHashMap<String, Object>>();
                            entityData.put(propertyName, elements);
                        }
                        elements.add(childData);
                        for (Element child : element.children) {
                            childData.put(TYPE, type);
                            childData.putAll(child.data);
                            this.convertAndTransform(child, childData);
                        }
                    }
                    if (element.text != null) {
                        String contentName = (String)config.get(CONTENT);
                        if (contentName == null) {
                            contentName = CONTENT;
                        }
                        childData.put(contentName, element.text);
                    }
                } else {
                    System.out.println("Missing property name for nested createNode action in " + element.tagName);
                }
            }
        } else {
            System.out.println("Invalid import specification for " + element.tagName + ", createNode action must be accompanied by type attribute.");
        }
    }

    private void handleSetProperty(Element element, Map<String, Object> entityData, Map<String, Object> config) {
        String propertyName = (String)config.get(PROPERTY_NAME);
        if (propertyName == null) {
            propertyName = element.tagName;
        }
        entityData.put(propertyName, element.text);
    }

    @Override
    public boolean hasNext() {
        while (this.reader.hasNext() && this.nextElement == null) {
            try {
                XMLEvent event = this.reader.nextEvent();
                switch (event.getEventType()) {
                    case 7: {
                        this.startDocument();
                        break;
                    }
                    case 1: {
                        this.startElement(event.asStartElement());
                        break;
                    }
                    case 8: {
                        this.endDocument();
                        break;
                    }
                    case 2: {
                        this.endElement(event.asEndElement());
                        break;
                    }
                    case 4: {
                        this.characters(event.asCharacters());
                    }
                }
            }
            catch (XMLStreamException strex) {
                logger.warn(strex.getMessage());
            }
        }
        return this.nextElement != null;
    }

    @Override
    public Map<String, Object> next() {
        Map<String, Object> result = this.nextElement;
        this.nextElement = null;
        return result;
    }

    private class Element {
        private Map<String, Object> data = new LinkedHashMap<String, Object>();
        private List<Element> children = new LinkedList<Element>();
        private boolean isRoot = false;
        private Element parent = null;
        private String tagName = null;
        private String text = null;

        public Element(Element parent, String tagName) {
            this.parent = parent;
            this.tagName = tagName;
            if (parent != null) {
                parent.children.add(this);
            }
        }

        public void setData(Map<String, Object> data) {
            this.data.putAll(data);
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getPath() {
            if (this.parent != null) {
                return this.parent.getPath() + "/" + this.tagName;
            }
            return "/" + this.tagName;
        }
    }
}

