/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.common;

import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLStructureAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(XMLStructureAnalyzer.class);
    private static final int XML_MAX_EXCEPTIONS = 100;
    private final Map<String, Object> structure = new LinkedHashMap<String, Object>();
    private XMLInputFactory factory = XMLInputFactory.newInstance();
    private XMLEventReader reader = null;
    private Element current = null;
    private int analysisCount = 0;

    public XMLStructureAnalyzer(Reader input) throws XMLStreamException {
        this.factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.reader = this.factory.createXMLEventReader(input);
    }

    public Map<String, Object> getStructure(int threshold) {
        int level = 0;
        int exceptionCount = 0;
        while (this.reader.hasNext() && this.analysisCount < threshold && exceptionCount < 100) {
            try {
                XMLEvent event = this.reader.nextEvent();
                String tagName = this.getTagName(event);
                switch (event.getEventType()) {
                    case 1: {
                        this.current = new Element(this.current, tagName, level++);
                        this.current.attributes.addAll(this.getAttributes(event.asStartElement()));
                        break;
                    }
                    case 2: {
                        this.current = this.current.parent;
                        --level;
                        if (this.current == null || this.current.level != 0) break;
                        this.analyze(this.current, this.structure);
                        ++this.analysisCount;
                    }
                }
            }
            catch (XMLStreamException strex) {
                logger.warn(strex.getMessage());
                ++exceptionCount;
            }
        }
        if (exceptionCount == 100) {
            logger.info("Stopping XML processing at error threshold ({})", (Object)100);
        }
        return this.structure;
    }

    private String getTagName(XMLEvent event) {
        if (event.isStartElement()) {
            return event.asStartElement().getName().toString();
        }
        if (event.isEndElement()) {
            return event.asEndElement().getName().toString();
        }
        return null;
    }

    private void analyze(Element parent, Map<String, Object> map) {
        LinkedHashMap<String, Object> currentObject = (LinkedHashMap<String, Object>)map.get(parent.tagName);
        if (currentObject == null) {
            currentObject = new LinkedHashMap<String, Object>();
            map.put(parent.tagName, currentObject);
        }
        if (!parent.attributes.isEmpty()) {
            LinkedHashSet attributes = (LinkedHashSet)currentObject.get("::attributes");
            if (attributes == null) {
                attributes = new LinkedHashSet();
                currentObject.put("::attributes", attributes);
            }
            attributes.addAll(parent.attributes);
        }
        for (Element child : parent.children) {
            this.analyze(child, currentObject);
        }
    }

    private Set<String> getAttributes(StartElement startElement) {
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attr = iterator.next();
            attributes.add(attr.getName().toString());
        }
        return attributes;
    }

    private class Element {
        private final List<Element> children = new LinkedList<Element>();
        private final Set<String> attributes = new LinkedHashSet<String>();
        private Element parent = null;
        private String tagName = null;
        private int level = 0;

        public Element(Element parent, String tagName, int level) {
            this.parent = parent;
            this.tagName = tagName;
            this.level = level;
            if (parent != null) {
                parent.children.add(this);
            }
        }
    }
}

