/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.maintenance;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Setting;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;
import org.structr.schema.export.StructrSchema;
import org.structr.schema.json.InvalidSchemaException;
import org.structr.schema.json.JsonSchema;

public class SnapshotCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)SnapshotCommand.class.getName());

    public void execute(Map<String, Object> attributes) throws FrameworkException {
        String mode = (String)attributes.get("mode");
        String name = (String)attributes.get("name");
        List types = (List)attributes.get("types");
        this.execute(mode, name, types);
    }

    public boolean requiresEnclosingTransaction() {
        return false;
    }

    public boolean requiresFlushingOfCaches() {
        return false;
    }

    public void execute(String mode, String name) throws FrameworkException {
        this.execute(mode, name, null);
    }

    public void execute(String mode, String name, List<String> types) throws FrameworkException {
        if (mode != null) {
            switch (mode) {
                case "export": {
                    this.createSnapshot(name, types);
                    break;
                }
                case "restore": {
                    this.restoreSnapshot(name);
                    break;
                }
                case "add": {
                    this.addSnapshot(name);
                    break;
                }
                case "delete": {
                    this.deleteSnapshot(name);
                    break;
                }
                case "purge": {
                    this.purgeLocalSchema();
                    break;
                }
                default: {
                    throw new FrameworkException(422, "Invalid mode supplied, valid values are export, restore, add, delete or delete.");
                }
            }
        } else {
            throw new FrameworkException(500, "No snapshot mode supplied, aborting.");
        }
    }

    private void createSnapshot(String name, List<String> types) throws FrameworkException {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            File snapshotFile = SnapshotCommand.locateFile(name, true);
            try (FileWriter writer = new FileWriter(snapshotFile);){
                JsonSchema schema = StructrSchema.createFromDatabase((App)app, types);
                ((Writer)writer).append(schema.toString());
                ((Writer)writer).append("\n");
                ((Writer)writer).flush();
            }
            tx.success();
        }
        catch (IOException | URISyntaxException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void restoreSnapshot(String fileName) throws FrameworkException {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            block29: {
                if (fileName != null) {
                    File snapshotFile = SnapshotCommand.locateFile(fileName, false);
                    try (FileReader reader = new FileReader(snapshotFile);){
                        JsonSchema schema = StructrSchema.createFromSource((Reader)reader);
                        StructrSchema.replaceDatabaseSchema((App)app, (JsonSchema)schema);
                        break block29;
                    }
                    catch (InvalidSchemaException iex) {
                        throw new FrameworkException(422, iex.getMessage());
                    }
                }
                throw new FrameworkException(422, "Please supply schema name to import.");
            }
            tx.success();
        }
        catch (IOException | URISyntaxException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void purgeLocalSchema() throws FrameworkException {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            try {
                JsonSchema schema = StructrSchema.createEmptySchema();
                StructrSchema.replaceDatabaseSchema((App)app, (JsonSchema)schema);
            }
            catch (InvalidSchemaException iex) {
                throw new FrameworkException(422, iex.getMessage());
            }
            tx.success();
        }
        catch (URISyntaxException use) {
            logger.warn("", (Throwable)use);
        }
    }

    private void addSnapshot(String fileName) throws FrameworkException {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            block29: {
                if (fileName != null) {
                    File snapshotFile = SnapshotCommand.locateFile(fileName, false);
                    try (FileReader reader = new FileReader(snapshotFile);){
                        JsonSchema schema = StructrSchema.createFromSource((Reader)reader);
                        StructrSchema.extendDatabaseSchema((App)app, (JsonSchema)schema);
                        break block29;
                    }
                    catch (InvalidSchemaException iex) {
                        throw new FrameworkException(422, iex.getMessage());
                    }
                }
                throw new FrameworkException(422, "Please supply schema name to import.");
            }
            tx.success();
        }
        catch (IOException | URISyntaxException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private void deleteSnapshot(String fileName) throws FrameworkException {
        if (fileName == null) {
            throw new FrameworkException(422, "Please supply schema name to import.");
        }
        File snapshotFile = SnapshotCommand.locateFile(fileName, false);
        snapshotFile.delete();
    }

    public static List<String> listSnapshots() {
        String[] names;
        File baseDir = new File(SnapshotCommand.getSnapshotsPath());
        LinkedList<String> fileNames = new LinkedList<String>();
        if (baseDir.exists() && (names = baseDir.list()) != null) {
            fileNames.addAll(Arrays.asList(names));
        }
        Collections.sort(fileNames);
        return fileNames;
    }

    public static File locateFile(String name, boolean addTimestamp) throws FrameworkException {
        File path;
        File parent;
        String fileName = name;
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = "schema.json";
        }
        if (File.separator.equals("/") && fileName.contains(File.separator) || File.separator.equals("\\") && (fileName.contains("/") || fileName.contains("\\"))) {
            throw new FrameworkException(422, "Only relative file names are allowed, please use the " + Settings.SnapshotsPath.getKey() + " configuration setting to supply a custom path for snapshots.");
        }
        if (addTimestamp) {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
            fileName = format.format(System.currentTimeMillis()) + "-" + fileName;
        }
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(parent = (path = new File(SnapshotCommand.getSnapshotsPath() + fileName)).getParentFile()).exists()) {
            parent.mkdirs();
        }
        return path;
    }

    public static String getSnapshotsPath() {
        return Settings.getFullSettingPath((Setting)Settings.SnapshotsPath);
    }
}

