/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.structr.api.service.LicenseManager;
import org.structr.common.SecurityContext;
import org.structr.common.VersionHelper;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.Result;
import org.structr.core.Services;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalMethodException;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.resource.Resource;

public class EnvResource
extends Resource {
    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        this.securityContext = securityContext;
        return UriPart._env.name().equals(part);
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        LinkedList<GraphObjectMap> resultList = new LinkedList<GraphObjectMap>();
        GraphObjectMap info = new GraphObjectMap();
        info.setProperty((PropertyKey)new GenericProperty("modules"), (Object)VersionHelper.getModules());
        info.setProperty((PropertyKey)new GenericProperty("components"), (Object)VersionHelper.getComponents());
        info.setProperty((PropertyKey)new StringProperty("classPath"), (Object)VersionHelper.getClassPath());
        info.setProperty((PropertyKey)new StringProperty("instanceName"), (Object)VersionHelper.getInstanceName());
        info.setProperty((PropertyKey)new StringProperty("instanceStage"), (Object)VersionHelper.getInstanceStage());
        LicenseManager licenseManager = Services.getInstance().getLicenseManager();
        if (licenseManager != null) {
            info.setProperty((PropertyKey)new StringProperty("edition"), (Object)licenseManager.getEdition());
            info.setProperty((PropertyKey)new StringProperty("licensee"), (Object)licenseManager.getLicensee());
            info.setProperty((PropertyKey)new StringProperty("hostId"), (Object)licenseManager.getHardwareFingerprint());
            info.setProperty((PropertyKey)new StringProperty("startDate"), (Object)licenseManager.getStartDate());
            info.setProperty((PropertyKey)new StringProperty("endDate"), (Object)licenseManager.getEndDate());
        } else {
            info.setProperty((PropertyKey)new StringProperty("edition"), (Object)"Community");
            info.setProperty((PropertyKey)new StringProperty("licensee"), (Object)"Unlicensed");
        }
        resultList.add(info);
        return new Result(resultList, Integer.valueOf(resultList.size()), false, false);
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        throw new IllegalMethodException("POST not allowed on " + this.getResourceSignature());
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        throw new IllegalPathException(this.getResourceSignature() + " has no subresources");
    }

    @Override
    public String getUriPart() {
        return this.getResourceSignature();
    }

    public Class getEntityClass() {
        return null;
    }

    @Override
    public String getResourceSignature() {
        return UriPart._env.name();
    }

    @Override
    public boolean isCollectionResource() throws FrameworkException {
        return false;
    }

    public static enum UriPart {
        _env;

    }
}

