/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.WrappingResource;

public class RelationshipNodeResource
extends WrappingResource {
    private static final Logger logger = LoggerFactory.getLogger((String)RelationshipNodeResource.class.getName());
    private boolean startNode = false;

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.securityContext = securityContext;
        if ("start".equals(part.toLowerCase())) {
            this.startNode = true;
        }
        return true;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        List results = this.wrappedResource.doGet(sortKey, sortDescending, pageSize, page, offsetId).getResults();
        if (results != null && !results.isEmpty()) {
            try {
                LinkedList<NodeInterface> resultList = new LinkedList<NodeInterface>();
                for (GraphObject obj : results) {
                    if (!(obj instanceof AbstractRelationship)) continue;
                    AbstractRelationship rel = (AbstractRelationship)obj;
                    if (this.startNode) {
                        resultList.add(rel.getSourceNode());
                        continue;
                    }
                    resultList.add(rel.getTargetNode());
                }
                return new Result(resultList, null, this.isCollectionResource(), this.isPrimitiveArray());
            }
            catch (Throwable t) {
                logger.warn("Exception while fetching relationships", t);
            }
        } else {
            logger.info("No results from parent..");
        }
        throw new IllegalPathException(this.getResourceSignature() + " can only be applied to a non-empty resource");
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        if (this.wrappedResource != null) {
            return this.wrappedResource.doPost(propertySet);
        }
        throw new IllegalPathException(this.getResourceSignature() + " can only be applied to a non-empty resource");
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        return super.tryCombineWith(next);
    }

    @Override
    public String getResourceSignature() {
        return this.getUriPart();
    }
}

