/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.SchemaMethod;
import org.structr.core.entity.SchemaNode;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalMethodException;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.resource.SortableResource;
import org.structr.rest.resource.TypeResource;
import org.structr.schema.action.Actions;

public class SchemaMethodResource
extends SortableResource {
    private static final Logger logger = LoggerFactory.getLogger(SchemaMethodResource.class);
    private TypeResource typeResource = null;
    private TypeResource methodResource = null;
    private String source = null;

    public SchemaMethodResource(SecurityContext securityContext, TypeResource typeResource, TypeResource methodResource) throws IllegalPathException {
        this.typeResource = typeResource;
        this.methodResource = methodResource;
        this.securityContext = securityContext;
        this.source = SchemaMethodResource.findMethodSource(typeResource.getEntityClass(), methodResource.getRawType());
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        return false;
    }

    @Override
    public String getResourceSignature() {
        return this.typeResource.getResourceSignature() + "/" + this.methodResource.getResourceSignature();
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        throw new IllegalMethodException("GET not allowed on " + this.getResourceSignature());
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        RestMethodResult result = null;
        if (this.source != null) {
            try (Tx tx = app.tx();){
                result = SchemaMethodResource.invoke(this.securityContext, null, this.source, propertySet, this.methodResource.getUriPart());
                tx.success();
            }
        }
        if (result == null) {
            throw new IllegalPathException("Type and method name do not match the given path.");
        }
        return result;
    }

    @Override
    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        throw new IllegalMethodException("PUT not allowed on " + this.getResourceSignature());
    }

    public static RestMethodResult invoke(SecurityContext securityContext, GraphObject entity, String source, Map<String, Object> propertySet, String methodName) throws FrameworkException {
        try {
            return SchemaMethodResource.wrapInResult(Actions.execute((SecurityContext)securityContext, (GraphObject)entity, (String)("${" + source.trim() + "}"), propertySet, (String)methodName));
        }
        catch (UnlicensedException ex) {
            ex.log(logger);
            return new RestMethodResult(500, "Call to unlicensed function, see server log file for more details.");
        }
    }

    public static RestMethodResult wrapInResult(Object obj) {
        RestMethodResult result = null;
        if (obj instanceof RestMethodResult) {
            result = (RestMethodResult)obj;
        } else {
            result = new RestMethodResult(200);
            SchemaMethodResource.unwrapTo(obj, result);
        }
        return result;
    }

    public static String findMethodSource(Class type, String methodName) throws IllegalPathException {
        try {
            App app = StructrApp.getInstance();
            String typeName = type.getSimpleName();
            Class currentType = type;
            SchemaNode schemaNode = (SchemaNode)app.nodeQuery(SchemaNode.class).andName(typeName).getFirst();
            while (schemaNode != null) {
                for (SchemaMethod method : (List)schemaNode.getProperty((PropertyKey)SchemaNode.schemaMethods)) {
                    if (!methodName.equals(method.getName())) continue;
                    return (String)method.getProperty((PropertyKey)SchemaMethod.source);
                }
                if ((currentType = currentType.getSuperclass()) != null) {
                    if (currentType.getSimpleName().equals(typeName) || !currentType.getName().startsWith("org.structr.dynamic.")) {
                        currentType = currentType.getSuperclass();
                    }
                    if (currentType != null && currentType.getName().startsWith("org.structr.dynamic.")) {
                        schemaNode = (SchemaNode)app.nodeQuery(SchemaNode.class).andName(currentType.getSimpleName()).getFirst();
                        continue;
                    }
                }
                break;
            }
        }
        catch (FrameworkException frameworkException) {
            // empty catch block
        }
        throw new IllegalPathException("Type and method name do not match the given path.");
    }

    public static void unwrapTo(Object source, RestMethodResult result) {
        if (source != null) {
            Object unwrapped = Context.jsToJava((Object)source, (Class)ScriptRuntime.ObjectClass);
            if (unwrapped.getClass().isArray()) {
                for (Object element : (Object[])unwrapped) {
                    SchemaMethodResource.unwrapTo(element, result);
                }
            } else if (unwrapped instanceof Collection) {
                for (Object element : (Collection)unwrapped) {
                    SchemaMethodResource.unwrapTo(element, result);
                }
            } else if (unwrapped instanceof GraphObject) {
                result.addContent((GraphObject)unwrapped);
            } else {
                result.setNonGraphObjectResult(unwrapped);
            }
        }
    }

    private Method determineMethod(Class type, String methodName) throws IllegalPathException {
        Method result = null;
        try {
            result = type.getMethod(methodName, Map.class);
        }
        catch (NoSuchMethodException ignore) {
            Map methods = StructrApp.getConfiguration().getExportedMethodsForType(type);
            result = (Method)methods.get(methodName);
        }
        return result;
    }
}

