/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.Relation;
import org.structr.core.entity.relationship.SchemaRelationship;
import org.structr.core.graph.search.SearchCommand;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.RelationProperty;
import org.structr.core.property.StringProperty;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalMethodException;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.SchemaTypeResource;
import org.structr.rest.resource.TypeResource;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.SchemaHelper;

public class SchemaResource
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaResource.class.getName());
    private static final StringProperty urlProperty = new StringProperty("url");
    private static final StringProperty typeProperty = new StringProperty("type");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final StringProperty classNameProperty = new StringProperty("className");
    private static final StringProperty extendsClassNameProperty = new StringProperty("extendsClass");
    private static final BooleanProperty isRelProperty = new BooleanProperty("isRel");
    private static final LongProperty flagsProperty = new LongProperty("flags");
    private static final GenericProperty relatedToProperty = new GenericProperty("relatedTo");
    private static final GenericProperty relatedFromProperty = new GenericProperty("relatedFrom");
    private static final GenericProperty possibleSourceTypesProperty = new GenericProperty("possibleSourceTypes");
    private static final GenericProperty possibleTargetTypesProperty = new GenericProperty("possibleTargetTypes");
    private static final BooleanProperty allSourceTypesPossibleProperty = new BooleanProperty("allSourceTypesPossible");
    private static final BooleanProperty allTargetTypesPossibleProperty = new BooleanProperty("allTargetTypesPossible");
    private static final BooleanProperty htmlSourceTypesPossibleProperty = new BooleanProperty("htmlSourceTypesPossible");
    private static final BooleanProperty htmlTargetTypesPossibleProperty = new BooleanProperty("htmlTargetTypesPossible");

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        this.securityContext = securityContext;
        return UriPart._schema.name().equals(part);
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        return SchemaResource.getSchemaOverviewResult();
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        throw new IllegalMethodException("POST not allowed on " + this.getResourceSignature());
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof TypeResource) {
            SchemaTypeResource schemaTypeResource = new SchemaTypeResource(this.securityContext, (TypeResource)next);
            return schemaTypeResource;
        }
        if (next != null) {
            logger.warn("Trying to combine SchemaResource with {}.", (Object)next.getClass().getName());
        } else {
            logger.warn("Trying to combine SchemaResource with null.");
        }
        throw new IllegalPathException("Illegal path, /" + this.getResourceSignature() + " must be followed by a type resource");
    }

    @Override
    public String getUriPart() {
        return "";
    }

    public Class getEntityClass() {
        return null;
    }

    @Override
    public String getResourceSignature() {
        return UriPart._schema.name();
    }

    @Override
    public boolean isCollectionResource() throws FrameworkException {
        return true;
    }

    public static Result getSchemaOverviewResult() throws FrameworkException {
        LinkedList<GraphObjectMap> resultList = new LinkedList<GraphObjectMap>();
        ConfigurationProvider config = StructrApp.getConfiguration();
        Set nodeEntityKeys = config.getNodeEntities().keySet();
        Set relEntityKeys = config.getRelationshipEntities().keySet();
        HashSet entityKeys = new HashSet();
        entityKeys.addAll(nodeEntityKeys);
        entityKeys.addAll(relEntityKeys);
        for (String rawType : entityKeys) {
            Class type = SchemaHelper.getEntityClassForRawType((String)rawType);
            GraphObjectMap schema = new GraphObjectMap();
            resultList.add(schema);
            if (type == null) continue;
            String url = "/".concat(rawType);
            boolean isRel = AbstractRelationship.class.isAssignableFrom(type);
            schema.setProperty((PropertyKey)urlProperty, (Object)url);
            schema.setProperty((PropertyKey)typeProperty, (Object)type.getSimpleName());
            schema.setProperty((PropertyKey)nameProperty, (Object)type.getSimpleName());
            schema.setProperty((PropertyKey)classNameProperty, (Object)type.getName());
            schema.setProperty((PropertyKey)extendsClassNameProperty, (Object)type.getSuperclass().getName());
            schema.setProperty((PropertyKey)isRelProperty, (Object)isRel);
            schema.setProperty((PropertyKey)flagsProperty, (Object)SecurityContext.getResourceFlags((String)rawType));
            if (isRel) continue;
            LinkedList<GraphObjectMap> relatedTo = new LinkedList<GraphObjectMap>();
            LinkedList<GraphObjectMap> relatedFrom = new LinkedList<GraphObjectMap>();
            for (PropertyKey key : config.getPropertySet(type, "all")) {
                RelationProperty relationProperty;
                Relation relation;
                if (!(key instanceof RelationProperty) || (relation = (relationProperty = (RelationProperty)key).getRelation()).isHidden()) continue;
                switch (relation.getDirectionForType(type)) {
                    case OUTGOING: {
                        relatedTo.add(SchemaResource.relationPropertyToMap(config, relationProperty));
                        break;
                    }
                    case INCOMING: {
                        relatedFrom.add(SchemaResource.relationPropertyToMap(config, relationProperty));
                        break;
                    }
                    case BOTH: {
                        relatedTo.add(SchemaResource.relationPropertyToMap(config, relationProperty));
                        relatedFrom.add(SchemaResource.relationPropertyToMap(config, relationProperty));
                    }
                }
            }
            if (!relatedTo.isEmpty()) {
                schema.setProperty((PropertyKey)relatedToProperty, relatedTo);
            }
            if (relatedFrom.isEmpty()) continue;
            schema.setProperty((PropertyKey)relatedFromProperty, relatedFrom);
        }
        return new Result(resultList, Integer.valueOf(resultList.size()), false, false);
    }

    private static GraphObjectMap relationPropertyToMap(ConfigurationProvider config, RelationProperty relationProperty) {
        GraphObjectMap map = new GraphObjectMap();
        Relation relation = relationProperty.getRelation();
        map.put((PropertyKey)SchemaRelationship.sourceMultiplicity, (Object)SchemaResource.multiplictyToString(relation.getSourceMultiplicity()));
        map.put((PropertyKey)SchemaRelationship.targetMultiplicity, (Object)SchemaResource.multiplictyToString(relation.getTargetMultiplicity()));
        map.put((PropertyKey)typeProperty, (Object)relation.getClass().getSimpleName());
        map.put((PropertyKey)SchemaRelationship.relationshipType, (Object)relation.name());
        Class sourceType = relation.getSourceType();
        Class targetType = relation.getTargetType();
        if (sourceType.isAssignableFrom(AbstractNode.class)) {
            map.put((PropertyKey)allSourceTypesPossibleProperty, (Object)true);
            map.put((PropertyKey)htmlSourceTypesPossibleProperty, (Object)true);
            map.put((PropertyKey)possibleSourceTypesProperty, null);
        } else if ("DOMNode".equals(sourceType.getSimpleName())) {
            map.put((PropertyKey)allTargetTypesPossibleProperty, (Object)false);
            map.put((PropertyKey)htmlTargetTypesPossibleProperty, (Object)true);
            map.put((PropertyKey)possibleTargetTypesProperty, null);
        } else {
            map.put((PropertyKey)allSourceTypesPossibleProperty, (Object)false);
            map.put((PropertyKey)htmlSourceTypesPossibleProperty, (Object)false);
            map.put((PropertyKey)possibleSourceTypesProperty, (Object)StringUtils.join((Iterable)SearchCommand.getAllSubtypesAsStringSet((String)sourceType.getSimpleName()), (String)","));
        }
        if (targetType.isAssignableFrom(AbstractNode.class)) {
            map.put((PropertyKey)allTargetTypesPossibleProperty, (Object)true);
            map.put((PropertyKey)htmlTargetTypesPossibleProperty, (Object)true);
            map.put((PropertyKey)possibleTargetTypesProperty, null);
        } else if ("DOMNode".equals(targetType.getSimpleName())) {
            map.put((PropertyKey)allTargetTypesPossibleProperty, (Object)false);
            map.put((PropertyKey)htmlTargetTypesPossibleProperty, (Object)true);
            map.put((PropertyKey)possibleTargetTypesProperty, null);
        } else {
            map.put((PropertyKey)allTargetTypesPossibleProperty, (Object)false);
            map.put((PropertyKey)htmlTargetTypesPossibleProperty, (Object)false);
            map.put((PropertyKey)possibleTargetTypesProperty, (Object)StringUtils.join((Iterable)SearchCommand.getAllSubtypesAsStringSet((String)targetType.getSimpleName()), (String)","));
        }
        return map;
    }

    private static String multiplictyToString(Relation.Multiplicity multiplicity) {
        switch (multiplicity) {
            case One: {
                return "1";
            }
            case Many: {
                return "*";
            }
        }
        return null;
    }

    public static enum UriPart {
        _schema;

    }
}

