/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.structr.common.GraphObjectComparator;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorToken;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.InvalidSortKey;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.property.PropertyKey;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.WrappingResource;

public class SortResource
extends WrappingResource {
    private String sortOrder = null;
    private String sortKey = null;

    public SortResource(SecurityContext securityContext, String sortKey, String sortOrder) {
        this.securityContext = securityContext;
        this.sortKey = sortKey;
        this.sortOrder = sortOrder;
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.sortKey = request.getParameter("sort");
        this.sortOrder = request.getParameter("order");
        return this.sortKey != null;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        if (this.wrappedResource != null) {
            Result result = this.wrappedResource.doGet(sortKey, sortDescending, pageSize, page, offsetId);
            try {
                Collections.sort(result.getResults(), new GraphObjectComparator(sortKey, this.sortOrder));
            }
            catch (Throwable t) {
                throw new FrameworkException(422, "Unable to sort results by " + sortKey.jsonName() + ": " + t.toString(), (ErrorToken)new InvalidSortKey(GraphObject.class.getSimpleName(), sortKey));
            }
            return result;
        }
        throw new IllegalPathException("Illegal path, sort resource needs a wrapped resource");
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        return super.tryCombineWith(next);
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    @Override
    public void postProcessResultSet(Result result) {
        result.setSortOrder(this.sortOrder);
        result.setSortKey(this.sortKey);
    }

    @Override
    public String getResourceSignature() {
        return this.wrappedResource.getResourceSignature();
    }
}

