/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.property.PropertyKey;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.exception.NotFoundException;
import org.structr.rest.resource.FilterableResource;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.TypeResource;

public class UuidResource
extends FilterableResource {
    private static final Logger logger = LoggerFactory.getLogger((String)UuidResource.class.getName());
    private String uuid = null;

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        GraphObject obj = this.getEntity();
        if (obj != null) {
            return new Result(obj, this.isPrimitiveArray());
        }
        throw new NotFoundException("Entity with ID " + this.getUuid() + " not found");
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.securityContext = securityContext;
        this.setUuid(part);
        return true;
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof TypeResource) {
            throw new IllegalPathException("Cannot resolve URL path, no type resource expected here");
        }
        return super.tryCombineWith(next);
    }

    public GraphObject getEntity() throws FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        GraphObject entity = app.nodeQuery().uuid(this.uuid).getFirst();
        if (entity == null) {
            entity = app.relationshipQuery().uuid(this.uuid).getFirst();
        }
        if (entity == null) {
            throw new NotFoundException("Entity with ID " + this.uuid + " not found");
        }
        return entity;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getUriPart() {
        return this.uuid;
    }

    @Override
    public String getResourceSignature() {
        return "/";
    }

    @Override
    public boolean isCollectionResource() {
        return false;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

