/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.serialization;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.util.html.Attr;
import org.structr.api.util.html.Document;
import org.structr.api.util.html.Tag;
import org.structr.api.util.html.attr.AtDepth;
import org.structr.api.util.html.attr.Css;
import org.structr.api.util.html.attr.Href;
import org.structr.api.util.html.attr.If;
import org.structr.api.util.html.attr.Onload;
import org.structr.api.util.html.attr.Type;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.SchemaNode;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.rest.serialization.RestWriter;

public class StructrJsonHtmlWriter
implements RestWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrJsonHtmlWriter.class.getName());
    private static final Set<String> hiddenViews = new LinkedHashSet<String>();
    private static final int CLOSE_LEVEL = 5;
    private static final String LI = "li";
    private static final String UL = "ul";
    private final String restPath = StringUtils.removeEnd((String)((String)Settings.RestServletPath.getValue()), (String)"/*");
    private SecurityContext securityContext = null;
    private Document doc = null;
    private Tag currentElement = null;
    private GraphObject currentObject = null;
    private Tag previousElement = null;
    private boolean hasName = false;
    private String lastName = null;
    private String propertyView = "";

    public StructrJsonHtmlWriter(SecurityContext securityContext, PrintWriter rawWriter) {
        this.securityContext = securityContext;
        this.doc = new Document(rawWriter);
    }

    @Override
    public void setIndent(String indent) {
        this.doc.setIndent(indent);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public RestWriter beginDocument(String baseUrl, String propertyView) throws IOException {
        String currentType = baseUrl.replace(this.restPath + "/", "").replace("/" + propertyView, "");
        if (!propertyView.equals("public")) {
            this.propertyView = "/" + propertyView;
        }
        Tag head = this.doc.block("head");
        head.inline("style").attr(new Attr[]{new Type("text/css")}).text(new Object[]{"body,html{font-family:\"Liberation Mono\",\"DejaVu Sans Mono\",Consolas,Monaco,\"Vera Sans Mono\",\"Lucida Console\",\"Courier New\",monospace!important;font-size:9pt;padding:0;margin:0}div#top{border-bottom:1px solid #a5a5a5;line-height:2em;background:#363636;background:-webkit-gradient(linear,left bottom,left top,from(#363636),to(#666)) no-repeat;background:-moz-linear-gradient(90deg,#363636,#666) no-repeat;filter:progid:DXImageTransform.Microsoft.Gradient(StartColorStr='#666666', EndColorStr='#363636', GradientType=0);padding:20px;font-family:Arial,Helvetica,Sans-serif}div#top a{color:#fff;text-decoration:none;font-weight:700;margin-right:1em}div#left{background-color:#eee;padding:10px 20px}div#left a{color:#666;text-decoration:none;font-weight:700;margin-right:1em}div#right{clear:both;padding-left:20px}ul{list-style-type:none}b{font-weight:700;color:#444}a.id,a.id:visited{color:#00a}span.type{font-weight:400;color:#080}span.id{font-weight:400;color:#999}span.name{font-weight:700;color:#666}span.string{color:#c60}span.boolean,span.number{color:#00a}span.null{color:#999}.collapsibleListOpen{list-style-image:url(data:image/gif;base64,R0lGODlhBwAHAOcYAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1tbW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///yH5BAEKAP8ALAAAAAAHAAcAAAgRAP8JHEiwoMF/mRImPMjwYEAAOw==);cursor:pointer;}.collapsibleListClosed{list-style-image:url(data:image/gif;base64,R0lGODlhBwAHAOcYAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1tbW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///yH5BAEKAP8ALAAAAAAHAAcAAAgXAP8JHEgwE0GBBgdmWriw4MF/CR8KDAgAOw==);cursor:pointer}.collapsibleList{cursor:default}button.collapse,button.expand{font-family:\"Liberation Mono\",\"DejaVu Sans Mono\",Consolas,Monaco,\"Vera Sans Mono\",\"Lucida Console\",\"Courier New\",monospace!important;float:right;margin:-.3em 1em 0 0}li.collapsibleListClosed>ul.collapsibleList>li{display:none}li.collapsibleListClosed>ul.collapsibleList::before{content:\"\u2026\"}li.collapsibleListClosed>ul.collapsibleList:empty{display:none}li.collapsibleListClosed>ul.collapsibleList{line-height:11px;display:inline-block;border:1px solid #aaa;border-radius:6px;padding-left:2px;cursor:pointer;background-color:#ddd;padding-right:3px;margin-left:-5px;margin-right:-5px;font-family:initial}"});
        head.inline("script").attr(new Attr[]{new Type("text/javascript")}).text(new Object[]{"var CollapsibleLists=new function(){function g(b){return function(a){a||(a=window.event);for(a=a.target?a.target:a.srcElement;\"LI\"!=a.nodeName;)a=a.parentNode;a==b&&f(b)}}function f(b){for(var a=b.className.match(/(^| )collapsibleListClosed( |$)/),c=b.getElementsByTagName(\"ul\"),d=0;d<c.length;d++){for(var e=c[d];\"LI\"!=e.nodeName;)e=e.parentNode}b.className=b.className.replace(/(^| )collapsibleList(Open|Closed)( |$)/,\"\");0<c.length&&(b.className+=\" collapsibleList\"+\n(a?\"Open\":\"Closed\"))}this.apply=function(b){for(var a=document.getElementsByTagName(\"ul\"),c=0;c<a.length;c++)if(a[c].className.match(/(^| )collapsibleList( |$)/)&&(this.applyTo(a[c],!0),!b))for(var d=a[c].getElementsByTagName(\"ul\"),e=0;e<d.length;e++)d[e].className+=\" collapsibleList\"};this.applyTo=function(b,a){for(var c=b.getElementsByTagName(\"li\"),d=0;d<c.length;d++)a&&b!=c[d].parentNode||(c[d].addEventListener?c[d].addEventListener(\"click\",g(c[d]),!1):c[d].attachEvent(\"onclick\",g(c[d])),f(c[d]))};\nthis.openAll=function(){var b = [].slice.call(document.getElementsByClassName(\"collapsibleListClosed\")); [].forEach.call(b, function (el) { f(el); });};this.closeAll=function(){var b = [].slice.call(document.getElementsByClassName(\"collapsibleListOpen\")); [].forEach.call(b, function (el) { f(el); });}};"});
        head.inline("title").text(new Object[]{baseUrl});
        Tag body = this.doc.block("body").attr(new Attr[]{new Onload("if (document.querySelectorAll('#right > ul > li > ul > li > ul.collapsibleList > li').length > 5) { CollapsibleLists.apply(true); }")});
        Tag top = body.block("div").id("top");
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        Tag left = body.block("div").id("left");
        left.inline("button").attr(new Attr[]{new Css("collapse right")}).attr(new Attr[]{new Attr("onclick", (Object)"CollapsibleLists.closeAll()")}).text(new Object[]{" - "});
        left.inline("button").attr(new Attr[]{new Css("expand right")}).attr(new Attr[]{new Attr("onclick", (Object)"CollapsibleLists.openAll()")}).text(new Object[]{" + "});
        try (Tx tx = app.tx();){
            List schemaNodes = app.nodeQuery(SchemaNode.class).getAsList();
            Collections.sort(schemaNodes);
            for (SchemaNode node : schemaNodes) {
                String rawType = node.getName();
                top.inline("a").attr(new Attr[]{new Href(this.restPath + "/" + rawType), new If(rawType.equals(currentType), (Attr)new Css("active"))}).text(new Object[]{rawType});
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        for (String view : StructrApp.getConfiguration().getPropertyViews()) {
            if (hiddenViews.contains(view)) continue;
            left.inline("a").attr(new Attr[]{new Href(this.restPath + "/" + currentType + "/" + view), new If(view.equals(propertyView), (Attr)new Css("active"))}).text(new Object[]{view});
        }
        this.currentElement = body.block("div").id("right");
        this.currentElement.block("h1").text(new Object[]{baseUrl});
        this.currentElement = this.currentElement.block(UL);
        return this;
    }

    @Override
    public RestWriter endDocument() throws IOException {
        this.doc.render();
        return this;
    }

    @Override
    public RestWriter beginArray() throws IOException {
        this.currentElement.inline("span").text(new Object[]{"["});
        this.currentElement = this.currentElement.block(UL).attr(new Attr[]{new AtDepth(5, (Attr)new Css("collapsibleList"))});
        this.hasName = false;
        return this;
    }

    @Override
    public RestWriter endArray() throws IOException {
        this.currentElement = this.currentElement.parent();
        this.currentElement.inline("span").text(new Object[]{"]"});
        this.previousElement = this.currentElement;
        this.currentElement = this.currentElement.parent();
        return this;
    }

    @Override
    public RestWriter beginObject() throws IOException {
        return this.beginObject(null);
    }

    @Override
    public RestWriter beginObject(GraphObject graphObject) throws IOException {
        this.currentObject = graphObject;
        if (!this.hasName) {
            this.currentElement = this.currentElement.block(LI);
        }
        this.currentElement.inline("span").text(new Object[]{"{"});
        this.currentElement = this.currentElement.block(UL).attr(new Attr[]{new AtDepth(5, (Attr)new Css("collapsibleList"))});
        this.hasName = false;
        return this;
    }

    @Override
    public RestWriter endObject() throws IOException {
        return this.endObject(null);
    }

    @Override
    public RestWriter endObject(GraphObject graphObject) throws IOException {
        this.currentElement = this.currentElement.parent();
        this.currentElement.inline("span").text(new Object[]{"}"});
        this.previousElement = this.currentElement;
        this.currentElement = this.currentElement.parent();
        return this;
    }

    @Override
    public RestWriter name(String name) throws IOException {
        if (this.previousElement != null) {
            this.previousElement.appendComma();
        }
        this.previousElement = this.currentElement;
        this.currentElement = this.currentElement.block(LI);
        this.currentElement.inline("b").text(new Object[]{"\"", name, "\":"});
        this.lastName = name;
        this.hasName = true;
        return this;
    }

    @Override
    public RestWriter value(String value) throws IOException {
        if (!this.hasName) {
            this.currentElement = this.currentElement.block(LI);
        }
        if ("id".equals(this.lastName)) {
            if (this.currentObject == null) {
                this.currentElement.inline("a").css("id").attr(new Attr[]{new Href(this.restPath + "/" + value + this.propertyView)}).text(new Object[]{"\"", value, "\""});
            } else if (this.currentObject instanceof AbstractRelationship) {
                this.currentElement.inline("a").css("id").attr(new Attr[]{new Href(this.restPath + "/" + (String)this.currentObject.getProperty((PropertyKey)AbstractRelationship.type) + "/" + value + this.propertyView)}).text(new Object[]{"\"", value, "\""});
            } else {
                this.currentElement.inline("a").css("id").attr(new Attr[]{new Href(this.restPath + "/" + this.currentObject.getType() + "/" + value + this.propertyView)}).text(new Object[]{"\"", value, "\""});
            }
        } else {
            value = value.replaceAll("\\\\", "\\\\\\\\");
            value = value.replaceAll("\"", "\\\\\\\"");
            value = StringUtils.replaceEach((String)value, (String[])new String[]{"&", "<", ">"}, (String[])new String[]{"&amp;", "&lt;", "&gt;"});
            this.currentElement.inline("span").css("string").text(new Object[]{"\"", value, "\""});
        }
        this.currentElement = this.currentElement.parent();
        this.hasName = false;
        return this;
    }

    @Override
    public RestWriter nullValue() throws IOException {
        if (!this.hasName) {
            this.currentElement = this.currentElement.block(LI);
        }
        this.currentElement.inline("span").css("null").text(new Object[]{"null"});
        this.currentElement = this.currentElement.parent();
        this.hasName = false;
        return this;
    }

    @Override
    public RestWriter value(boolean value) throws IOException {
        if (!this.hasName) {
            this.currentElement = this.currentElement.block(LI);
        }
        this.currentElement.inline("span").css("boolean").text(new Object[]{value});
        this.currentElement = this.currentElement.parent();
        this.hasName = false;
        return this;
    }

    @Override
    public RestWriter value(double value) throws IOException {
        if (!this.hasName) {
            this.currentElement = this.currentElement.block(LI);
        }
        this.currentElement.inline("span").css("number").text(new Object[]{value});
        this.currentElement = this.currentElement.parent();
        this.hasName = false;
        return this;
    }

    @Override
    public RestWriter value(long value) throws IOException {
        if (!this.hasName) {
            this.currentElement = this.currentElement.block(LI);
        }
        this.currentElement.inline("span").css("number").text(new Object[]{value});
        this.currentElement = this.currentElement.parent();
        this.hasName = false;
        return this;
    }

    @Override
    public RestWriter value(Number value) throws IOException {
        if (!this.hasName) {
            this.currentElement = this.currentElement.block(LI);
        }
        this.currentElement.inline("span").css("number").text(new Object[]{value});
        this.currentElement = this.currentElement.parent();
        this.hasName = false;
        return this;
    }

    static {
        hiddenViews.add("all");
        hiddenViews.add("_html_");
        hiddenViews.add("ui");
    }
}

