/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.service;

import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.servlet.TeeFilter;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.chemistry.opencmis.server.impl.CmisRepositoryContextListener;
import org.apache.chemistry.opencmis.server.impl.atompub.CmisAtomPubServlet;
import org.apache.chemistry.opencmis.server.impl.browser.CmisBrowserBindingServlet;
import org.apache.chemistry.opencmis.server.shared.BasicAuthCallContextHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.AsyncGzipFilter;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.service.Command;
import org.structr.api.service.Feature;
import org.structr.api.service.LicenseManager;
import org.structr.api.service.RunnableService;
import org.structr.api.service.StructrServices;
import org.structr.core.Services;
import org.structr.rest.ResourceProvider;
import org.structr.rest.service.HttpServiceLifecycleListener;
import org.structr.rest.service.HttpServiceServlet;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;

public class HttpService
implements RunnableService {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpService.class.getName());
    private final Set<ResourceProvider> resourceProviders = new LinkedHashSet<ResourceProvider>();
    private HashSessionManager hashSessionManager = null;
    private HttpConfiguration httpConfig = null;
    private HttpConfiguration httpsConfig = null;
    private Server server = null;
    private int maxIdleTime = 30000;
    private int requestHeaderSize = 8192;

    public void startService() throws Exception {
        logger.info("Starting {} (host={}:{}, maxIdleTime={}, requestHeaderSize={})", new Object[]{Settings.ApplicationTitle.getValue(), Settings.ApplicationHost.getValue(), Settings.HttpPort.getValue(), this.maxIdleTime, this.requestHeaderSize});
        logger.info("Base path {}", (Object)Settings.getBasePath());
        logger.info("{} started at http://{}:{}", new Object[]{Settings.ApplicationTitle.getValue(), Settings.ApplicationHost.getValue(), Settings.HttpPort.getValue()});
        this.server.start();
        try {
            while (!this.server.isStarted()) {
                Thread.sleep(100L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.removeDir(Settings.getBasePath(), "jsp");
        this.sendLifecycleEvent(LifecycleEvent.Started);
    }

    public void stopService() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                logger.warn("Exception while stopping Jetty: {}", (Object)ex.getMessage());
            }
        }
    }

    public boolean runOnStartup() {
        return true;
    }

    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices services) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        File baseDir;
        LicenseManager licenseManager = services.getLicenseManager();
        boolean isTest = Services.isTesting();
        String sourceJarName = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        if (!isTest && StringUtils.stripEnd((String)sourceJarName, (String)System.getProperty("file.separator")).endsWith("classes")) {
            String jarFile = System.getProperty("jarFile");
            if (StringUtils.isEmpty((CharSequence)jarFile)) {
                throw new IllegalArgumentException(this.getClass().getName() + " was started in an environment where the classloader cannot determine the JAR file containing the main class.\nPlease specify the path to the JAR file in the parameter -DjarFile.\nExample: -DjarFile=${project.build.directory}/${project.artifactId}-${project.version}.jar");
            }
            sourceJarName = jarFile;
        }
        this.maxIdleTime = Services.parseInt((String)System.getProperty("maxIdleTime"), (int)30000);
        this.requestHeaderSize = Services.parseInt((String)System.getProperty("requestHeaderSize"), (int)8192);
        if (((Boolean)Settings.Async.getValue()).booleanValue()) {
            logger.info("Running in asynchronous mode");
        }
        String keyStorePath = (String)Settings.KeystorePath.getValue();
        String keyStorePassword = (String)Settings.KeystorePassword.getValue();
        String contextPath = System.getProperty("contextPath", "/");
        boolean enableHttps = (Boolean)Settings.HttpsEnabled.getValue();
        boolean enableGzipCompression = (Boolean)Settings.GzipCompression.getValue();
        boolean logRequests = (Boolean)Settings.RequestLogging.getValue();
        String logPrefix = (String)Settings.LogPrefix.getValue();
        String host = (String)Settings.ApplicationHost.getValue();
        int httpsPort = (Integer)Settings.HttpsPort.getValue();
        boolean enableRewriteFilter = true;
        String basePath = System.getProperty("home", Settings.getBasePath());
        if (StringUtils.isEmpty((CharSequence)basePath)) {
            basePath = System.getProperty("user.dir", "/tmp");
        }
        if (!(baseDir = new File(basePath)).exists()) {
            baseDir.mkdirs();
        }
        this.server = new Server(((Integer)Settings.HttpPort.getValue()).intValue());
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.addHandler((Handler)new DefaultHandler());
        ServletContextHandler servletContext = new ServletContextHandler((HandlerContainer)this.server, contextPath, true, true);
        LinkedList<ServerConnector> connectors = new LinkedList<ServerConnector>();
        try {
            servletContext.setBaseResource((Resource)new ResourceCollection(new Resource[]{Resource.newResource((String)basePath), JarResource.newJarResource((Resource)Resource.newResource((String)sourceJarName))}));
        }
        catch (Throwable t) {
            logger.warn("Base resource {} not usable: {}", new Object[]{basePath, t.getMessage()});
        }
        servletContext.addServlet("org.eclipse.jetty.servlet.DefaultServlet", "/");
        servletContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        if (((Boolean)Settings.ConfigServletEnabled.getValue()).booleanValue()) {
            servletContext.addServlet("org.structr.rest.servlet.ConfigServlet", "/structr/config/*");
        }
        if (((Boolean)Settings.CmisEnabled.getValue()).booleanValue() && (licenseManager == null || licenseManager.isModuleLicensed("cmis"))) {
            try {
                servletContext.addEventListener((EventListener)new CmisRepositoryContextListener());
                ServletHolder cmisAtomHolder = servletContext.addServlet(CmisAtomPubServlet.class.getName(), "/structr/cmis/atom/*");
                cmisAtomHolder.setInitParameter("callContextHandler", BasicAuthCallContextHandler.class.getName());
                cmisAtomHolder.setInitParameter("cmisVersion", "1.1");
                ServletHolder cmisBrowserHolder = servletContext.addServlet(CmisBrowserBindingServlet.class.getName(), "/structr/cmis/browser/*");
                cmisBrowserHolder.setInitParameter("callContextHandler", BasicAuthCallContextHandler.class.getName());
                cmisBrowserHolder.setInitParameter("cmisVersion", "1.1");
            }
            catch (Throwable t) {
                logger.warn("Cannot initialize CMIS servlet", t);
            }
        }
        this.hashSessionManager = new HashSessionManager();
        try {
            this.hashSessionManager.setStoreDirectory(new File(baseDir + "/sessions"));
        }
        catch (IOException ex) {
            logger.warn("Could not set custom session manager with session store directory {}/sessions", (Object)baseDir);
        }
        servletContext.getSessionHandler().setSessionManager((SessionManager)this.hashSessionManager);
        if (enableRewriteFilter) {
            FilterHolder rewriteFilter = new FilterHolder(UrlRewriteFilter.class);
            rewriteFilter.setInitParameter("confPath", "urlrewrite.xml");
            servletContext.addFilter(rewriteFilter, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC));
        }
        if (enableGzipCompression) {
            FilterHolder gzipFilter = (Boolean)Settings.Async.getValue() != false ? new FilterHolder(AsyncGzipFilter.class) : new FilterHolder(GzipFilter.class);
            gzipFilter.setInitParameter("mimeTypes", "text/html,text/plain,text/css,text/javascript,application/json");
            gzipFilter.setInitParameter("bufferSize", "32768");
            gzipFilter.setInitParameter("minGzipSize", "256");
            gzipFilter.setInitParameter("deflateCompressionLevel", "9");
            gzipFilter.setInitParameter("methods", "GET,POST,PUT,HEAD,DELETE");
            servletContext.addFilter(gzipFilter, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC));
        }
        contexts.addHandler((Handler)servletContext);
        if (logRequests) {
            String logbackConfFilePath;
            Object logbackConfFile;
            String etcPath = basePath + "/etc";
            File etcDir = new File(etcPath);
            if (!etcDir.exists()) {
                etcDir.mkdir();
            }
            if (!((File)(logbackConfFile = new File(logbackConfFilePath = basePath + "/etc/logback-access.xml"))).exists()) {
                LinkedList<String> config = new LinkedList<String>();
                config.add("<configuration>");
                config.add("  <appender name=\"FILE\" class=\"ch.qos.logback.core.rolling.RollingFileAppender\">");
                config.add("    <rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">");
                config.add("      <fileNamePattern>logs/" + logPrefix + "-%d{yyyy_MM_dd}.request.log.zip</fileNamePattern>");
                config.add("    </rollingPolicy>");
                config.add("    <encoder>");
                config.add("      <charset>UTF-8</charset>");
                config.add("      <pattern>%h %l %u %t \"%r\" %s %b %n%fullRequest%n%n%fullResponse</pattern>");
                config.add("    </encoder>");
                config.add("  </appender>");
                config.add("  <appender-ref ref=\"FILE\" />");
                config.add("</configuration>");
                try {
                    ((File)logbackConfFile).createNewFile();
                    FileUtils.writeLines((File)logbackConfFile, (String)"UTF-8", config);
                }
                catch (IOException ioex) {
                    logger.warn("Unable to write logback configuration.", (Throwable)ioex);
                }
            }
            FilterHolder loggingFilter = new FilterHolder(TeeFilter.class);
            servletContext.addFilter(loggingFilter, "/*", EnumSet.of(DispatcherType.REQUEST, (Boolean)Settings.Async.getValue() != false ? DispatcherType.ASYNC : DispatcherType.FORWARD));
            loggingFilter.setInitParameter("includes", "");
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            String logPath = basePath + "/logs";
            File logDir = new File(logPath);
            if (!logDir.exists()) {
                logDir.mkdir();
            }
            RequestLogImpl requestLog = new RequestLogImpl();
            requestLog.setName("REQUESTLOG");
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{contexts, requestLogHandler});
            this.server.setHandler((Handler)handlers);
        } else {
            this.server.setHandler((Handler)contexts);
        }
        List<ContextHandler> resourceHandler = this.collectResourceHandlers();
        for (ContextHandler contextHandler : resourceHandler) {
            contexts.addHandler((Handler)contextHandler);
        }
        Map<String, ServletHolder> servlets = this.collectServlets(licenseManager);
        int position = 1;
        for (Map.Entry<String, ServletHolder> servlet : servlets.entrySet()) {
            ServletHolder servletHolder = servlet.getValue();
            String path = servlet.getKey();
            servletHolder.setInitOrder(position++);
            logger.info("Adding servlet {} for {}", new Object[]{servletHolder, path});
            servletContext.addServlet(servletHolder, path);
        }
        contexts.addHandler((Handler)servletContext);
        if (StringUtils.isNotBlank((CharSequence)host) && (Integer)Settings.HttpPort.getValue() > -1) {
            this.httpConfig = new HttpConfiguration();
            this.httpConfig.setSecureScheme("https");
            this.httpConfig.setSecurePort(httpsPort);
            this.httpConfig.setRequestHeaderSize(this.requestHeaderSize);
            ServerConnector httpConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(this.httpConfig)});
            httpConnector.setHost(host);
            httpConnector.setPort(((Integer)Settings.HttpPort.getValue()).intValue());
            connectors.add(httpConnector);
        } else {
            logger.warn("Unable to configure HTTP server port, please make sure that {} and {} are set correctly in structr.conf.", (Object)Settings.ApplicationHost.getKey(), (Object)Settings.HttpPort.getKey());
        }
        if (enableHttps) {
            if (httpsPort > -1 && keyStorePath != null && !keyStorePath.isEmpty() && keyStorePassword != null) {
                this.httpsConfig = new HttpConfiguration(this.httpConfig);
                this.httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setKeyStorePath(keyStorePath);
                sslContextFactory.setKeyStorePassword(keyStorePassword);
                ServerConnector https = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(this.httpsConfig)});
                https.setPort(httpsPort);
                https.setIdleTimeout(500000L);
                https.setHost(host);
                https.setPort(httpsPort);
                connectors.add(https);
            } else {
                logger.warn("Unable to configure SSL, please make sure that {}, {} and {} are set correctly in structr.conf.", new Object[]{Settings.HttpsPort.getKey(), Settings.KeystorePath.getKey(), Settings.KeystorePassword.getKey()});
            }
        }
        if (!connectors.isEmpty()) {
            this.server.setConnectors(connectors.toArray(new Connector[0]));
        } else {
            logger.error("No connectors configured, aborting.");
            System.exit(0);
        }
        this.server.setStopTimeout(1000L);
        this.server.setStopAtShutdown(true);
    }

    public void initialized() {
    }

    public void shutdown() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                logger.warn("Error while stopping Jetty server: {}", (Object)ex.getMessage());
            }
        }
        this.sendLifecycleEvent(LifecycleEvent.Stopped);
    }

    public String getName() {
        return HttpService.class.getName();
    }

    public boolean isVital() {
        return true;
    }

    public String getModuleName() {
        return "rest";
    }

    public Set<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    public HashSessionManager getHashSessionManager() {
        return this.hashSessionManager;
    }

    private List<ContextHandler> collectResourceHandlers() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LinkedList<ContextHandler> resourceHandlers = new LinkedList<ContextHandler>();
        String resourceHandlerList = (String)Settings.ResourceHandlers.getValue();
        if (resourceHandlerList != null) {
            for (String resourceHandlerName : resourceHandlerList.split("[ \\t]+")) {
                if (!StringUtils.isNotBlank((CharSequence)resourceHandlerName)) continue;
                String contextPath = (String)Settings.getOrCreateStringSetting((String[])new String[]{resourceHandlerName, "contextPath"}).getValue();
                if (contextPath != null) {
                    String resourceBase = (String)Settings.getOrCreateStringSetting((String[])new String[]{resourceHandlerName, "resourceBase"}).getValue();
                    if (resourceBase != null) {
                        ResourceHandler resourceHandler = new ResourceHandler();
                        resourceHandler.setDirectoriesListed(((Boolean)Settings.getBooleanSetting((String[])new String[]{resourceHandlerName, "directoriesListed"}).getValue()).booleanValue());
                        String welcomeFiles = (String)Settings.getOrCreateStringSetting((String[])new String[]{resourceHandlerName, "welcomeFiles"}).getValue();
                        if (welcomeFiles != null) {
                            resourceHandler.setWelcomeFiles(StringUtils.split((String)welcomeFiles));
                        }
                        resourceHandler.setResourceBase(resourceBase);
                        resourceHandler.setCacheControl("max-age=0");
                        resourceHandler.setEtags(true);
                        ContextHandler staticResourceHandler = new ContextHandler();
                        staticResourceHandler.setContextPath(contextPath);
                        staticResourceHandler.setHandler((Handler)resourceHandler);
                        resourceHandlers.add(staticResourceHandler);
                        continue;
                    }
                    logger.warn("Unable to register resource handler {}, missing {}.resourceBase", (Object)resourceHandlerName, (Object)resourceHandlerName);
                    continue;
                }
                logger.warn("Unable to register resource handler {}, missing {}.contextPath", (Object)resourceHandlerName, (Object)resourceHandlerName);
            }
        } else {
            logger.warn("No resource handlers configured for HttpService.");
        }
        return resourceHandlers;
    }

    private Map<String, ServletHolder> collectServlets(LicenseManager licenseManager) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LinkedHashMap<String, ServletHolder> servlets = new LinkedHashMap<String, ServletHolder>();
        String servletNameList = (String)Settings.Servlets.getValue();
        if (servletNameList != null) {
            for (String servletName : servletNameList.split("[ \\t]+")) {
                if (!StringUtils.isNotBlank((CharSequence)servletName)) continue;
                String servletClassName = (String)Settings.getOrCreateStringSetting((String[])new String[]{servletName, "class"}).getValue();
                if (servletClassName != null) {
                    String servletPath = (String)Settings.getOrCreateStringSetting((String[])new String[]{servletName, "path"}).getValue();
                    if (servletPath != null) {
                        try {
                            HttpServlet servlet = (HttpServlet)Class.forName(servletClassName).newInstance();
                            if (!(servlet instanceof HttpServiceServlet)) continue;
                            HttpServiceServlet httpServiceServlet = (HttpServiceServlet)servlet;
                            if (licenseManager != null && !licenseManager.isValid((Feature)httpServiceServlet)) continue;
                            httpServiceServlet.getConfig().initializeFromSettings(servletName, this.resourceProviders);
                            if (servletPath.endsWith("*")) {
                                servlets.put(servletPath, new ServletHolder((Servlet)servlet));
                                continue;
                            }
                            servlets.put(servletPath + "/*", new ServletHolder((Servlet)servlet));
                        }
                        catch (ClassNotFoundException nfex) {
                            logger.warn("Unable to instantiate servlet class {} for servlet {}", (Object)servletClassName, (Object)servletName);
                        }
                        continue;
                    }
                    logger.warn("Unable to register servlet {}, missing {}.path", (Object)servletName, (Object)servletName);
                    continue;
                }
                logger.warn("Unable to register servlet {}, missing {}.class", (Object)servletName, (Object)servletName);
            }
        } else {
            logger.warn("No servlets configured for HttpService.");
        }
        return servlets;
    }

    private void removeDir(String basePath, String directoryName) {
        String strippedBasePath = StringUtils.stripEnd((String)basePath, (String)"/");
        File file = new File(strippedBasePath + "/" + directoryName);
        if (file.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException ex) {
                logger.error("Unable to delete directory {}: {}", new Object[]{directoryName, ex.getMessage()});
            }
        } else {
            file.delete();
        }
    }

    private void sendLifecycleEvent(LifecycleEvent event) {
        String listeners = (String)Settings.LifecycleListeners.getValue();
        if (listeners != null) {
            String[] listenerClasses;
            for (String listenerClass : listenerClasses = listeners.split("[\\s ,;]+")) {
                if (!StringUtils.isNotBlank((CharSequence)listenerClass)) continue;
                try {
                    HttpServiceLifecycleListener listener = (HttpServiceLifecycleListener)Class.forName(listenerClass).newInstance();
                    switch (event) {
                        case Started: {
                            listener.serverStarted();
                            break;
                        }
                        case Stopped: {
                            listener.serverStopped();
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    logger.error("Unable to send lifecycle event to listener " + listenerClass, (Throwable)ex);
                }
            }
        }
    }

    private static enum LifecycleEvent {
        Started,
        Stopped;

    }
}

