/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.service;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.core.auth.Authenticator;
import org.structr.rest.ResourceProvider;
import org.structr.schema.compiler.NodeExtender;

public class StructrHttpServiceConfig {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrHttpServiceConfig.class.getName());
    private String defaultPropertyView = "public";
    private ResourceProvider resourceProvider = null;
    private Class authenticatorClass = null;
    private boolean userAutoCreate = false;
    private boolean userAutoLogin = false;
    private int outputNestingDepth = 3;

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    public String getDefaultPropertyView() {
        return this.defaultPropertyView;
    }

    public int getOutputNestingDepth() {
        return this.outputNestingDepth;
    }

    public void initializeFromSettings(String servletName, Set<ResourceProvider> resourceProviders) throws InstantiationException, IllegalAccessException {
        String resourceProviderKeyName = "resourceprovider";
        String authenticatorKeyName = "authenticator";
        String userAutoCreateKeyName = "user.autocreate";
        String userAutoLoginKeyName = "user.autologin";
        String defaultPropertyKeyName = "defaultview";
        String nestingDepthKeyName = "outputdepth";
        String resourceProviderValue = (String)Settings.getOrCreateStringSetting((String[])new String[]{servletName, "resourceprovider"}).getValue();
        String authenticatorValue = (String)Settings.getOrCreateStringSetting((String[])new String[]{servletName, "authenticator"}).getValue();
        if (StringUtils.isBlank((CharSequence)resourceProviderValue)) {
            logger.error("Missing resource provider key {}.resourceprovider in configuration file.", (Object)servletName);
            throw new IllegalStateException("No resource provider set for servlet " + servletName);
        }
        Class providerClass = this.loadClass(resourceProviderValue);
        if (providerClass == null) {
            logger.error("Unable to initialize resource provider for servlet {}, no resource provider found. Please check structr.conf for a valid resource provider class.", (Object)servletName);
            throw new IllegalStateException("No resource provider available for servlet " + servletName);
        }
        this.resourceProvider = (ResourceProvider)providerClass.newInstance();
        resourceProviders.add(this.resourceProvider);
        if (StringUtils.isBlank((CharSequence)authenticatorValue)) {
            logger.error("Missing authenticator key {}.authenticator in configuration file.", (Object)servletName);
        } else {
            this.authenticatorClass = this.loadClass(authenticatorValue);
            if (this.authenticatorClass == null) {
                logger.error("Unable to instantiate authenticator {}", (Object)authenticatorValue);
            }
        }
        this.defaultPropertyView = (String)Settings.getOrCreateStringSetting((String[])new String[]{servletName, "defaultview"}).getValue();
        this.outputNestingDepth = (Integer)Settings.getOrCreateIntegerSetting((String[])new String[]{servletName, "outputdepth"}).getValue();
    }

    public Authenticator getAuthenticator() {
        Authenticator authenticator = null;
        if (this.authenticatorClass == null) {
            logger.error("No authenticator class loaded. Check log for 'Missing authenticator key'.");
            return null;
        }
        try {
            authenticator = (Authenticator)this.authenticatorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException t) {
            logger.error("Unable to instantiate authenticator {}: {}", new Object[]{this.authenticatorClass, t.getMessage()});
        }
        return authenticator;
    }

    private Class loadClass(String name) {
        ClassLoader loader = NodeExtender.getClassLoader();
        Class<?> loadedClass = null;
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            loadedClass = Class.forName(name, true, loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (loadedClass == null) {
            try {
                loadedClass = Class.forName(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return loadedClass;
    }
}

