/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Setting;
import org.structr.api.config.Settings;
import org.structr.api.config.SettingsGroup;
import org.structr.api.util.html.Attr;
import org.structr.api.util.html.Document;
import org.structr.api.util.html.Tag;
import org.structr.api.util.html.attr.Href;
import org.structr.api.util.html.attr.Rel;
import org.structr.core.Services;

public class ConfigServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ConfigServlet.class);
    private static final Set<String> authenticatedSessions = new HashSet<String>();
    private static final String ConfigUrl = "/structr/config";
    private static final String ConfigName = "structr.conf";
    private static final String TITLE = "Structr Configuration Editor";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthenticated(request)) {
            response.setContentType("text/html; charset=utf-8");
            try (PrintWriter writer = new PrintWriter(response.getWriter());){
                Document doc = this.createLoginDocument(request, writer);
                doc.render();
                writer.append("\n");
                writer.flush();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        } else if (request.getParameter("reload") != null) {
            Settings.loadConfiguration((String)ConfigName);
            response.sendRedirect(ConfigUrl);
        } else if (request.getParameter("reset") != null) {
            String key = request.getParameter("reset");
            Setting setting = Settings.getSetting((String[])new String[]{key});
            if (setting != null) {
                if (setting.isDynamic()) {
                    setting.unregister();
                } else {
                    setting.setValue(setting.getDefaultValue());
                }
            }
            Settings.storeConfiguration((String)ConfigName);
            response.sendRedirect(ConfigUrl);
        } else if (request.getParameter("start") != null) {
            String serviceName = request.getParameter("start");
            if (serviceName != null && this.isAuthenticated(request)) {
                Services.getInstance().startService(serviceName);
            }
            response.sendRedirect("/structr/config#services");
        } else if (request.getParameter("stop") != null) {
            String serviceName = request.getParameter("stop");
            if (serviceName != null && this.isAuthenticated(request)) {
                Services.getInstance().shutdownService(serviceName);
            }
            response.sendRedirect("/structr/config#services");
        } else if (request.getParameter("restart") != null) {
            final String serviceName = request.getParameter("restart");
            if (serviceName != null && this.isAuthenticated(request)) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Services.getInstance().shutdownService(serviceName);
                        Services.getInstance().startService(serviceName);
                    }
                }).start();
            }
            response.sendRedirect("/structr/config#services");
        } else {
            response.setContentType("text/html; charset=utf-8");
            try (PrintWriter writer = new PrintWriter(response.getWriter());){
                Document doc = this.createConfigDocument(request, writer);
                doc.render();
                writer.append("\n");
                writer.flush();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        String redirectTarget = "";
        if (action != null) {
            switch (action) {
                case "login": {
                    if (!((String)Settings.SuperUserPassword.getValue()).equals(request.getParameter("password"))) break;
                    this.authenticateSession(request);
                    break;
                }
                case "logout": {
                    this.invalidateSession(request);
                }
            }
        } else if (this.isAuthenticated(request)) {
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                String value = this.getFirstElement((String[])entry.getValue());
                String key = (String)entry.getKey();
                SettingsGroup parent = null;
                if (key.endsWith("._settings_group")) continue;
                if ("active_section".equals(key)) {
                    redirectTarget = "#" + value;
                    continue;
                }
                Setting setting = Settings.getSetting((String[])new String[]{key});
                if (setting == null) {
                    String group = request.getParameter(key + "._settings_group");
                    if (group != null) {
                        parent = Settings.getGroup((String)group);
                        if (parent == null) {
                            parent = Settings.miscGroup;
                        }
                    } else {
                        parent = Settings.miscGroup;
                    }
                    setting = Settings.createSettingForValue((SettingsGroup)parent, (String)key, (String)value);
                }
                setting.fromString(value);
            }
            Settings.storeConfiguration((String)ConfigName);
        }
        response.sendRedirect(ConfigUrl + redirectTarget);
    }

    private Document createConfigDocument(HttpServletRequest request, PrintWriter writer) {
        Document doc = new Document(writer);
        Tag body = this.setupDocument(request, doc);
        Tag form = body.block("form").css("config-form");
        Tag main = form.block("div").id("main");
        Tag tabs = main.block("div").id("configTabs");
        Tag menu = tabs.block("ul").id("configTabsMenu");
        form.attr(new Attr[]{new Attr("action", (Object)ConfigUrl), new Attr("method", (Object)"post")});
        for (SettingsGroup group : Settings.getGroups()) {
            String key = group.getKey();
            String name = group.getName();
            menu.block("li").block("a").id(key + "Menu").attr(new Attr[]{new Attr("href", (Object)("#" + key))}).block("span").text(new Object[]{name});
            Tag container = tabs.block("div").css("tab-content").id(key);
            group.render(container);
            container.block("div").attr(new Attr[]{new Style("clear: both;")});
        }
        menu.block("li").block("a").id("servicesMenu").attr(new Attr[]{new Attr("href", (Object)"#services")}).block("span").text(new Object[]{"Services"});
        Services services = Services.getInstance();
        Tag container = tabs.block("div").css("tab-content").id("services");
        Tag table = container.block("table").id("services-table");
        Tag header = table.block("tr");
        header.block("th").text(new Object[]{"Service Name"});
        header.block("th").attr(new Attr[]{new Attr("colspan", (Object)"2")});
        for (String serviceClassName : services.getServices()) {
            Class serviceClass = services.getServiceClassForName(serviceClassName);
            boolean running = serviceClass != null ? services.isReady(serviceClass) : false;
            Tag row = table.block("tr");
            row.block("td").text(new Object[]{serviceClassName});
            if (running) {
                row.block("td").block("button").attr(new Attr[]{new Type("button"), new OnClick("window.location.href='/structr/config?restart=" + serviceClassName + "';")}).text(new Object[]{"Restart"});
                if ("HttpService".equals(serviceClassName)) {
                    row.block("td");
                } else {
                    row.block("td").block("button").attr(new Attr[]{new Type("button"), new OnClick("window.location.href='/structr/config?stop=" + serviceClassName + "';")}).text(new Object[]{"Stop"});
                }
                row.block("td");
                continue;
            }
            row.block("td");
            row.block("td");
            row.block("td").block("button").attr(new Attr[]{new Type("button"), new OnClick("window.location.href='/structr/config?start=" + serviceClassName + "';")}).text(new Object[]{"Start"});
        }
        container.empty("input").attr(new Attr[]{new Type("hidden"), new Name("active_section")}).id("active_section");
        container.block("div").attr(new Attr[]{new Style("clear: both;")});
        Tag buttons = form.block("div").css("buttons");
        buttons.block("button").attr(new Attr[]{new Type("button")}).id("new-entry-button").text(new Object[]{"Add entry"});
        buttons.block("button").attr(new Attr[]{new Type("button"), new OnClick("window.location.href='/structr/config?reload';")}).text(new Object[]{"Reload configuration file"});
        buttons.empty("input").attr(new Attr[]{new Type("submit"), new Value("Save to structr.conf")});
        body.block("script").text(new Object[]{"$('#new-entry-button').on('click', createNewEntry);"});
        return doc;
    }

    private Document createLoginDocument(HttpServletRequest request, PrintWriter writer) {
        Document doc = new Document(writer);
        Tag body = this.setupDocument(request, doc).css("login");
        Tag loginBox = body.block("div").id("login").css("dialog").attr(new Attr[]{new Style("display: block; margin: auto; margin-top: 200px;")});
        loginBox.block("i").attr(new Attr[]{new Attr("title", (Object)"Structr Logo")}).css("logo-login sprite sprite-structr_gray_100x27");
        loginBox.block("p").text(new Object[]{"Welcome to the Structr Configuration Editor. Please log in with the <b>super- user</b> password which can be found in your structr.conf."});
        Tag form = loginBox.block("form").attr(new Attr[]{new Attr("action", (Object)ConfigUrl), new Attr("method", (Object)"post")});
        Tag table = form.block("table");
        Tag row1 = table.block("tr");
        row1.block("td").block("label").attr(new Attr[]{new Attr("for", (Object)"passwordField")}).text(new Object[]{"Password:"});
        row1.block("td").empty("input").id("passwordField").attr(new Attr[]{new Type("password"), new Name("password")});
        Tag row2 = table.block("tr");
        Tag cell13 = row2.block("td").attr(new Attr[]{new Attr("colspan", (Object)"2")}).css("btn");
        Tag button = cell13.block("button").id("loginButton").attr(new Attr[]{new Name("login")});
        button.block("i").css("sprite sprite-key");
        button.block("span").text(new Object[]{" Login"});
        cell13.empty("input").attr(new Attr[]{new Type("hidden"), new Name("action"), new Value("login")});
        return doc;
    }

    private Tag setupDocument(HttpServletRequest request, Document doc) {
        Tag head = doc.block("head");
        head.block("title").text(new Object[]{TITLE});
        head.empty("meta").attr(new Attr[]{new Attr("http-equiv", (Object)"Content-Type"), new Attr("content", (Object)"text/html;charset=utf-8")});
        head.empty("meta").attr(new Attr[]{new Name("viewport"), new Attr("content", (Object)"width=1024, user-scalable=yes")});
        head.empty("link").attr(new Attr[]{new Rel("stylesheet"), new Href("/structr/css/lib/jquery-ui-1.10.3.custom.min.css")});
        head.empty("link").attr(new Attr[]{new Rel("stylesheet"), new Href("/structr/css/main.css")});
        head.empty("link").attr(new Attr[]{new Rel("stylesheet"), new Href("/structr/css/config.css")});
        head.empty("link").attr(new Attr[]{new Rel("icon"), new Href("favicon.ico"), new Type("image/x-icon")});
        head.block("script").attr(new Attr[]{new Src("/structr/js/lib/jquery-1.11.1.min.js")});
        head.block("script").attr(new Attr[]{new Src("/structr/js/lib/jquery-ui-1.11.0.custom.min.js")});
        head.block("script").attr(new Attr[]{new Src("/structr/js/config.js")});
        Tag body = doc.block("body");
        Tag header = body.block("div").id("header");
        header.block("i").css("logo sprite sprite-structr-logo");
        Tag links = header.block("div").id("menu").css("menu").block("ul");
        if (this.isAuthenticated(request)) {
            Tag form = links.block("li").block("form").attr(new Attr[]{new Attr("action", (Object)ConfigUrl), new Attr("method", (Object)"post"), new Style("display: none")}).id("logout-form");
            form.empty("input").attr(new Attr[]{new Type("hidden"), new Name("action"), new Value("logout")});
            links.block("a").text(new Object[]{"Logout"}).attr(new Attr[]{new Style("cursor: pointer"), new OnClick("$('#logout-form').submit();")});
        }
        return body;
    }

    private boolean isAuthenticated(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session != null) {
            String sessionId = session.getId();
            if (sessionId != null) {
                return authenticatedSessions.contains(sessionId);
            }
            logger.warn("Cannot check HTTP session without session ID, ignoring.");
        } else {
            logger.warn("Cannot check HTTP request, no session.");
        }
        return false;
    }

    private void authenticateSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session != null) {
            String sessionId = session.getId();
            if (sessionId != null) {
                authenticatedSessions.add(sessionId);
            } else {
                logger.warn("Cannot authenticate HTTP session without session ID, ignoring.");
            }
        } else {
            logger.warn("Cannot authenticate HTTP request, no session.");
        }
    }

    private void invalidateSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session != null) {
            String sessionId = session.getId();
            if (sessionId != null) {
                authenticatedSessions.remove(sessionId);
            } else {
                logger.warn("Cannot invalidate HTTP session without session ID, ignoring.");
            }
        } else {
            logger.warn("Cannot invalidate HTTP request, no session.");
        }
    }

    private String getFirstElement(String[] values) {
        if (values != null && values.length == 1) {
            return values[0];
        }
        return null;
    }

    private static class OnClick
    extends Attr {
        public OnClick(Object value) {
            super("onclick", value);
        }
    }

    private static class Value
    extends Attr {
        public Value(Object value) {
            super("value", value);
        }
    }

    private static class Name
    extends Attr {
        public Name(Object value) {
            super("name", value);
        }
    }

    private static class Type
    extends Attr {
        public Type(Object value) {
            super("type", value);
        }
    }

    private static class Src
    extends Attr {
        public Src(Object value) {
            super("src", value);
        }
    }

    private static class Style
    extends Attr {
        public Style(Object value) {
            super("style", value);
        }
    }
}

