/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqprivate;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.iqprivate.packet.DefaultPrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateDataIQ;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PrivateDataManager
extends Manager {
    private static final Map<XMPPConnection, PrivateDataManager> instances = new WeakHashMap<XMPPConnection, PrivateDataManager>();
    private static Map<String, PrivateDataProvider> privateDataProviders = new Hashtable<String, PrivateDataProvider>();

    public static synchronized PrivateDataManager getInstanceFor(XMPPConnection connection) {
        PrivateDataManager privateDataManager = instances.get(connection);
        if (privateDataManager == null) {
            privateDataManager = new PrivateDataManager(connection);
        }
        return privateDataManager;
    }

    public static PrivateDataProvider getPrivateDataProvider(String elementName, String namespace) {
        String key = PrivateDataManager.getProviderKey(elementName, namespace);
        return privateDataProviders.get(key);
    }

    public static void addPrivateDataProvider(String elementName, String namespace, PrivateDataProvider provider) {
        String key = PrivateDataManager.getProviderKey(elementName, namespace);
        privateDataProviders.put(key, provider);
    }

    public static void removePrivateDataProvider(String elementName, String namespace) {
        String key = PrivateDataManager.getProviderKey(elementName, namespace);
        privateDataProviders.remove(key);
    }

    private PrivateDataManager(XMPPConnection connection) {
        super(connection);
        instances.put(connection, this);
    }

    public PrivateData getPrivateData(String elementName, String namespace) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PrivateDataIQ privateDataGet = new PrivateDataIQ(elementName, namespace);
        PrivateDataIQ response = (PrivateDataIQ)this.connection().createPacketCollectorAndSend((IQ)privateDataGet).nextResultOrThrow();
        return response.getPrivateData();
    }

    public void setPrivateData(PrivateData privateData) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PrivateDataIQ privateDataSet = new PrivateDataIQ(privateData);
        this.connection().createPacketCollectorAndSend((IQ)privateDataSet).nextResultOrThrow();
    }

    private static String getProviderKey(String elementName, String namespace) {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(elementName).append("/><").append(namespace).append("/>");
        return buf.toString();
    }

    public static class PrivateDataIQProvider
    extends IQProvider<PrivateDataIQ> {
        public PrivateDataIQ parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
            PrivateData privateData = null;
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    String namespace;
                    String elementName = parser.getName();
                    PrivateDataProvider provider = PrivateDataManager.getPrivateDataProvider(elementName, namespace = parser.getNamespace());
                    if (provider != null) {
                        privateData = provider.parsePrivateData(parser);
                        continue;
                    }
                    DefaultPrivateData data = new DefaultPrivateData(elementName, namespace);
                    boolean finished = false;
                    while (!finished) {
                        int event = parser.next();
                        if (event == 2) {
                            String name = parser.getName();
                            if (parser.isEmptyElementTag()) {
                                data.setValue(name, "");
                                continue;
                            }
                            event = parser.next();
                            if (event != 4) continue;
                            String value = parser.getText();
                            data.setValue(name, value);
                            continue;
                        }
                        if (event != 3 || !parser.getName().equals(elementName)) continue;
                        finished = true;
                    }
                    privateData = data;
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("query")) continue;
                done = true;
            }
            return new PrivateDataIQ(privateData);
        }
    }
}

