/*
 * Decompiled with CFR 0.152.
 */
package org.structr.payment.entity;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.ErrorToken;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.EndNodes;
import org.structr.core.property.EnumProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.payment.api.APIError;
import org.structr.payment.api.APIResponse;
import org.structr.payment.api.BeginCheckoutResponse;
import org.structr.payment.api.CheckoutState;
import org.structr.payment.api.ConfirmCheckoutResponse;
import org.structr.payment.api.Payment;
import org.structr.payment.api.PaymentItem;
import org.structr.payment.api.PaymentProvider;
import org.structr.payment.api.PaymentState;
import org.structr.payment.entity.PaymentItemNode;
import org.structr.payment.entity.PaymentItems;
import org.structr.payment.impl.paypal.PayPalErrorToken;
import org.structr.payment.impl.paypal.PayPalPaymentProvider;
import org.structr.payment.impl.stripe.StripePaymentProvider;
import org.structr.schema.SchemaService;

public class PaymentNode
extends AbstractNode
implements Payment {
    public static final Property<List<PaymentItemNode>> items;
    public static final Property<PaymentState> stateProperty;
    public static final Property<String> descriptionProperty;
    public static final Property<String> currencyProperty;
    public static final Property<String> tokenProperty;
    public static final Property<String> billingAgreementId;
    public static final Property<String> note;
    public static final Property<String> billingAddressName;
    public static final Property<String> billingAddressStreet1;
    public static final Property<String> billingAddressStreet2;
    public static final Property<String> billingAddressZip;
    public static final Property<String> billingAddressCity;
    public static final Property<String> billingAddressCountry;
    public static final Property<String> invoiceId;
    public static final Property<String> payerAddressName;
    public static final Property<String> payerAddressStreet1;
    public static final Property<String> payerAddressStreet2;
    public static final Property<String> payerAddressZip;
    public static final Property<String> payerAddressCity;
    public static final Property<String> payerAddressCountry;
    public static final Property<String> payer;
    public static final Property<String> payerBusiness;
    public static final View publicView;
    public static final View uiView;

    @Export
    public GraphObject beginCheckout(String string, String string2, String string3) throws FrameworkException {
        BeginCheckoutResponse beginCheckoutResponse;
        PaymentProvider paymentProvider = this.getPaymentProvider(string);
        if (paymentProvider != null) {
            beginCheckoutResponse = paymentProvider.beginCheckout(this, string2, string3);
            if (CheckoutState.Success.equals((Object)beginCheckoutResponse.getCheckoutState())) {
                GraphObjectMap graphObjectMap = new GraphObjectMap();
                graphObjectMap.put(tokenProperty, (Object)beginCheckoutResponse.getToken());
                return graphObjectMap;
            }
        } else {
            throw new FrameworkException(422, "Payment provider " + string + " not found.");
        }
        this.throwErrors("Unable to begin checkout.", beginCheckoutResponse);
        return null;
    }

    @Export
    public void cancelCheckout(String string, String string2) throws FrameworkException {
        PaymentProvider paymentProvider = this.getPaymentProvider(string);
        if (paymentProvider == null) {
            throw new FrameworkException(422, "Payment provider " + string + " not found.");
        }
        paymentProvider.cancelCheckout(this);
    }

    @Export
    public GraphObject confirmCheckout(String string, String string2, String string3, String string4) throws FrameworkException {
        ConfirmCheckoutResponse confirmCheckoutResponse;
        PaymentProvider paymentProvider = this.getPaymentProvider(string);
        if (paymentProvider != null) {
            confirmCheckoutResponse = paymentProvider.confirmCheckout(this, string2, string3, string4);
            if (CheckoutState.Success.equals((Object)confirmCheckoutResponse.getCheckoutState())) {
                return null;
            }
        } else {
            throw new FrameworkException(422, "Payment provider " + string + " not found.");
        }
        this.throwErrors("Unable to confirm checkout.", confirmCheckoutResponse);
        return null;
    }

    @Override
    public List<PaymentItem> getItems() {
        return new LinkedList<PaymentItem>((Collection)this.getProperty((PropertyKey)items));
    }

    @Override
    public int getTotal() {
        int n = 0;
        for (PaymentItem paymentItem : this.getItems()) {
            n += paymentItem.getAmount() * paymentItem.getQuantity();
        }
        return n;
    }

    @Override
    public String getCurrencyCode() {
        return (String)this.getProperty((PropertyKey)currencyProperty);
    }

    @Override
    public String getToken() {
        return (String)this.getProperty((PropertyKey)tokenProperty);
    }

    @Override
    public void setToken(String string) throws FrameworkException {
        this.setProperty((PropertyKey)tokenProperty, string);
    }

    private PaymentProvider getPaymentProvider(String string) {
        switch (string) {
            case "paypal": {
                return new PayPalPaymentProvider();
            }
            case "stripe": {
                return new StripePaymentProvider();
            }
        }
        return null;
    }

    private void throwErrors(String string, APIResponse aPIResponse) throws FrameworkException {
        ErrorBuffer errorBuffer = new ErrorBuffer();
        for (APIError aPIError : aPIResponse.getErrors()) {
            errorBuffer.add((ErrorToken)new PayPalErrorToken(PaymentNode.class.getSimpleName(), (PropertyKey)AbstractNode.base, aPIError.getErrorCode(), aPIError.getLongMessage()));
        }
        throw new FrameworkException(422, string, errorBuffer);
    }

    @Override
    public String getDescription() {
        return (String)this.getProperty((PropertyKey)descriptionProperty);
    }

    @Override
    public void setDescription(String string) throws FrameworkException {
        this.setProperty((PropertyKey)descriptionProperty, string);
    }

    @Override
    public PaymentState getPaymentState() {
        return (PaymentState)((Object)this.getProperty((PropertyKey)stateProperty));
    }

    @Override
    public void setPaymentState(PaymentState paymentState) throws FrameworkException {
        this.setProperty((PropertyKey)stateProperty, (Object)paymentState);
    }

    @Override
    public String getBillingAddressName() {
        return (String)this.getProperty((PropertyKey)billingAddressName);
    }

    @Override
    public void setBillingAddressName(String string) throws FrameworkException {
        this.setProperty((PropertyKey)billingAddressName, string);
    }

    @Override
    public String getBillingAddressStreet1() {
        return (String)this.getProperty((PropertyKey)billingAddressStreet1);
    }

    @Override
    public void setBillingAddressStreet1(String string) throws FrameworkException {
        this.setProperty((PropertyKey)billingAddressStreet1, string);
    }

    @Override
    public String getBillingAddressStreet2() {
        return (String)this.getProperty((PropertyKey)billingAddressStreet2);
    }

    @Override
    public void setBillingAddressStreet2(String string) throws FrameworkException {
        this.setProperty((PropertyKey)billingAddressStreet2, string);
    }

    @Override
    public String getBillingAddressZip() {
        return (String)this.getProperty((PropertyKey)billingAddressZip);
    }

    @Override
    public void setBillingAddressZip(String string) throws FrameworkException {
        this.setProperty((PropertyKey)billingAddressZip, string);
    }

    @Override
    public String getBillingAddressCity() {
        return (String)this.getProperty((PropertyKey)billingAddressCity);
    }

    @Override
    public void setBillingAddressCity(String string) throws FrameworkException {
        this.setProperty((PropertyKey)billingAddressCity, string);
    }

    @Override
    public String getBillingAddressCountry() {
        return (String)this.getProperty((PropertyKey)billingAddressCountry);
    }

    @Override
    public void setBillingAddressCountry(String string) throws FrameworkException {
        this.setProperty((PropertyKey)billingAddressCountry, string);
    }

    @Override
    public String getPayer() {
        return (String)this.getProperty((PropertyKey)payer);
    }

    @Override
    public void setPayer(String string) throws FrameworkException {
        this.setProperty((PropertyKey)payer, string);
    }

    @Override
    public String getPayerBusiness() {
        return (String)this.getProperty((PropertyKey)payerBusiness);
    }

    @Override
    public void setPayerBusiness(String string) throws FrameworkException {
        this.setProperty((PropertyKey)payerBusiness, string);
    }

    @Override
    public String getPayerAddressName() {
        return (String)this.getProperty((PropertyKey)payerAddressName);
    }

    @Override
    public void setPayerAddressName(String string) throws FrameworkException {
        this.setProperty((PropertyKey)payerAddressName, string);
    }

    @Override
    public String getPayerAddressStreet1() {
        return (String)this.getProperty((PropertyKey)payerAddressStreet1);
    }

    @Override
    public void setPayerAddressStreet1(String string) throws FrameworkException {
        this.setProperty((PropertyKey)payerAddressStreet1, string);
    }

    @Override
    public String getPayerAddressStreet2() {
        return (String)this.getProperty((PropertyKey)payerAddressStreet2);
    }

    @Override
    public void setPayerAddressStreet2(String string) throws FrameworkException {
        this.setProperty((PropertyKey)payerAddressStreet2, string);
    }

    @Override
    public String getPayerAddressZip() {
        return (String)this.getProperty((PropertyKey)payerAddressZip);
    }

    @Override
    public void setPayerAddressZip(String string) throws FrameworkException {
        this.setProperty((PropertyKey)payerAddressZip, string);
    }

    @Override
    public String getPayerAddressCity() {
        return (String)this.getProperty((PropertyKey)payerAddressCity);
    }

    @Override
    public void setPayerAddressCity(String string) throws FrameworkException {
        this.setProperty((PropertyKey)payerAddressCity, string);
    }

    @Override
    public String getPayerAddressCountry() {
        return (String)this.getProperty((PropertyKey)payerAddressCountry);
    }

    @Override
    public void setPayerAddressCountry(String string) throws FrameworkException {
        this.setProperty((PropertyKey)payerAddressCountry, string);
    }

    @Override
    public String getBillingAgreementId() {
        return (String)this.getProperty((PropertyKey)billingAgreementId);
    }

    @Override
    public void setBillingAgreementId(String string) throws FrameworkException {
        this.setProperty((PropertyKey)billingAgreementId, string);
    }

    @Override
    public String getNote() {
        return (String)this.getProperty((PropertyKey)note);
    }

    @Override
    public void setNote(String string) throws FrameworkException {
        this.setProperty((PropertyKey)note, string);
    }

    @Override
    public String getInvoiceId() {
        return (String)this.getProperty((PropertyKey)invoiceId);
    }

    @Override
    public void setInvoiceId(String string) throws FrameworkException {
        this.setProperty((PropertyKey)invoiceId, string);
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"PaymentNode", (String)PaymentNode.class.getName());
        items = new EndNodes("items", PaymentItems.class);
        stateProperty = new EnumProperty("state", PaymentState.class).indexed();
        descriptionProperty = new StringProperty("description").indexed();
        currencyProperty = new StringProperty("currency").indexed();
        tokenProperty = new StringProperty("token").indexed();
        billingAgreementId = new StringProperty("billingAgreementId");
        note = new StringProperty("note");
        billingAddressName = new StringProperty("billingAddressName");
        billingAddressStreet1 = new StringProperty("billingAddressStreet1");
        billingAddressStreet2 = new StringProperty("billingAddressStreet2");
        billingAddressZip = new StringProperty("billingAddressZip");
        billingAddressCity = new StringProperty("billingAddressCity");
        billingAddressCountry = new StringProperty("billingAddressCountry");
        invoiceId = new StringProperty("invoiceId");
        payerAddressName = new StringProperty("payerAddressName");
        payerAddressStreet1 = new StringProperty("payerAddressStreet1");
        payerAddressStreet2 = new StringProperty("payerAddressStreet2");
        payerAddressZip = new StringProperty("payerAddressZip");
        payerAddressCity = new StringProperty("payerAddressCity");
        payerAddressCountry = new StringProperty("payerAddressCountry");
        payer = new StringProperty("payer");
        payerBusiness = new StringProperty("payerBusiness");
        publicView = new View(PaymentNode.class, "public", new Property[]{descriptionProperty, items, currencyProperty, tokenProperty, stateProperty, billingAgreementId, note, billingAddressName, billingAddressStreet1, billingAddressStreet2, billingAddressZip, billingAddressCity, billingAddressCountry, invoiceId, payerAddressName, payerAddressStreet1, payerAddressStreet2, payerAddressZip, payerAddressCity, payerAddressCountry, payer, payerBusiness});
        uiView = new View(PaymentNode.class, "ui", new Property[]{descriptionProperty, items, currencyProperty, tokenProperty, stateProperty, billingAgreementId, note, billingAddressName, billingAddressStreet1, billingAddressStreet2, billingAddressZip, billingAddressCity, billingAddressCountry, invoiceId, payerAddressName, payerAddressStreet1, payerAddressStreet2, payerAddressZip, payerAddressCity, payerAddressCountry, payer, payerBusiness});
    }
}

