/*
 * Decompiled with CFR 0.152.
 */
package org.structr.payment.impl.paypal;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.payment.api.BeginCheckoutResponse;
import org.structr.payment.api.ConfirmCheckoutResponse;
import org.structr.payment.api.Payment;
import org.structr.payment.api.PaymentItem;
import org.structr.payment.api.PaymentProvider;
import org.structr.payment.api.PaymentState;
import org.structr.payment.impl.paypal.PayPalBeginCheckoutResponse;
import org.structr.payment.impl.paypal.PayPalConfirmCheckoutResponse;
import org.structr.payment.impl.paypal.PayPalHelper;
import urn.ebay.api.PayPalAPI.DoExpressCheckoutPaymentResponseType;
import urn.ebay.api.PayPalAPI.GetExpressCheckoutDetailsResponseType;
import urn.ebay.api.PayPalAPI.SetExpressCheckoutResponseType;
import urn.ebay.apis.eBLBaseComponents.AbstractResponseType;
import urn.ebay.apis.eBLBaseComponents.AckCodeType;
import urn.ebay.apis.eBLBaseComponents.AddressType;
import urn.ebay.apis.eBLBaseComponents.CurrencyCodeType;
import urn.ebay.apis.eBLBaseComponents.DoExpressCheckoutPaymentResponseDetailsType;
import urn.ebay.apis.eBLBaseComponents.GetExpressCheckoutDetailsResponseDetailsType;
import urn.ebay.apis.eBLBaseComponents.PaymentActionCodeType;
import urn.ebay.apis.eBLBaseComponents.PaymentDetailsItemType;
import urn.ebay.apis.eBLBaseComponents.PaymentDetailsType;

public class PayPalPaymentProvider
implements PaymentProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)PayPalPaymentProvider.class.getName());

    @Override
    public BeginCheckoutResponse beginCheckout(Payment payment, String string, String string2) throws FrameworkException {
        LinkedList<PaymentDetailsType> linkedList = new LinkedList<PaymentDetailsType>();
        LinkedList<PaymentDetailsItemType> linkedList2 = new LinkedList<PaymentDetailsItemType>();
        PaymentDetailsType paymentDetailsType = new PaymentDetailsType();
        for (PaymentItem paymentItem : payment.getItems()) {
            String string3;
            String string4;
            String string5;
            PaymentDetailsItemType paymentDetailsItemType = new PaymentDetailsItemType();
            paymentDetailsItemType.setAmount(PayPalHelper.getAmountForCurrency(payment.getCurrencyCode(), paymentItem.getAmount()));
            paymentDetailsItemType.setQuantity(Integer.valueOf(paymentItem.getQuantity()));
            String string6 = paymentItem.getName();
            if (string6 != null) {
                paymentDetailsItemType.setName(string6);
            }
            if ((string5 = paymentItem.getDescription()) != null) {
                paymentDetailsItemType.setDescription(string5);
            }
            if ((string4 = paymentItem.getItemUrl()) != null) {
                paymentDetailsItemType.setItemURL(string4);
            }
            if ((string3 = paymentItem.getItemNumber()) != null) {
                paymentDetailsItemType.setNumber(string3);
            }
            linkedList2.add(paymentDetailsItemType);
        }
        paymentDetailsType.setPaymentAction(PaymentActionCodeType.SALE);
        paymentDetailsType.setPaymentDetailsItem(linkedList2);
        paymentDetailsType.setOrderTotal(PayPalHelper.getAmountForCurrency(payment.getCurrencyCode(), payment.getTotal()));
        linkedList.add(paymentDetailsType);
        try {
            SetExpressCheckoutResponseType setExpressCheckoutResponseType = PayPalHelper.getExpressCheckoutToken(linkedList, string, string2);
            if (AckCodeType.SUCCESS.equals((Object)setExpressCheckoutResponseType.getAck())) {
                payment.setToken(setExpressCheckoutResponseType.getToken());
                payment.setPaymentState(PaymentState.open);
                return new PayPalBeginCheckoutResponse((AbstractResponseType)setExpressCheckoutResponseType, setExpressCheckoutResponseType.getToken());
            }
        }
        catch (Throwable throwable) {
            throw new FrameworkException(422, throwable.getMessage());
        }
        throw new FrameworkException(422, "Unknown error.");
    }

    @Override
    public void cancelCheckout(Payment payment) throws FrameworkException {
        try {
            payment.setToken(null);
            payment.setPaymentState(PaymentState.cancelled);
        }
        catch (FrameworkException frameworkException) {
            logger.warn("", (Throwable)frameworkException);
        }
    }

    @Override
    public ConfirmCheckoutResponse confirmCheckout(Payment payment, String string, String string2, String string3) throws FrameworkException {
        try {
            GetExpressCheckoutDetailsResponseType getExpressCheckoutDetailsResponseType = PayPalHelper.getExpressCheckoutResponse(string2);
            if (AckCodeType.SUCCESS.equals((Object)getExpressCheckoutDetailsResponseType.getAck())) {
                GetExpressCheckoutDetailsResponseDetailsType getExpressCheckoutDetailsResponseDetailsType = getExpressCheckoutDetailsResponseType.getGetExpressCheckoutDetailsResponseDetails();
                CurrencyCodeType currencyCodeType = CurrencyCodeType.fromValue((String)payment.getCurrencyCode());
                DoExpressCheckoutPaymentResponseType doExpressCheckoutPaymentResponseType = PayPalHelper.commitExpressCheckout(string, currencyCodeType, payment.getTotal(), string2, string3);
                if (AckCodeType.SUCCESS.equals((Object)doExpressCheckoutPaymentResponseType.getAck())) {
                    String string4;
                    String string5;
                    PayPalConfirmCheckoutResponse payPalConfirmCheckoutResponse = new PayPalConfirmCheckoutResponse((AbstractResponseType)doExpressCheckoutPaymentResponseType);
                    DoExpressCheckoutPaymentResponseDetailsType doExpressCheckoutPaymentResponseDetailsType = doExpressCheckoutPaymentResponseType.getDoExpressCheckoutPaymentResponseDetails();
                    String string6 = doExpressCheckoutPaymentResponseDetailsType.getBillingAgreementID();
                    String string7 = doExpressCheckoutPaymentResponseDetailsType.getNote();
                    AddressType addressType = getExpressCheckoutDetailsResponseDetailsType.getBillingAddress();
                    if (addressType != null) {
                        string5 = addressType.getName();
                        string4 = addressType.getStreet1();
                        String string8 = addressType.getStreet2();
                        String string9 = addressType.getPostalCode();
                        String string10 = addressType.getCityName();
                        String string11 = addressType.getCountryName();
                        payment.setBillingAddressName(string5);
                        payment.setBillingAddressStreet1(string4);
                        payment.setBillingAddressStreet2(string8);
                        payment.setBillingAddressZip(string9);
                        payment.setBillingAddressCity(string10);
                        payment.setBillingAddressCountry(string11);
                    }
                    if ((string5 = getExpressCheckoutDetailsResponseDetailsType.getPayerInfo()) != null) {
                        payment.setPayer(string5.getPayer());
                        payment.setPayerBusiness(string5.getPayerBusiness());
                        string4 = string5.getAddress();
                        if (string4 != null) {
                            payment.setPayerAddressName(string4.getName());
                            payment.setPayerAddressStreet1(string4.getStreet1());
                            payment.setPayerAddressStreet2(string4.getStreet1());
                            payment.setPayerAddressZip(string4.getPostalCode());
                            payment.setPayerAddressCity(string4.getCityName());
                            payment.setPayerAddressCountry(string4.getCountryName());
                        }
                    }
                    payment.setBillingAgreementId(string6);
                    payment.setNote(string7);
                    payment.setInvoiceId(getExpressCheckoutDetailsResponseDetailsType.getInvoiceID());
                    payment.setPaymentState(PaymentState.completed);
                    payment.setToken(null);
                    return payPalConfirmCheckoutResponse;
                }
            }
        }
        catch (Throwable throwable) {
            throw new FrameworkException(422, throwable.getMessage());
        }
        throw new FrameworkException(422, "Unknown error.");
    }
}

