/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.util.PatchedUnitFormat;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.resources.Errors;

class SexagesimalConverter
extends UnitConverter {
    private static final long serialVersionUID = -2119974989555436361L;
    static final double EPS = 1.0E-10;
    static final Unit<Angle> DM = NonSI.DEGREE_ANGLE.transform(new SexagesimalConverter(false, 100.0).inverse()).asType(Angle.class);
    static final Unit<Angle> DMS = NonSI.DEGREE_ANGLE.transform(new SexagesimalConverter(true, 10000.0).inverse()).asType(Angle.class);
    static final Unit<Angle> DMS_SCALED = NonSI.DEGREE_ANGLE.transform(new SexagesimalConverter(true, 1.0).inverse()).asType(Angle.class);
    final boolean hasSeconds;
    final double divider;
    private final UnitConverter inverse;

    private SexagesimalConverter(boolean bl, double d) {
        this.hasSeconds = bl;
        this.divider = d;
        this.inverse = new Inverse(this);
    }

    private SexagesimalConverter(SexagesimalConverter sexagesimalConverter) {
        this.hasSeconds = sexagesimalConverter.hasSeconds;
        this.divider = sexagesimalConverter.divider;
        this.inverse = sexagesimalConverter;
    }

    public final UnitConverter inverse() {
        return this.inverse;
    }

    public double convert(double d) {
        double d2 = MathFunctions.truncate(d);
        d = (d - d2) * 60.0;
        if (this.hasSeconds) {
            double d3 = MathFunctions.truncate(d);
            d = (d - d3) * 60.0;
            d += (d2 * 100.0 + d3) * 100.0;
        } else {
            d += d2 * 100.0;
        }
        return d / this.divider;
    }

    public final BigDecimal convert(BigDecimal bigDecimal, MathContext mathContext) {
        return new BigDecimal(this.convert(bigDecimal.doubleValue()), mathContext);
    }

    public final boolean equals(Object object) {
        return object != null && object.getClass() == ((Object)((Object)this)).getClass() && ((SexagesimalConverter)((Object)object)).divider == this.divider;
    }

    public final int hashCode() {
        return (int)this.divider ^ ((Object)((Object)this)).getClass().hashCode();
    }

    static {
        PatchedUnitFormat.init(DM, "D.M", DMS, "D.MS", DMS_SCALED, "DMS");
    }

    private static final class Inverse
    extends SexagesimalConverter {
        private static final long serialVersionUID = -1928146841653975281L;

        public Inverse(SexagesimalConverter sexagesimalConverter) {
            super(sexagesimalConverter);
        }

        @Override
        public double convert(double d) throws IllegalArgumentException {
            double d2;
            double d3;
            double d4;
            if (this.hasSeconds) {
                d4 = d * this.divider;
                d3 = MathFunctions.truncate(d4 / 10000.0);
                d2 = MathFunctions.truncate((d4 -= 10000.0 * d3) / 100.0);
                d4 -= 100.0 * d2;
            } else {
                d4 = 0.0;
                d2 = d * this.divider;
                d3 = MathFunctions.truncate(d2 / 100.0);
                d2 -= d3 * 100.0;
            }
            if (d2 <= -60.0 || d2 >= 60.0) {
                if (Math.abs(Math.abs(d2) - 100.0) <= 1.0E-8) {
                    d3 = d2 >= 0.0 ? (d3 += 1.0) : (d3 -= 1.0);
                    d2 = 0.0;
                } else {
                    throw Inverse.illegalField(d, d2, 2);
                }
            }
            if (d4 <= -60.0 || d4 >= 60.0) {
                if (Math.abs(Math.abs(d4) - 100.0) <= 1.0E-8) {
                    d2 = d4 >= 0.0 ? (d2 += 1.0) : (d2 -= 1.0);
                    d4 = 0.0;
                } else {
                    throw Inverse.illegalField(d, d4, 3);
                }
            }
            return (d4 / 60.0 + d2) / 60.0 + d3;
        }

        private static IllegalArgumentException illegalField(double d, double d2, int n) {
            return new IllegalArgumentException(Errors.format((short)30, "angle", d, n, d2));
        }
    }
}

